/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphql.validator;

import com.ontotext.models.ErrorMessages;
import com.ontotext.models.extensions.Severity;
import graphql.ErrorClassification;
import graphql.ErrorType;
import graphql.GraphQLError;
import graphql.language.SourceLocation;
import graphql.validation.ValidationError;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class SimpleGraphQlError
implements GraphQLError {
    private final String message;
    private final List<SourceLocation> locations;
    private final transient ErrorClassification errorClassification;

    public SimpleGraphQlError(String message, List<SourceLocation> locations, ErrorClassification errorClassification) {
        this(message, locations, errorClassification, null);
    }

    public SimpleGraphQlError(ValidationError error) {
        this(error.getDescription(), error.getLocations(), (ErrorClassification)error.getErrorType(), error.getQueryPath());
    }

    public SimpleGraphQlError(Severity severity, String message, List<SourceLocation> locations, ErrorClassification errorClassification, List<String> queryPath) {
        String msg = this.mkMessage(message, queryPath);
        this.message = StringUtils.prependIfMissing((String)msg, (CharSequence)(Objects.toString(severity) + ": "), (CharSequence[])new CharSequence[0]);
        this.locations = locations;
        this.errorClassification = errorClassification;
    }

    public SimpleGraphQlError(String message, List<SourceLocation> locations, ErrorClassification errorClassification, List<String> queryPath) {
        this(Severity.ERROR, message, locations, errorClassification, queryPath);
    }

    private String mkMessage(String msg, List<String> queryPath) {
        return StringUtils.capitalize((String)msg) + this.toPath(queryPath);
    }

    public static SimpleGraphQlError newValidationError(SourceLocation sourceLocation, String message) {
        return new SimpleGraphQlError(message, sourceLocation == null ? null : Collections.singletonList(sourceLocation), (ErrorClassification)ErrorType.ValidationError);
    }

    public static SimpleGraphQlError newValidationError(com.ontotext.models.query.SourceLocation sourceLocation, String message) {
        return SimpleGraphQlError.newValidationError(sourceLocation == null ? null : new SourceLocation(sourceLocation.getLine(), sourceLocation.getColumn()), message);
    }

    public static SimpleGraphQlError newValidationErrorMessage(com.ontotext.models.query.SourceLocation sourceLocation, String messageTemplate, Object ... args) {
        return SimpleGraphQlError.newValidationError(sourceLocation == null ? null : new SourceLocation(sourceLocation.getLine(), sourceLocation.getColumn()), ErrorMessages.get((String)messageTemplate, (Object[])args));
    }

    public String getMessage() {
        return this.message;
    }

    public List<SourceLocation> getLocations() {
        return this.locations;
    }

    public ErrorClassification getErrorType() {
        return this.errorClassification;
    }

    private String toPath(List<String> queryPath) {
        if (queryPath == null) {
            return "";
        }
        return String.format(" @ '%s'", String.join((CharSequence)"/", queryPath));
    }

    public String toString() {
        return this.toSpecification().toString();
    }

    public int hashCode() {
        return Objects.hash(this.getMessage());
    }

    public boolean equals(Object error) {
        if (!(error instanceof SimpleGraphQlError)) {
            return false;
        }
        return ((SimpleGraphQlError)error).getMessage().equals(this.getMessage());
    }
}

