/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphql.validator;

import graphql.GraphQLContext;
import graphql.GraphQLError;
import graphql.execution.CoercedVariables;
import graphql.language.Argument;
import graphql.language.ArrayValue;
import graphql.language.NullValue;
import graphql.language.ObjectField;
import graphql.language.ObjectValue;
import graphql.language.Value;
import graphql.language.VariableReference;
import graphql.schema.CoercingParseLiteralException;
import graphql.schema.GraphQLEnumType;
import graphql.schema.GraphQLInputFieldsContainer;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeUtil;
import graphql.schema.visibility.GraphqlFieldVisibility;
import graphql.validation.ArgumentValidationUtil;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class OntoArgumentValidationUtil
extends ArgumentValidationUtil {
    OntoArgumentValidationUtil(Argument argument) {
        super(argument);
    }

    public boolean isValidLiteralValue(Value<?> value, GraphQLType type, GraphQLSchema schema, GraphQLContext graphQlContext, Locale locale) {
        if (value == null || value instanceof NullValue) {
            boolean valid;
            boolean bl = valid = !GraphQLTypeUtil.isNonNull((GraphQLType)type);
            if (!valid) {
                this.handleNullError(value, type);
            }
            return valid;
        }
        if (value instanceof VariableReference) {
            return true;
        }
        if (GraphQLTypeUtil.isNonNull((GraphQLType)type)) {
            return this.isValidLiteralValue(value, GraphQLTypeUtil.unwrapOne((GraphQLType)type), schema, graphQlContext, locale);
        }
        if (type instanceof GraphQLScalarType) {
            Optional<CoercingParseLiteralException> conversionFailure = this.parseLiteral(value, val -> ((GraphQLScalarType)type).getCoercing().parseLiteral(val, CoercedVariables.emptyVariables(), graphQlContext, locale));
            conversionFailure.ifPresent(ex -> this.handleScalarError(value, (GraphQLScalarType)type, (GraphQLError)ex));
            return conversionFailure.isEmpty();
        }
        if (type instanceof GraphQLEnumType) {
            Optional<CoercingParseLiteralException> conversionFailure = this.parseLiteral(value, val -> ((GraphQLEnumType)type).parseLiteral(val, graphQlContext, locale));
            conversionFailure.ifPresent(error -> this.handleEnumError(value, (GraphQLEnumType)type, (GraphQLError)error));
            return conversionFailure.isEmpty();
        }
        if (GraphQLTypeUtil.isList((GraphQLType)type)) {
            return this.isValidLiteralValue(value, (GraphQLList)type, schema, graphQlContext, locale);
        }
        return type instanceof GraphQLInputObjectType && this.isValidLiteralValue(value, (GraphQLInputObjectType)type, schema, graphQlContext, locale);
    }

    private boolean isValidLiteralValue(Value<?> value, GraphQLInputObjectType type, GraphQLSchema schema, GraphQLContext graphQlContext, Locale locale) {
        if (!(value instanceof ObjectValue)) {
            this.handleNotObjectError(value, type);
            return false;
        }
        GraphqlFieldVisibility fieldVisibility = schema.getCodeRegistry().getFieldVisibility();
        ObjectValue objectValue = (ObjectValue)value;
        Map<String, ObjectField> objectFieldMap = this.fieldMap(objectValue);
        boolean valid = true;
        Set<String> missingFields = this.getMissingFields(type, objectFieldMap, fieldVisibility);
        Set nameAliasFields = type.getFieldDefinitions().stream().filter(ioField -> ioField.getDirectives().stream().anyMatch(directive -> directive.getName().equals("nameAlias"))).map(GraphQLInputObjectField::getName).collect(Collectors.toSet());
        nameAliasFields.add("name");
        if (!missingFields.containsAll(nameAliasFields)) {
            missingFields.removeAll(nameAliasFields);
        }
        if (!missingFields.isEmpty()) {
            this.handleMissingFieldsError(value, type, missingFields);
            valid = false;
        }
        for (ObjectField objectField : objectValue.getObjectFields()) {
            GraphQLInputObjectField inputObjectField = fieldVisibility.getFieldDefinition((GraphQLInputFieldsContainer)type, objectField.getName());
            if (inputObjectField == null || this.isValidLiteralValue(objectField.getValue(), (GraphQLType)inputObjectField.getType(), schema, graphQlContext, locale)) continue;
            this.handleFieldNotValidError(objectField, type);
            valid = false;
        }
        return valid;
    }

    private boolean isValidLiteralValue(Value<?> value, GraphQLList type, GraphQLSchema schema, GraphQLContext graphQlContext, Locale locale) {
        GraphQLType wrappedType = type.getWrappedType();
        if (value instanceof ArrayValue) {
            List values = ((ArrayValue)value).getValues();
            boolean valid = true;
            for (int i = 0; i < values.size(); ++i) {
                if (this.isValidLiteralValue((Value)values.get(i), wrappedType, schema, graphQlContext, locale)) continue;
                this.handleFieldNotValidError((Value)values.get(i), wrappedType, i);
                valid = false;
            }
            return valid;
        }
        return this.isValidLiteralValue(value, wrappedType, schema, graphQlContext, locale);
    }

    private Optional<CoercingParseLiteralException> parseLiteral(Value<?> value, Function<Value<?>, Object> coercing) {
        try {
            if (coercing.apply(value) != null) {
                return Optional.empty();
            }
            return Optional.of(new CoercingParseLiteralException("Expected scalar value but got 'null'."));
        }
        catch (CoercingParseLiteralException cple) {
            return Optional.of(cple);
        }
    }

    private Set<String> getMissingFields(GraphQLInputObjectType type, Map<String, ObjectField> objectFieldMap, GraphqlFieldVisibility fieldVisibility) {
        return fieldVisibility.getFieldDefinitions((GraphQLInputFieldsContainer)type).stream().filter(field -> GraphQLTypeUtil.isNonNull((GraphQLType)field.getType())).map(GraphQLInputObjectField::getName).filter(((Predicate<String>)objectFieldMap::containsKey).negate()).collect(Collectors.toSet());
    }

    private Map<String, ObjectField> fieldMap(ObjectValue objectValue) {
        LinkedHashMap<String, ObjectField> result = new LinkedHashMap<String, ObjectField>();
        for (ObjectField objectField : objectValue.getObjectFields()) {
            result.put(objectField.getName(), objectField);
        }
        return result;
    }
}

