/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphql.validator;

import com.ontotext.graphql.validator.OntoArgumentValidationUtil;
import graphql.i18n.I18n;
import graphql.i18n.I18nMsg;
import graphql.language.Argument;
import graphql.language.ArrayValue;
import graphql.language.ObjectField;
import graphql.language.ObjectValue;
import graphql.language.Value;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLEnumType;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLNamedType;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeUtil;
import graphql.validation.AbstractRule;
import graphql.validation.ValidationContext;
import graphql.validation.ValidationErrorCollector;
import graphql.validation.ValidationErrorType;
import java.util.Locale;
import java.util.Optional;

public class AllArgumentsOfCorrectType
extends AbstractRule {
    private static final String MUTLIVALUE_INPUT_SUFFIX = "_Multi_Value_Input";
    private final I18n i18n = I18n.i18n((I18n.BundleType)I18n.BundleType.Validation, (Locale)Locale.getDefault());

    public AllArgumentsOfCorrectType(ValidationContext validationContext, ValidationErrorCollector validationErrorCollector) {
        super(validationContext, validationErrorCollector);
    }

    public void checkArgument(Argument argument) {
        GraphQLArgument fieldArgument = this.getValidationContext().getArgument();
        Value argVal = argument.getValue();
        if (argVal instanceof ArrayValue) {
            for (Value singleValue : ((ArrayValue)argVal).getValues()) {
                this.checkArgumentValue(argument, fieldArgument, singleValue);
            }
        } else {
            this.checkArgumentValue(argument, fieldArgument, argVal);
        }
    }

    private void checkArgumentValue(Argument argument, GraphQLArgument fieldArgument, Value argVal) {
        if (null == fieldArgument || !(argVal instanceof ObjectValue)) {
            return;
        }
        for (ObjectField argumentField : ((ObjectValue)argVal).getObjectFields()) {
            OntoArgumentValidationUtil validationUtil = new OntoArgumentValidationUtil(argument);
            GraphQLInputType inputType = fieldArgument.getType();
            String fieldName = argumentField.getName();
            while (GraphQLTypeUtil.isNonNull((GraphQLType)inputType) || GraphQLTypeUtil.isList((GraphQLType)inputType)) {
                inputType = GraphQLTypeUtil.unwrapOne((GraphQLType)inputType);
            }
            if (inputType instanceof GraphQLInputObjectType) {
                GraphQLInputObjectField inputObjectField = ((GraphQLInputObjectType)inputType).getField(fieldName);
                if (null == inputObjectField) {
                    return;
                }
                inputType = ((GraphQLInputObjectType)inputType).getField(fieldName).getType();
            }
            if (validationUtil.isValidLiteralValue(argumentField.getValue(), (GraphQLType)inputType, this.getValidationContext().getSchema(), this.getValidationContext().getGraphQLContext(), Locale.getDefault())) continue;
            String errorMessage = this.createValidationMessage(argument, argumentField, validationUtil, (GraphQLType)inputType);
            this.addError(ValidationErrorType.WrongType, argumentField.getValue().getSourceLocation(), errorMessage);
        }
    }

    private String createValidationMessage(Argument argument, ObjectField argumentField, OntoArgumentValidationUtil validationUtil, GraphQLType inputType) {
        String errorMessage;
        Optional<String> typeName = this.extractFieldTypeName(inputType);
        if (typeName.isPresent()) {
            errorMessage = String.format("argument '%s.%s' with value '%s' is not a valid '%s'", argument.getName(), argumentField.getName(), argumentField.getValue(), typeName.get());
        } else {
            String fieldName = argumentField.getName();
            I18nMsg i18nMsg = validationUtil.getMsgAndArgs();
            i18nMsg = i18nMsg.addArgumentAt(0, null);
            errorMessage = this.i18n.msg(i18nMsg.getMsgKey(), i18nMsg.getMsgArguments());
            StringBuilder errorMessagePostProcessor = new StringBuilder(errorMessage).insert(errorMessage.indexOf(46) + 1, fieldName + ".");
            errorMessage = errorMessagePostProcessor.toString();
        }
        return errorMessage;
    }

    private Optional<String> extractFieldTypeName(GraphQLType inputType) {
        while ((GraphQLTypeUtil.isNonNull((GraphQLType)inputType) || GraphQLTypeUtil.isList((GraphQLType)inputType)) && (null == inputType.toString() || inputType.toString().contains(MUTLIVALUE_INPUT_SUFFIX))) {
            inputType = GraphQLTypeUtil.unwrapOne((GraphQLType)inputType);
        }
        if (inputType instanceof GraphQLScalarType || inputType instanceof GraphQLEnumType) {
            return Optional.of(((GraphQLNamedType)inputType).getName());
        }
        if (!(inputType instanceof GraphQLInputObjectType)) {
            return Optional.of(inputType.toString());
        }
        if (((GraphQLInputObjectType)inputType).getField("value") != null) {
            return Optional.of(((GraphQLInputObjectType)inputType).getFieldDefinition("value").getType().toString());
        }
        return Optional.empty();
    }
}

