/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphql.parser.argument.optimization;

import com.ontotext.graphql.parser.argument.optimization.AbstractFilterOptimization;
import com.ontotext.graphql.parser.argument.optimization.OptimizationContext;
import com.ontotext.models.query.AbstractExpressionVisitor;
import com.ontotext.models.query.Expression;
import com.ontotext.models.query.ExpressionTraverserContext;
import com.ontotext.models.query.ExpressionValue;
import com.ontotext.models.query.ExpressionVisitor;
import com.ontotext.models.query.FilterExpressionTraverser;
import com.ontotext.models.query.Node;
import com.ontotext.models.query.TraversalControl;
import java.util.Set;

public class UpperCaseRolesFilterValueOptimization
extends AbstractFilterOptimization {
    public static final String CTX_CLAIMS_AUTHORITIES = "${ctx.claims.authorities}";
    public static final String CTX_ROLES = "${ctx.roles}";
    public static final Set<String> CTX_PATTERNS = Set.of("${ctx.roles}", "${ctx.claims.authorities}");

    @Override
    public TraversalControl visit(Node target, OptimizationContext context) {
        FilterExpressionTraverser.traversePreOrder((ExpressionValue)target, (ExpressionVisitor)new UpperCaseNodeMarker());
        return TraversalControl.CANCEL;
    }

    private static class UpperCaseNodeMarker
    extends AbstractExpressionVisitor<TraversalControl, ExpressionTraverserContext> {
        private Node lastNode;

        private UpperCaseNodeMarker() {
        }

        public TraversalControl visit(Node target, ExpressionTraverserContext context) {
            String nodeValueAsString = ((Expression)target.getValue()).toString().toLowerCase();
            if (CTX_PATTERNS.stream().anyMatch(nodeValueAsString::contains)) {
                if (this.lastNode != null) {
                    this.lastNode.setIsUCase(false);
                }
                target.setIsUCase(true);
                this.lastNode = target;
            }
            return TraversalControl.CONTINUE;
        }
    }
}

