/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphql.parser.argument.optimization;

import com.ontotext.graphql.parser.argument.optimization.AbstractFilterOptimization;
import com.ontotext.graphql.parser.argument.optimization.OptimizationContext;
import com.ontotext.graphql.parser.argument.optimization.RepoStatistics;
import com.ontotext.graphql.parser.argument.optimization.StatisticsCollectorManager;
import com.ontotext.models.OperationType;
import com.ontotext.models.PropertyShape;
import com.ontotext.models.Shape;
import com.ontotext.models.query.And;
import com.ontotext.models.query.Exists;
import com.ontotext.models.query.Expression;
import com.ontotext.models.query.ExpressionCollection;
import com.ontotext.models.query.ExpressionTerm;
import com.ontotext.models.query.ExpressionValue;
import com.ontotext.models.query.Node;
import com.ontotext.models.query.SelectDistinct;
import java.util.Collections;
import java.util.List;

public abstract class SubQueryCreationOptimization
extends AbstractFilterOptimization {
    public static final double SELECT_DISTINCT_PENALTY = 1.2;
    protected StatisticsCollectorManager repoStatistics;

    public SubQueryCreationOptimization(StatisticsCollectorManager repoStatistics, List<OperationType> excludedOperations) {
        this.repoStatistics = repoStatistics;
        this.setExcludedOperations(excludedOperations);
    }

    public SubQueryCreationOptimization(StatisticsCollectorManager repoStatistics) {
        this.repoStatistics = repoStatistics;
        this.setExcludedOperations(Collections.emptyList());
    }

    protected double subQueryIndex(Exists exists, OptimizationContext context) {
        ExpressionTerm term;
        if (exists.getTerms().size() == 1 && (term = (ExpressionTerm)exists.getTerms().get(0)) instanceof Node) {
            double selectDistinctComplexity;
            double filterExistsComplexity;
            if (this.isExistsNode((Node)term)) {
                return -1.0;
            }
            Shape shape = ((Node)term).getShape();
            PropertyShape propShape = ((Node)term).getPropertyShape();
            RepoStatistics repoStats = this.repoStatistics.getStatistics(context.getEndpoint());
            String propRange = propShape.getRange();
            if (this.isPropertyRangeAShape(shape, propRange)) {
                filterExistsComplexity = repoStats.forShape(shape);
                selectDistinctComplexity = repoStats.forShape((Shape)shape.getContainedIn().get((Object)propRange));
            } else {
                filterExistsComplexity = this.calculateFilterExistsComplexity(context);
                selectDistinctComplexity = repoStats.forShapeProp(shape, propShape);
            }
            selectDistinctComplexity *= 1.2;
            if (selectDistinctComplexity < filterExistsComplexity) {
                return filterExistsComplexity / selectDistinctComplexity;
            }
        }
        return -1.0;
    }

    protected boolean isPropertyRangeAShape(Shape shape, String propRange) {
        return shape.getContainedIn().containsKey((Object)propRange) && !propRange.equals("Literal");
    }

    protected double calculateFilterExistsComplexity(OptimizationContext context) {
        ExpressionValue currentNode;
        double currentComplexity = 1.0;
        RepoStatistics repoStats = this.repoStatistics.getStatistics(context.getEndpoint());
        for (OptimizationContext currentContext = context; currentContext != null && !((currentNode = currentContext.getCurrentNode()) instanceof SelectDistinct); currentContext = currentContext.getParentContext()) {
            if (!(currentNode instanceof Node)) continue;
            currentComplexity *= repoStats.forShapeProp(((Node)currentNode).getShape(), ((Node)currentNode).getPropertyShape());
            break;
        }
        return currentComplexity;
    }

    protected boolean isExistsNode(Node term) {
        if (term.getValue() instanceof ExpressionCollection) {
            return ((Expression)term.getValue()).getTerms().isEmpty();
        }
        return false;
    }

    protected boolean areWeInABranch(OptimizationContext context) {
        for (OptimizationContext parentCtx = context.getParentContext(); parentCtx != null; parentCtx = parentCtx.getParentContext()) {
            ExpressionValue parentNode = parentCtx.getCurrentNode();
            if (!(parentNode instanceof And) && !(parentNode instanceof ExpressionCollection) || ((Expression)parentNode).getTerms().size() <= 1) continue;
            return true;
        }
        return false;
    }
}

