/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphql.parser.argument.optimization;

import com.ontotext.graphql.parser.argument.optimization.AbstractFilterOptimization;
import com.ontotext.graphql.parser.argument.optimization.OptimizationContext;
import com.ontotext.models.query.All;
import com.ontotext.models.query.AllExists;
import com.ontotext.models.query.And;
import com.ontotext.models.query.Exists;
import com.ontotext.models.query.Expression;
import com.ontotext.models.query.ExpressionCollection;
import com.ontotext.models.query.ExpressionValue;
import com.ontotext.models.query.Not;
import com.ontotext.models.query.Or;
import com.ontotext.models.query.TraversalControl;

public class RemoveSingleExpressions
extends AbstractFilterOptimization {
    public TraversalControl visit(And target, OptimizationContext context) {
        this.removeOnSingleTerm((Expression)target, context);
        this.removeOnEmptyExpression((Expression)target, context);
        return TraversalControl.CONTINUE;
    }

    public TraversalControl visit(All target, OptimizationContext context) {
        this.removeOnEmptyExpression((Expression)target, context);
        return TraversalControl.CONTINUE;
    }

    public TraversalControl visit(AllExists target, OptimizationContext context) {
        this.removeOnEmptyExpression((Expression)target, context);
        return TraversalControl.CONTINUE;
    }

    public TraversalControl visit(Not target, OptimizationContext context) {
        this.removeOnEmptyExpression((Expression)target, context);
        return TraversalControl.CONTINUE;
    }

    public TraversalControl visit(Or target, OptimizationContext context) {
        this.removeOnSingleTerm((Expression)target, context);
        this.removeOnEmptyExpression((Expression)target, context);
        return TraversalControl.CONTINUE;
    }

    public TraversalControl visit(Exists target, OptimizationContext context) {
        this.removeOnEmptyExpression((Expression)target, context);
        return TraversalControl.CONTINUE;
    }

    public TraversalControl visit(ExpressionCollection target, OptimizationContext context) {
        this.removeOnSingleTerm((Expression)target, context);
        this.removeOnEmptyExpression((Expression)target, context);
        return TraversalControl.CONTINUE;
    }

    private void removeOnSingleTerm(Expression target, OptimizationContext context) {
        if (target.getTerms().size() == 1) {
            context.replaceCurrentWith((ExpressionValue)target.getTerms().get(0));
        }
    }

    private void removeOnEmptyExpression(Expression target, OptimizationContext context) {
        if (target.getTerms().isEmpty()) {
            context.removeCurrent();
        }
    }
}

