/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphql.parser.argument.optimization;

import com.ontotext.graphql.parser.argument.optimization.AbstractFilterOptimization;
import com.ontotext.graphql.parser.argument.optimization.OptimizationContext;
import com.ontotext.models.query.And;
import com.ontotext.models.query.Exists;
import com.ontotext.models.query.Expression;
import com.ontotext.models.query.ExpressionCollection;
import com.ontotext.models.query.ExpressionTerm;
import com.ontotext.models.query.ExpressionValue;
import com.ontotext.models.query.Not;
import com.ontotext.models.query.Or;
import com.ontotext.models.query.TraversalControl;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class RemoveDuplicateExpressions
extends AbstractFilterOptimization {
    public TraversalControl visit(And target, OptimizationContext context) {
        this.flatDuplicateExpressions((Expression)target, And.class);
        return TraversalControl.CONTINUE;
    }

    public TraversalControl visit(Exists target, OptimizationContext context) {
        List terms = target.getTerms();
        this.removeDoubleExists(terms, context);
        return TraversalControl.CONTINUE;
    }

    public TraversalControl visit(Not target, OptimizationContext context) {
        List terms = target.getTerms();
        return this.removeDoubleNegation(terms, context);
    }

    public TraversalControl visit(Or target, OptimizationContext context) {
        this.flatDuplicateExpressions((Expression)target, Or.class);
        return TraversalControl.CONTINUE;
    }

    private void flatDuplicateExpressions(Expression target, Class<? extends Expression> type) {
        if (target.getTerms().isEmpty()) {
            return;
        }
        if (this.streamTerms(target).allMatch(type::isInstance)) {
            List subOrTerms = this.streamTerms(target).flatMap(term -> ((Expression)term).getTerms().stream()).collect(Collectors.toList());
            target.getTerms().clear();
            target.getTerms().addAll(subOrTerms);
        }
    }

    private Stream<ExpressionTerm> streamTerms(Expression target) {
        return target.getTerms().stream().flatMap(term -> term instanceof ExpressionCollection ? ((ExpressionCollection)term).getTerms().stream() : Stream.of(term));
    }

    private TraversalControl removeDoubleNegation(List<ExpressionTerm> terms, OptimizationContext context) {
        if (terms.size() == 1) {
            ExpressionTerm term = terms.get(0);
            if (term instanceof Not) {
                List expressionTerms = ((Not)term).getTerms();
                if (expressionTerms.size() == 1) {
                    context.replaceCurrentWith((ExpressionValue)expressionTerms.get(0));
                } else {
                    ExpressionCollection expressionCollection = new ExpressionCollection();
                    expressionTerms.forEach(arg_0 -> ((ExpressionCollection)expressionCollection).addTerm(arg_0));
                    context.replaceCurrentWith((ExpressionValue)expressionCollection);
                }
                return TraversalControl.RERUN;
            }
            if (term instanceof ExpressionCollection) {
                this.removeDoubleNegation(((ExpressionCollection)term).getTerms(), context);
            }
        }
        return TraversalControl.CONTINUE;
    }

    private void removeDoubleExists(List<ExpressionTerm> terms, OptimizationContext context) {
        block4: {
            ExpressionTerm term;
            block7: {
                block6: {
                    block5: {
                        if (terms.size() != 1) break block4;
                        term = terms.get(0);
                        if (!(term instanceof Exists)) break block5;
                        context.replaceCurrentWith((ExpressionValue)term);
                        break block4;
                    }
                    if (!(term instanceof ExpressionCollection)) break block6;
                    this.removeDoubleExists(((ExpressionCollection)term).getTerms(), context);
                    break block4;
                }
                if (term instanceof And) break block7;
                if (!(term instanceof Or)) break block4;
            }
            if (((Expression)term).getTerms().stream().allMatch(Exists.class::isInstance)) {
                context.replaceCurrentWith((ExpressionValue)term);
            }
        }
    }
}

