/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphql.parser.argument.optimization;

import com.ontotext.graphql.parser.argument.optimization.AbstractFilterOptimization;
import com.ontotext.graphql.parser.argument.optimization.FilterExpressionOptimizer;
import com.ontotext.graphql.parser.argument.optimization.OptimizationContext;
import com.ontotext.models.query.And;
import com.ontotext.models.query.CaseInsensitiveRegex;
import com.ontotext.models.query.CaseInsensitiveRegexMismatch;
import com.ontotext.models.query.Equals;
import com.ontotext.models.query.Exists;
import com.ontotext.models.query.Expression;
import com.ontotext.models.query.ExpressionTerm;
import com.ontotext.models.query.ExpressionValue;
import com.ontotext.models.query.ExpressionsFactory;
import com.ontotext.models.query.GreaterThan;
import com.ontotext.models.query.GreaterThanEquals;
import com.ontotext.models.query.In;
import com.ontotext.models.query.LessThan;
import com.ontotext.models.query.LessThanEquals;
import com.ontotext.models.query.Node;
import com.ontotext.models.query.Not;
import com.ontotext.models.query.NotEquals;
import com.ontotext.models.query.NotIn;
import com.ontotext.models.query.Regex;
import com.ontotext.models.query.RegexMismatch;
import com.ontotext.models.query.TraversalControl;
import java.util.List;

public class PushNotDownTheExpressionOptimizer
extends AbstractFilterOptimization {
    private final FilterExpressionOptimizer optimizer = new FilterExpressionOptimizer().addOptimization(new NotConverter());

    public TraversalControl visit(Not target, OptimizationContext context) {
        List terms = target.getTerms();
        if (terms.size() == 1) {
            ExpressionValue replaceWith;
            ExpressionTerm term = (ExpressionTerm)terms.get(0);
            if (term instanceof And) {
                Expression or = this.convertNotAndToOr((And)term);
                context.replaceCurrentWith((ExpressionValue)or);
            } else if ((term instanceof Exists || !(term instanceof Expression)) && (replaceWith = this.tryPushNotInsideExists((ExpressionValue)term)) != null) {
                context.replaceCurrentWith(replaceWith);
            }
        }
        return TraversalControl.CONTINUE;
    }

    private ExpressionValue tryPushNotInsideExists(ExpressionValue term) {
        ExpressionValue optimized;
        ExpressionValue original = term.deepCopy();
        if (original.equals((Object)(optimized = this.optimizer.optimize(term, null)))) {
            return null;
        }
        return optimized;
    }

    private Expression convertNotAndToOr(And term) {
        Expression or = ExpressionsFactory.or();
        for (ExpressionTerm expressionTerm : term.getTerms()) {
            or.addTerm((ExpressionTerm)ExpressionsFactory.not().addTerm(expressionTerm));
        }
        return or;
    }

    private static class NotConverter
    extends AbstractFilterOptimization {
        private NotConverter() {
        }

        public TraversalControl visit(CaseInsensitiveRegex target, OptimizationContext context) {
            ExpressionTerm term = ExpressionsFactory.term((String)"NIRE", (Object)target.getValue());
            context.replaceCurrentWith((ExpressionValue)term);
            return TraversalControl.QUIT;
        }

        public TraversalControl visit(CaseInsensitiveRegexMismatch target, OptimizationContext context) {
            ExpressionTerm term = ExpressionsFactory.term((String)"IRE", (Object)target.getValue());
            context.replaceCurrentWith((ExpressionValue)term);
            return TraversalControl.QUIT;
        }

        public TraversalControl visit(Equals target, OptimizationContext context) {
            ExpressionTerm term = ExpressionsFactory.term((String)"NEQ", (Object)target.getValue());
            context.replaceCurrentWith((ExpressionValue)term);
            return TraversalControl.QUIT;
        }

        public TraversalControl visit(GreaterThan target, OptimizationContext context) {
            ExpressionTerm term = ExpressionsFactory.term((String)"LTE", (Object)target.getValue());
            context.replaceCurrentWith((ExpressionValue)term);
            return TraversalControl.QUIT;
        }

        public TraversalControl visit(GreaterThanEquals target, OptimizationContext context) {
            ExpressionTerm term = ExpressionsFactory.term((String)"LT", (Object)target.getValue());
            context.replaceCurrentWith((ExpressionValue)term);
            return TraversalControl.QUIT;
        }

        public TraversalControl visit(In target, OptimizationContext context) {
            ExpressionTerm term = ExpressionsFactory.term((String)"NIN", (Object)target.getValue());
            context.replaceCurrentWith((ExpressionValue)term);
            return TraversalControl.QUIT;
        }

        public TraversalControl visit(LessThan target, OptimizationContext context) {
            ExpressionTerm term = ExpressionsFactory.term((String)"GTE", (Object)target.getValue());
            context.replaceCurrentWith((ExpressionValue)term);
            return TraversalControl.QUIT;
        }

        public TraversalControl visit(LessThanEquals target, OptimizationContext context) {
            ExpressionTerm term = ExpressionsFactory.term((String)"GT", (Object)target.getValue());
            context.replaceCurrentWith((ExpressionValue)term);
            return TraversalControl.QUIT;
        }

        public TraversalControl visit(NotEquals target, OptimizationContext context) {
            ExpressionTerm term = ExpressionsFactory.term((String)"EQ", (Object)target.getValue());
            context.replaceCurrentWith((ExpressionValue)term);
            return TraversalControl.QUIT;
        }

        public TraversalControl visit(NotIn target, OptimizationContext context) {
            ExpressionTerm term = ExpressionsFactory.term((String)"IN", (Object)target.getValue());
            context.replaceCurrentWith((ExpressionValue)term);
            return TraversalControl.QUIT;
        }

        public TraversalControl visit(Regex target, OptimizationContext context) {
            ExpressionTerm term = ExpressionsFactory.term((String)"NRE", (Object)target.getValue());
            context.replaceCurrentWith((ExpressionValue)term);
            return TraversalControl.QUIT;
        }

        public TraversalControl visit(RegexMismatch target, OptimizationContext context) {
            ExpressionTerm term = ExpressionsFactory.term((String)"RE", (Object)target.getValue());
            context.replaceCurrentWith((ExpressionValue)term);
            return TraversalControl.QUIT;
        }

        @Override
        public TraversalControl visit(Node target, OptimizationContext context) {
            if (target.getPropertyShape().isScalarType() && target.getPropertyShape().isRequired()) {
                return TraversalControl.CONTINUE;
            }
            return TraversalControl.QUIT;
        }
    }
}

