/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphql.parser.argument.optimization;

import com.ontotext.graphql.parser.argument.optimization.FilterExpressionOptimization;
import com.ontotext.graphql.parser.argument.optimization.OptimizationContext;
import com.ontotext.models.OperationType;
import com.ontotext.models.query.Expression;
import com.ontotext.models.query.ExpressionCollection;
import com.ontotext.models.query.ExpressionTerm;
import com.ontotext.models.query.ExpressionValue;
import com.ontotext.models.query.ExpressionVisitor;
import com.ontotext.models.query.ExpressionVisitorContext;
import com.ontotext.models.query.Node;
import com.ontotext.models.query.TraversalControl;
import com.ontotext.models.query.Value;
import com.ontotext.soaas.common.connection.Endpoint;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class FilterExpressionOptimizer {
    private List<FilterExpressionOptimization> optimizations = new ArrayList<FilterExpressionOptimization>();

    public FilterExpressionOptimizer addOptimization(FilterExpressionOptimization optimization) {
        this.optimizations.add(optimization);
        return this;
    }

    public ExpressionValue optimize(ExpressionValue expression, OperationType operationType, Endpoint endpoint) {
        ExpressionValue current = expression;
        for (FilterExpressionOptimization optimization : this.optimizations) {
            if (!optimization.getExcludedOperations().contains(operationType) && (current = new OptimizationAlgorithm(optimization, current, endpoint).optimize()) == null) break;
        }
        return current;
    }

    public ExpressionValue optimize(ExpressionValue expression, @Nullable Endpoint endpoint) {
        FilterExpressionOptimization optimization;
        ExpressionValue current = expression;
        Iterator<FilterExpressionOptimization> iterator = this.optimizations.iterator();
        while (iterator.hasNext() && (current = new OptimizationAlgorithm(optimization = iterator.next(), current, endpoint).optimize()) != null) {
        }
        return current;
    }

    private static class OptimizationAlgorithm {
        private final FilterExpressionOptimization optimization;
        private ExpressionValue rootExpressionValue;
        private final Endpoint endpoint;

        OptimizationAlgorithm(FilterExpressionOptimization optimization, ExpressionValue optimizationRoot, Endpoint endpoint) {
            this.optimization = optimization;
            this.rootExpressionValue = optimizationRoot;
            this.endpoint = endpoint;
        }

        public ExpressionValue optimize() {
            OptimizationContext context = new OptimizationContext(this.endpoint);
            try {
                return this.optimizeAndTraverse(this.rootExpressionValue, context);
            }
            catch (AbortExecutionException abe) {
                return context.getReplaceWith();
            }
        }

        private ExpressionValue optimizeAndTraverse(ExpressionValue expression, OptimizationContext context) throws AbortExecutionException {
            TraversalControl control = this.applyOptimization(expression, context);
            ExpressionValue expressionValue = context.getCurrentNode();
            if (control == TraversalControl.QUIT || expressionValue == null) {
                return expressionValue;
            }
            if (expressionValue instanceof Expression) {
                OptimizationContext subContext = new OptimizationContext(context);
                boolean hasValueRemoval = false;
                for (ExpressionTerm term : new ArrayList(((Expression)expressionValue).getTerms())) {
                    ExpressionValue termExecution = this.optimizeAndTraverse((ExpressionValue)term, subContext);
                    hasValueRemoval |= termExecution == null;
                }
                if (hasValueRemoval && control != TraversalControl.CANCEL) {
                    return this.optimizeAndTraverse(expressionValue, context);
                }
            } else if (expressionValue instanceof Node) {
                Expression nodeExpression = (Expression)((Node)expressionValue).getValue();
                OptimizationContext subContext = new OptimizationContext(context);
                this.optimizeAndTraverse((ExpressionValue)nodeExpression, subContext);
            }
            return expressionValue;
        }

        private TraversalControl applyOptimization(ExpressionValue<?> value, OptimizationContext context) throws AbortExecutionException {
            context.onSibling(value);
            TraversalControl control = (TraversalControl)value.accept((ExpressionVisitor)this.optimization, (ExpressionVisitorContext)context);
            ExpressionValue optimizedExpression = context.getReplaceWith();
            if (this.shouldRemoveCurrentNode(context)) {
                if (context.getParentNode() != null) {
                    this.removeNodeFromParent(context.getParentNode(), value);
                }
                if (control != TraversalControl.RERUN) {
                    return TraversalControl.CANCEL;
                }
            } else if (this.shouldReplaceCurrentNode(context)) {
                this.replaceNodeInParent(context.getParentNode(), value, optimizedExpression);
                if (control == TraversalControl.CONTINUE) {
                    return this.applyOptimization(optimizedExpression, context);
                }
            }
            if (control == TraversalControl.QUIT) {
                throw new AbortExecutionException();
            }
            if (control == TraversalControl.RERUN) {
                optimizedExpression = this.rerunOptimization(optimizedExpression, context);
                control = TraversalControl.QUIT;
            }
            context.onSibling(optimizedExpression);
            return control;
        }

        private ExpressionValue rerunOptimization(ExpressionValue optimizedExpression, OptimizationContext context) {
            ExpressionValue newOptimizationRoot = this.rootExpressionValue;
            if (context.getParentNode() == null) {
                newOptimizationRoot = optimizedExpression;
            }
            if (newOptimizationRoot == null) {
                return null;
            }
            return new OptimizationAlgorithm(this.optimization, newOptimizationRoot, this.endpoint).optimize();
        }

        private boolean shouldReplaceCurrentNode(OptimizationContext context) {
            return context.getReplaceWith() != context.getCurrentNode() && context.getParentNode() != null;
        }

        private boolean shouldRemoveCurrentNode(OptimizationContext context) {
            return context.getReplaceWith() == null;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void replaceNodeInParent(ExpressionValue parentNode, ExpressionValue toReplace, ExpressionValue replaceWith) {
            if (parentNode instanceof Expression) {
                ExpressionTerm termToReplace = this.getAsTerm(toReplace);
                List parentTerms = ((Expression)parentNode).getTerms();
                int index = parentTerms.indexOf(termToReplace);
                if (index <= -1) throw new IllegalStateException("Could not find the term " + termToReplace.getName() + "in the " + String.valueOf(parentNode));
                if (replaceWith instanceof ExpressionCollection) {
                    ExpressionCollection collection = (ExpressionCollection)replaceWith;
                    parentTerms.remove(index);
                    parentTerms.addAll(index, collection.getTerms());
                    return;
                } else {
                    parentTerms.set(index, this.getAsTerm(replaceWith));
                }
                return;
            } else if (parentNode instanceof Node) {
                ((Node)parentNode).setValue((Object)new ExpressionCollection().addTerm(this.getAsTerm(replaceWith)));
                return;
            } else if (parentNode instanceof ExpressionTerm) {
                ((ExpressionTerm)parentNode).setValue((Object)replaceWith);
                return;
            } else {
                if (parentNode == null) return;
                throw new IllegalStateException("Can't replace node from non Expression instance");
            }
        }

        private void removeNodeFromParent(ExpressionValue parentNode, ExpressionValue value) {
            if (parentNode instanceof Expression) {
                ((Expression)parentNode).getTerms().remove(this.getAsTerm(value));
            } else if (parentNode instanceof Node) {
                ((Node)parentNode).setValue((Object)new ExpressionCollection());
            } else if (parentNode instanceof ExpressionTerm) {
                ((ExpressionTerm)parentNode).setValue((Object)Value.NULL_VALUE);
            } else if (parentNode != null) {
                throw new IllegalStateException("Can't remove node from non Expression instance");
            }
        }

        private ExpressionTerm getAsTerm(ExpressionValue value) {
            if (value instanceof ExpressionTerm) {
                return (ExpressionTerm)value;
            }
            throw new IllegalStateException("Expected ExpressionTerm got " + (value == null ? "null" : value.getClass().getSimpleName()));
        }
    }

    private static class AbortExecutionException
    extends Exception {
        private AbortExecutionException() {
        }
    }
}

