/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphql.parser.argument.optimization;

import com.ontotext.graphql.parser.argument.optimization.RepoStatistics;
import com.ontotext.models.PropertyShape;
import com.ontotext.models.Selectable;
import com.ontotext.models.Shape;
import com.ontotext.models.SomlSchema;
import com.ontotext.models.query.All;
import com.ontotext.models.query.AllExists;
import com.ontotext.models.query.And;
import com.ontotext.models.query.CaseInsensitiveRegex;
import com.ontotext.models.query.CaseInsensitiveRegexMismatch;
import com.ontotext.models.query.Equals;
import com.ontotext.models.query.Exists;
import com.ontotext.models.query.Expression;
import com.ontotext.models.query.ExpressionCollection;
import com.ontotext.models.query.ExpressionTerm;
import com.ontotext.models.query.ExpressionValue;
import com.ontotext.models.query.ExpressionVisitor;
import com.ontotext.models.query.ExpressionVisitorContext;
import com.ontotext.models.query.GreaterThan;
import com.ontotext.models.query.GreaterThanEquals;
import com.ontotext.models.query.In;
import com.ontotext.models.query.LessThan;
import com.ontotext.models.query.LessThanEquals;
import com.ontotext.models.query.Minus;
import com.ontotext.models.query.Node;
import com.ontotext.models.query.Not;
import com.ontotext.models.query.NotEquals;
import com.ontotext.models.query.NotIn;
import com.ontotext.models.query.Or;
import com.ontotext.models.query.Regex;
import com.ontotext.models.query.RegexMismatch;
import com.ontotext.models.query.SelectDistinct;
import com.ontotext.models.query.StringContains;
import com.ontotext.models.query.StringEndsWith;
import com.ontotext.models.query.StringStartWith;
import com.ontotext.models.query.UniqueLang;
import com.ontotext.models.query.Value;
import java.util.List;

public class FilterComplexityAnalyzer
implements ExpressionVisitor<Double, Context> {
    private static final Double SIMPLE_FILTER_COMPLEXITY = 1.0;
    private RepoStatistics statistics;

    public FilterComplexityAnalyzer(RepoStatistics statistics) {
        this.statistics = statistics;
    }

    public static double forSelectable(Selectable selectable, RepoStatistics statistics, SomlSchema soml) {
        ExpressionValue expression = (ExpressionValue)selectable.getArguments().getWhere().orElseThrow(() -> new IllegalArgumentException("The Selectable does not have where expression"));
        return (Double)expression.accept((ExpressionVisitor)new FilterComplexityAnalyzer(statistics), (ExpressionVisitorContext)new Context(null));
    }

    public Double visit(All target, Context context) {
        return this.combine(target.getTerms(), context);
    }

    public Double visit(AllExists target, Context context) {
        return this.combine(target.getTerms(), context);
    }

    public Double visit(And target, Context context) {
        return this.combine(target.getTerms(), context);
    }

    public Double visit(CaseInsensitiveRegex target, Context context) {
        return this.defaultComplexity(context);
    }

    public Double visit(CaseInsensitiveRegexMismatch target, Context context) {
        return this.defaultComplexity(context);
    }

    public Double visit(Equals target, Context context) {
        return this.defaultComplexity(context);
    }

    public Double visit(Exists target, Context context) {
        return this.combine(target.getTerms(), context);
    }

    public Double visit(GreaterThan target, Context context) {
        return this.defaultComplexity(context);
    }

    public Double visit(GreaterThanEquals target, Context context) {
        return this.defaultComplexity(context);
    }

    public Double visit(In target, Context context) {
        return (double)((List)target.getValue()).size() * SIMPLE_FILTER_COMPLEXITY * context.numOfNodes;
    }

    public Double visit(LessThan target, Context context) {
        return this.defaultComplexity(context);
    }

    public Double visit(LessThanEquals target, Context context) {
        return this.defaultComplexity(context);
    }

    public Double visit(Minus target, Context context) {
        return this.combine(target.getTerms(), context);
    }

    public Double visit(Node target, Context context) {
        Shape shape = context.parentShape;
        if (shape == null) {
            return 0.0;
        }
        PropertyShape prop = (PropertyShape)shape.getProperty(target.getName().replaceFirst("_", ":")).orElseThrow(IllegalStateException::new);
        double estimatedNumOfNodes = this.statistics.forShapeProp(shape, prop);
        return (Double)((Expression)target.getValue()).accept((ExpressionVisitor)this, (ExpressionVisitorContext)context.childContext(prop, estimatedNumOfNodes));
    }

    public Double visit(Not target, Context context) {
        return this.defaultComplexity(context);
    }

    public Double visit(NotEquals target, Context context) {
        return this.defaultComplexity(context);
    }

    public Double visit(NotIn target, Context context) {
        return (double)((List)target.getValue()).size() * SIMPLE_FILTER_COMPLEXITY;
    }

    public Double visit(Or target, Context context) {
        return this.combine(target.getTerms(), context);
    }

    public Double visit(Regex target, Context context) {
        return this.defaultComplexity(context);
    }

    public Double visit(RegexMismatch target, Context context) {
        return this.defaultComplexity(context);
    }

    public Double visit(SelectDistinct target, Context context) {
        throw new RuntimeException("We should not be here");
    }

    public Double visit(Value target, Context context) {
        throw new RuntimeException("Tell Yasen that Value is not unused in the filter parsing and providethe example filter.Thanks.");
    }

    public Double visit(ExpressionCollection target, Context context) {
        return this.combine(target.getTerms(), context);
    }

    public Double visit(StringStartWith stringStartWith, Context context) {
        return this.defaultComplexity(context);
    }

    public Double visit(StringEndsWith stringEndsWith, Context context) {
        return this.defaultComplexity(context);
    }

    public Double visit(StringContains stringContains, Context context) {
        return this.defaultComplexity(context);
    }

    public Double visit(UniqueLang target, Context context) {
        return this.defaultComplexity(context) * 2.0;
    }

    private double defaultComplexity(Context context) {
        return SIMPLE_FILTER_COMPLEXITY * context.numOfNodes;
    }

    private Double combine(List<ExpressionTerm> terms, Context context) {
        if (terms.isEmpty()) {
            return this.defaultComplexity(context);
        }
        return terms.stream().map(term -> term.accept((ExpressionVisitor)this, (ExpressionVisitorContext)context)).map(Double.class::cast).mapToDouble(Double::doubleValue).sum();
    }

    static class Context
    implements ExpressionVisitorContext {
        final Shape parentShape;
        final double numOfNodes;

        public Context(Shape parentShape) {
            this.parentShape = parentShape;
            this.numOfNodes = 0.0;
        }

        public Context(Shape parentShape, double numOfNodes) {
            this.parentShape = parentShape;
            this.numOfNodes = numOfNodes;
        }

        public Context childContext(PropertyShape property, double numOfNodes) {
            return new Context((Shape)this.parentShape.getContainedIn().getOrDefault((Object)property.getRange(), null), numOfNodes);
        }
    }
}

