/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphql.parser.argument.optimization;

import com.ontotext.graphql.parser.argument.optimization.RepoStatistics;
import com.ontotext.graphql.parser.argument.optimization.StatisticsCollector;
import com.ontotext.soaas.common.Debounce;
import com.ontotext.soaas.common.ObjectsUtil;
import java.util.concurrent.TimeUnit;

public class CacheableStatisticsCollector
implements StatisticsCollector {
    private static final long DEFAULT_FETCH_INTERVAL = TimeUnit.HOURS.toMillis(1L);
    private final StatisticsCollector delegate;
    private final long cacheWindow;
    private Debounce<RepoStatistics> statisticsCache;
    private long currentCacheWindow;

    public CacheableStatisticsCollector(StatisticsCollector delegate) {
        this(delegate, null);
    }

    public CacheableStatisticsCollector(StatisticsCollector delegate, Long fetchInterval) {
        this.delegate = delegate;
        this.currentCacheWindow = this.cacheWindow = ((Long)ObjectsUtil.getOrDefault((Object)fetchInterval, (Object)DEFAULT_FETCH_INTERVAL)).longValue();
        this.statisticsCache = new Debounce(this.cacheWindow);
    }

    @Override
    public boolean isEnabled() {
        return this.delegate.isEnabled();
    }

    @Override
    public synchronized RepoStatistics collect() {
        RepoStatistics repoStatistics = (RepoStatistics)this.statisticsCache.get(this.delegate::collect);
        if (repoStatistics != null && repoStatistics.isEmpty()) {
            if (this.currentCacheWindow == this.cacheWindow) {
                this.currentCacheWindow = this.cacheWindow / 60L;
                this.statisticsCache.setDebounceWindow(this.currentCacheWindow);
                this.statisticsCache.reset();
            }
        } else if (this.currentCacheWindow != this.cacheWindow) {
            this.currentCacheWindow = this.cacheWindow;
            this.statisticsCache.setDebounceWindow(this.currentCacheWindow);
        }
        return repoStatistics;
    }
}

