/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphql.parser.argument;

import com.ontotext.graphql.parser.argument.ArgumentParserContext;
import com.ontotext.graphql.parser.argument.ErrorReporting;
import com.ontotext.graphql.parser.argument.LiteralValueHandler;
import com.ontotext.graphql.parser.argument.NestedUpdateFeature;
import com.ontotext.models.OperationType;
import com.ontotext.models.Prefixes;
import com.ontotext.models.PropertyShape;
import com.ontotext.models.Shape;
import com.ontotext.models.SomlSchema;
import com.ontotext.models.mutation.Change;
import com.ontotext.models.mutation.ChangePreconditions;
import com.ontotext.models.mutation.IdSelector;
import com.ontotext.models.mutation.ReferenceId;
import com.ontotext.models.query.ExpressionValue;
import com.ontotext.models.query.InputValueConverter;
import com.ontotext.models.query.SourceLocation;
import com.ontotext.soaas.common.ObjectsUtil;
import com.ontotext.soaas.experimental.ExperimentalFeatures;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class UpdateMutationArgumentParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String REPLACE = "replace";
    private static final String PATCH = "patch";
    private static final String VALUE = "value";
    private static final String ID = "id";
    private static final String WHERE = "where";
    private static final String IDS = "ids";
    private final InputValueConverter valueConverter;
    private final ArgumentParserContext parserContext;
    private final SomlSchema schema;
    private final Map<String, Change> changes = new LinkedHashMap<String, Change>();
    private final Prefixes prefixes;
    private final LiteralValueHandler literalHandler;

    UpdateMutationArgumentParser(InputValueConverter valueConverter, ArgumentParserContext parserContext) {
        this.valueConverter = valueConverter;
        this.parserContext = parserContext;
        this.schema = parserContext.getContainingType().getContainedIn().getContainedIn();
        this.prefixes = this.schema.getPrefixes();
        this.literalHandler = new LiteralValueHandler(this.schema, parserContext);
    }

    List<Change> readMutationUpdate(List<Map<String, Object>> mutationProps, List<Map<String, Object>> metadata) {
        ErrorReporting reporter = new ErrorReporting();
        Shape type = this.parserContext.getContainingType();
        for (int i = 0; i < mutationProps.size(); ++i) {
            Map<String, Object> propertiesMap = mutationProps.get(i);
            Map<String, Object> objectMetadata = metadata.isEmpty() ? Collections.emptyMap() : metadata.get(i);
            ErrorReporting errorReporting = reporter.newRootReporter(objectMetadata);
            Change change = this.changes.computeIfAbsent(ReferenceId.temporaryId(), this.createChange(OperationType.UPDATE, type, errorReporting.getLocation()));
            ExpressionValue whereValue = this.parserContext.getArguments().getWhere().orElse(null);
            String id = UpdateMutationArgumentParser.extractIdFromCondition(whereValue);
            change.setPreconditions(new ChangePreconditions(null, null, whereValue, id));
            this.readMutationUpdateProperties(change, propertiesMap, errorReporting);
            this.ensureSingleEntityIfEntityIdChange(change, errorReporting);
        }
        reporter.report();
        return this.buildResult();
    }

    private List<Change> buildResult() {
        ArrayList<Change> resultChanges = new ArrayList<Change>(this.changes.values());
        this.parserContext.getArguments().getGraph().ifPresent(graph -> resultChanges.forEach(change -> change.setGraph(graph)));
        return resultChanges;
    }

    private static String extractIdFromCondition(ExpressionValue<?> condition) {
        List ids = IdSelector.collectIds(condition);
        String id = null;
        if (ids.size() == 1) {
            IdSelector.extractAndRemoveIds(condition);
            id = (String)ids.get(0);
        }
        return id;
    }

    private void ensureSingleEntityIfEntityIdChange(Change change, ErrorReporting errorReporting) {
        Optional newEntityId = change.getNewEntityId();
        if (!newEntityId.isPresent()) {
            return;
        }
        ExpressionValue precondition = change.getPreconditions().getPrecondition();
        List collectedIds = IdSelector.collectIds((ExpressionValue)precondition);
        if (collectedIds.size() > 1 || collectedIds.isEmpty() && change.getPreconditions().getActualChangeId() == null) {
            errorReporting.addErrorMessage("mutation.update.nonDeterministicUpdateWithIdChange", new Object[0]);
        }
    }

    private void readMutationUpdateProperties(Change change, Map<String, Object> argValues, ErrorReporting errorReporting) {
        Shape type = change.getShape();
        for (Map.Entry<String, Object> singleValue : argValues.entrySet()) {
            String argumentName = singleValue.getKey();
            ErrorReporting meta = errorReporting.stepIn(argumentName);
            Object value = singleValue.getValue();
            PropertyShape property = (PropertyShape)type.getProperty(this.prefixes.nameToShortIri(argumentName)).orElseThrow(() -> errorReporting.createError("Unknown property " + argumentName));
            if (property.isScalarType()) {
                this.addScalarValueChange(change, argumentName, value, meta);
                continue;
            }
            if (value instanceof Map) {
                Map objectMap = (Map)value;
                UpdateMutationArgumentParser.validateForSingleUseOfReplaceTrue(Collections.singletonList(objectMap), meta);
                this.addNestedUpdateChange(meta, change, objectMap, property);
                continue;
            }
            if (value instanceof List && !((List)value).isEmpty()) {
                List values = (List)value;
                UpdateMutationArgumentParser.validateForSingleUseOfReplaceTrue(values, meta);
                for (int i = 0; i < values.size(); ++i) {
                    Map nestedObject = (Map)values.get(i);
                    this.addNestedUpdateChange(meta.stepIn(i), change, nestedObject, property);
                }
                continue;
            }
            if (value != null && !(value instanceof List)) continue;
            change.deleteAllPropertyValues(property.getName(), meta.getLocationAsList());
        }
    }

    private static void validateForSingleUseOfReplaceTrue(List<Map<String, Object>> values, ErrorReporting errorReporting) {
        if (values.isEmpty()) {
            return;
        }
        boolean hasReplace = values.stream().anyMatch(UpdateMutationArgumentParser.hasReplaceTrue());
        boolean hasUpdate = values.stream().anyMatch(UpdateMutationArgumentParser.isDataUpdate());
        if (hasReplace && hasUpdate) {
            errorReporting.addErrorMessage("mutation.update.cannotUsePatchAndReplace", errorReporting.getProperty());
        }
    }

    private static Predicate<? super Map<String, Object>> isDataUpdate() {
        return data -> Objects.nonNull(data.get(PATCH)) || Objects.nonNull(data.get(WHERE));
    }

    private static Predicate<Map<String, Object>> hasReplaceTrue() {
        return data -> Boolean.TRUE.equals(data.get(REPLACE));
    }

    private void addNestedUpdateChange(ErrorReporting errorReporting, Change change, Map<String, Object> nestedObjectMap, PropertyShape propertyShape) {
        Object where = nestedObjectMap.remove(WHERE);
        Object patch = this.getPatch(nestedObjectMap);
        if (patch != null && where != null) {
            errorReporting.addErrorMessage("mutation.update.cannotUsePatchAndWhere", new Object[0]);
            return;
        }
        Shape nestedShape = (Shape)change.getShape().getContainedIn().get((Object)propertyShape.getRange());
        boolean isSubCreate = where == null && patch == null;
        boolean replace = Boolean.TRUE.equals(nestedObjectMap.remove(REPLACE)) || isSubCreate && !propertyShape.isMultivalued();
        String propertyName = propertyShape.getName();
        List<SourceLocation> locationAsList = errorReporting.getLocationAsList();
        Object ids = nestedObjectMap.remove(IDS);
        if (UpdateMutationArgumentParser.isValidIdsValue(ids)) {
            if (!nestedObjectMap.isEmpty()) {
                errorReporting.stepIn(IDS).addError("Cannot add references and " + (isSubCreate ? "create" : "update") + " objects");
                return;
            }
            ExpressionValue<?> compiledWhere = this.parseNestedFilter(nestedShape, where);
            this.addChangeValue(change, propertyName, ids, patch, replace, compiledWhere, locationAsList);
            return;
        }
        if (nestedObjectMap.isEmpty()) {
            ExpressionValue<?> compiledWhere = this.parseNestedFilter(nestedShape, where);
            this.addChangeValue(change, propertyName, null, patch, replace, compiledWhere, locationAsList);
            return;
        }
        if (nestedObjectMap.size() > 1 && patch != null) {
            errorReporting.addErrorMessage("mutation.update.multipleTypesWithPatch", String.join((CharSequence)", ", nestedObjectMap.keySet()));
            return;
        }
        if (patch instanceof Collection && ((Collection)patch).size() > 1) {
            errorReporting.addErrorMessage("mutation.update.typesWithMultiplePatch", String.join((CharSequence)", ", nestedObjectMap.keySet()));
            return;
        }
        for (Map.Entry<String, Object> typeData : nestedObjectMap.entrySet()) {
            String typeName = typeData.getKey();
            ErrorReporting meta = errorReporting.stepIn(typeName);
            Object value = typeData.getValue();
            boolean hasSubChanges = this.hasChanges(value);
            boolean updateById = Objects.nonNull(patch);
            Object localWhere = this.appendTypeFilter(where, typeName, errorReporting, hasSubChanges, updateById);
            ExpressionValue<?> compiledWhere = this.parseNestedFilter(nestedShape, localWhere);
            ChangePreconditions preconditions = new ChangePreconditions(change, propertyShape, compiledWhere, (String)patch);
            Optional<String> nestedId = this.processNestedTypeOperation(meta, preconditions, typeName, value);
            List<SourceLocation> localLocations = meta.getLocationAsList();
            nestedId.ifPresent(id -> this.addChangeValue(change, propertyName, id, patch, replace, null, localLocations));
        }
    }

    private Object getPatch(Map<String, Object> nestedObjectMap) {
        Object patch = nestedObjectMap.remove(PATCH);
        if (patch instanceof Collection) {
            if (((Collection)patch).size() == 1) {
                patch = ((Collection)patch).iterator().next();
            } else if (((Collection)patch).isEmpty()) {
                patch = null;
            }
        }
        return patch;
    }

    private static boolean isValidIdsValue(Object ids) {
        return ids instanceof Collection || ids instanceof String && StringUtils.trimToNull((String)ids.toString()) != null;
    }

    private boolean hasChanges(Object value) {
        return value instanceof Map && !((Map)value).isEmpty();
    }

    private Object appendTypeFilter(Object where, String typeName, ErrorReporting reporting, boolean hasChanges, boolean updateById) {
        if (where == null && (hasChanges || updateById)) {
            return null;
        }
        if (where != null && !(where instanceof Map)) {
            throw new IllegalArgumentException("Unsupported 'where' condition for nested update: " + String.valueOf(where));
        }
        String typeKey = "_if" + StringUtils.capitalize((String)typeName);
        if (where == null) {
            LinkedHashMap whereMap = new LinkedHashMap();
            whereMap.put((CallSite)((Object)typeKey), Collections.emptyMap());
            return whereMap;
        }
        LinkedHashMap<String, Object> whereMap = (LinkedHashMap<String, Object>)ObjectsUtil.getOrDefault((Object)where, Collections.emptyMap());
        whereMap = new LinkedHashMap<String, Object>(whereMap);
        Shape shape = this.getShapeFromTypeKey(typeName, reporting);
        if (shape.isAbstract() || shape.isUnion()) {
            return whereMap;
        }
        if (!whereMap.containsKey(typeKey)) {
            List types = whereMap.keySet().stream().filter(key -> key.startsWith("_if")).map(key -> key.replace("_if", "")).collect(Collectors.toList());
            if (!types.isEmpty()) {
                reporting.addErrorMessage("mutation.update.updateDisjointTypes", typeName, String.join((CharSequence)", ", types));
            }
            whereMap.put(typeKey, Collections.emptyMap());
        }
        this.removeNonMatchingTypes(whereMap, typeKey);
        return whereMap;
    }

    private void removeNonMatchingTypes(Map<String, Object> where, String typeKey) {
        where.keySet().removeIf(key -> {
            if (key.equals(typeKey)) {
                return false;
            }
            if (key.startsWith("_if")) {
                LOGGER.debug("Ignored not applicable '{}' filter as not relevant for the updated '{}' entities", (Object)key.replace("_if", ""), (Object)typeKey.replace("_if", ""));
                return true;
            }
            return false;
        });
    }

    private Optional<String> processNestedTypeOperation(ErrorReporting reporting, ChangePreconditions preconditions, String typeName, Object objectData) {
        Change parentChange = preconditions.getParentChange();
        Shape nestedType = this.getShapeFromTypeKey(typeName, reporting);
        if (!this.hasChanges(objectData)) {
            this.addChangeValue(parentChange, preconditions.getIncomingRelation().getName(), null, preconditions.getActualChangeId(), false, preconditions.getPrecondition(), reporting.getLocationAsList());
            return Optional.empty();
        }
        if (!(objectData instanceof Map)) {
            throw new UnsupportedOperationException("Implement delete all of a certain type");
        }
        Map subValue = (Map)objectData;
        if (preconditions.isSubCreate()) {
            if (nestedType.isAbstract()) {
                reporting.addErrorMessage("mutation.update.cannotCreateAbstract", nestedType.getId());
                return Optional.empty();
            }
            if (nestedType.isUnion()) {
                reporting.addErrorMessage("mutation.update.cannotCreateUnion", nestedType.getId());
                return Optional.empty();
            }
            return this.createNestedObject(reporting, nestedType, subValue, preconditions);
        }
        this.verifyNotInNestedCreate(preconditions, reporting);
        if (subValue.containsKey(ID)) {
            reporting.stepIn(ID).addErrorMessage("mutation.update.nestedIdChangeNotAllowed", new Object[0]);
            return Optional.empty();
        }
        Change nestedChange = this.changes.computeIfAbsent(ReferenceId.temporaryId(), this.createChange(OperationType.UPDATE, nestedType, reporting.getLocation()));
        nestedChange.setPreconditions(preconditions);
        this.readMutationUpdateProperties(nestedChange, subValue, reporting);
        return Optional.empty();
    }

    private void verifyNotInNestedCreate(ChangePreconditions preconditions, ErrorReporting reporting) {
        Change parentChange = preconditions.getParentChange();
        if (parentChange != null && parentChange.getType() == OperationType.CREATE) {
            reporting.addError("Nested update inside a nested create is not allowed");
        }
    }

    private Shape getShapeFromTypeKey(String typeName, ErrorReporting reporting) {
        Shape nestedType;
        String typeChange = this.prefixes.nameToShortIri(typeName);
        if (!typeChange.contains(":")) {
            typeChange = StringUtils.capitalize((String)typeChange);
        }
        if ((nestedType = (Shape)this.schema.getObjects().get((Object)typeChange)) == null) {
            throw reporting.createError("Unknown type: " + typeChange);
        }
        return nestedType;
    }

    private void addChangeValue(Change change, String name, Object value, Object patch, boolean replace, ExpressionValue<?> condition, List<SourceLocation> sourceLocations) {
        HashMap<String, Object> changeMapping = new HashMap<String, Object>();
        changeMapping.put(VALUE, value);
        changeMapping.put(PATCH, patch);
        changeMapping.put(REPLACE, replace);
        changeMapping.put(WHERE, condition);
        change.addPropertyFromMap(name, changeMapping, sourceLocations);
    }

    private Optional<String> createNestedObject(ErrorReporting reporting, Shape nestedShape, Map<String, Object> subObjectData, ChangePreconditions preconditions) {
        Change parentChange = preconditions.getParentChange();
        String id = Objects.toString(subObjectData.remove(ID), ReferenceId.randomId());
        boolean nestedUpdateEnabled = ((NestedUpdateFeature)ExperimentalFeatures.getFeature(NestedUpdateFeature.class)).isNestedCreateEnabled();
        if (!nestedUpdateEnabled) {
            reporting.addError(String.format("It is required to use 'patch' or 'where' to update '%s' property!", reporting.getProperty()));
            return Optional.empty();
        }
        if (parentChange.getEntityId().filter(Predicate.isEqual(id)).isPresent()) {
            reporting.stepIn(ID).addErrorMessage("invalid.idMismatch", id);
            return Optional.empty();
        }
        Change nestedCreate = this.changes.computeIfAbsent(id, this.createChange(OperationType.CREATE, nestedShape, reporting.getLocation()));
        nestedCreate.setPreconditions(preconditions);
        this.readMutationUpdateProperties(nestedCreate, subObjectData, reporting);
        return Optional.of(id);
    }

    private void addScalarValueChange(Change change, String name, Object convertedValue, ErrorReporting errorReporting) {
        if (change.getType() == OperationType.CREATE) {
            this.addScalarValueChangeForCreate(change, name, convertedValue, errorReporting);
            return;
        }
        PropertyShape property = change.getPropertyChangeShape(name);
        if (convertedValue instanceof List) {
            if (((List)convertedValue).isEmpty()) {
                change.replacePropertyValue(name, null, errorReporting.getLocationAsList());
                return;
            }
            int idx = 0;
            for (Object subValue : (List)convertedValue) {
                ErrorReporting reporting = errorReporting.stepIn(idx++);
                Map<String, Object> updatedValue = this.literalHandler.addLangValueSupportDuringUpdate((Map)subValue, property, reporting);
                change.addPropertyFromMap(name, updatedValue, reporting.getLocationAsList());
            }
        } else if (convertedValue instanceof Map) {
            Map<String, Object> updatedValue = this.literalHandler.addLangValueSupportDuringUpdate((Map)convertedValue, property, errorReporting);
            change.addPropertyFromMap(name, updatedValue, errorReporting.getLocationAsList());
        } else {
            change.replacePropertyValue(name, convertedValue, errorReporting.getLocationAsList());
        }
    }

    private void addScalarValueChangeForCreate(Change change, String name, Object convertedValue, ErrorReporting errorReporting) {
        if (convertedValue instanceof List) {
            if (((List)convertedValue).isEmpty()) {
                return;
            }
            ArrayList<Object> values = new ArrayList<Object>();
            List objects = (List)convertedValue;
            int objectsSize = objects.size();
            for (int i = 0; i < objectsSize; ++i) {
                Object subValue = objects.get(i);
                if (subValue instanceof Map) {
                    ((Map)subValue).remove(REPLACE, Boolean.FALSE);
                    if (((Map)subValue).size() != 1) {
                        ErrorReporting reporting = errorReporting.stepIn(i);
                        reporting.stepIn(PATCH).addErrorMessage("mutation.update.cannotUpdateValue", reporting.getProperty(), this.prefixes.toName(change.getShape().getId()));
                        continue;
                    }
                    Object value = ((Map)subValue).get(VALUE);
                    values.addAll(UpdateMutationArgumentParser.getAsCollection(value));
                    continue;
                }
                values.addAll(UpdateMutationArgumentParser.getAsCollection(subValue));
            }
            change.addPropertyValue(name, values, errorReporting.getLocationAsList());
        } else if (convertedValue instanceof Map) {
            this.addScalarValueChangeForCreate(change, name, Collections.singletonList(convertedValue), errorReporting);
        } else {
            change.addPropertyValue(name, convertedValue, errorReporting.getLocationAsList());
        }
    }

    private static Collection<Object> getAsCollection(Object value) {
        if (value instanceof Collection) {
            return (Collection)value;
        }
        if (value != null) {
            return Collections.singleton(value);
        }
        return Collections.emptyList();
    }

    private Function<String, Change> createChange(OperationType operationType, Shape type, SourceLocation location) {
        return changeId -> new Change(changeId, operationType, type, location, this.valueConverter);
    }

    private ExpressionValue<?> parseNestedFilter(Shape shape, Object where) {
        return (ExpressionValue)this.parserContext.parseNestedArgument(shape, WHERE, where);
    }
}

