/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphql.parser.argument;

import com.ontotext.graphql.parser.ArgumentPostProcessor;
import com.ontotext.graphql.parser.argument.ArgumentConverter;
import com.ontotext.graphql.parser.argument.ArgumentParser;
import com.ontotext.graphql.parser.argument.ArgumentParserContext;
import com.ontotext.models.PropertyShape;
import com.ontotext.models.ScalarType;
import com.ontotext.models.ScalarTypes;
import com.ontotext.models.Shape;
import com.ontotext.models.query.Arguments;
import com.ontotext.models.query.InputValueConverter;
import com.ontotext.models.templates.Template;
import com.ontotext.models.templates.TemplateArgs;
import com.ontotext.soaas.common.SparqlUtil;
import graphql.language.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class SparqlTemplateArgumentParser
implements ArgumentParser,
ArgumentPostProcessor {
    @Override
    public Object parseArgument(Object arg, ArgumentParserContext parserContext) {
        if (arg == null) {
            return null;
        }
        if (!(arg instanceof Map)) {
            throw new IllegalArgumentException("Template arguments should be a mapping of template keys. Got: " + String.valueOf(arg));
        }
        ScalarTypes types = parserContext.getContainingType().getContainedIn().getContainedIn().getTypes();
        InputValueConverter valueConverter = parserContext.getArgumentConverter().getValueConverter();
        Template template = this.resolveTemplate(parserContext);
        Map arguments = (Map)arg;
        LinkedHashMap result = new LinkedHashMap();
        template.getRootTemplate().streamTemplates().forEach(tmp -> this.convertTemplateArguments((Template)tmp, arguments, result, valueConverter, types));
        arguments.putAll(result);
        return arguments;
    }

    private void convertTemplateArguments(Template template, Map<String, Object> arguments, Map<String, Object> result, InputValueConverter valueConverter, ScalarTypes types) {
        for (Map.Entry entry : template.getKeys().entrySet()) {
            Object value;
            String name = (String)entry.getKey();
            if (result.containsKey(name) || (value = arguments.getOrDefault(name, ((TemplateArgs)entry.getValue()).getDefaultValue())) == null) continue;
            TemplateArgs templateArgs = (TemplateArgs)entry.getValue();
            result.put(name, this.convertTemplateValue(value, templateArgs, valueConverter, types));
        }
    }

    private Template resolveTemplate(ArgumentParserContext parserContext) {
        return parserContext.getPropertyShape().map(PropertyShape::getSparqlTemplate).or(() -> parserContext.getPropertyShape().flatMap(PropertyShape::resolveCountedProperty).map(PropertyShape::getSparqlTemplate)).orElseThrow(() -> new IllegalArgumentException("Could not resolve Template instance to parse arguments for " + parserContext.getFieldName()));
    }

    private Object convertTemplateValue(Object value, TemplateArgs templateArgs, InputValueConverter valueConverter, ScalarTypes types) {
        if (value instanceof Map) {
            return this.processMap((Map)value, templateArgs, valueConverter, types);
        }
        if (value instanceof Collection) {
            return this.processIterable((Collection)value, templateArgs, valueConverter, types);
        }
        String type = templateArgs.getType();
        if ("sparql".equals(type)) {
            return value;
        }
        if ("condition".equals(type)) {
            return Boolean.parseBoolean(Objects.toString(value, "false"));
        }
        ScalarType scalarType = (ScalarType)types.get((Object)type);
        if (scalarType == null) {
            scalarType = (ScalarType)types.get((Object)"string");
        }
        if (scalarType.is("string") || scalarType.isLangStringSupported()) {
            value = SparqlUtil.escapeStringLiteral((String)Objects.toString(value));
        }
        return valueConverter.convert(value, scalarType);
    }

    private Map<String, Object> processMap(Map<String, Object> map, TemplateArgs templateArgs, InputValueConverter valueConverter, ScalarTypes types) {
        map.replaceAll((key, value) -> this.convertTemplateValue(value, (TemplateArgs)templateArgs.getArgsMap().get(key), valueConverter, types));
        return map;
    }

    private Object processIterable(Collection<Object> iterable, TemplateArgs args, InputValueConverter valueConverter, ScalarTypes types) {
        if (iterable instanceof List) {
            ((List)iterable).replaceAll(obj -> this.convertTemplateValue(obj, args, valueConverter, types));
            return iterable;
        }
        ArrayList<Object> copy = new ArrayList<Object>(iterable.size());
        for (Object item : iterable) {
            copy.add(this.convertTemplateValue(item, args, valueConverter, types));
        }
        return copy;
    }

    @Override
    public void register(ArgumentConverter argumentConverter) {
        argumentConverter.registerArgumentParser("args", this);
    }

    @Override
    public void process(Arguments arguments, Field field, Shape shape, ArgumentConverter argumentConverter) {
        if (arguments.containsKey((Object)"args")) {
            return;
        }
        Optional<PropertyShape> propertyOptional = ArgumentPostProcessor.resolveProperty(field.getName(), shape);
        if (propertyOptional.filter(PropertyShape::isSparqlTemplate).isEmpty()) {
            return;
        }
        ScalarTypes types = shape.getContainedIn().getContainedIn().getTypes();
        InputValueConverter valueConverter = argumentConverter.getValueConverter();
        PropertyShape property = propertyOptional.get();
        Template sparqlTemplate = property.getSparqlTemplate();
        LinkedHashMap args = new LinkedHashMap();
        sparqlTemplate.getRootTemplate().streamTemplates().map(Template::getKeys).forEach(templateArgs -> templateArgs.forEach((key, arg) -> {
            if (arg.getDefaultValue() == null) {
                return;
            }
            args.put(key, this.convertTemplateValue(arg.getDefaultValue(), (TemplateArgs)arg, valueConverter, types));
        }));
        if (!args.isEmpty()) {
            arguments.put((Object)"args", args);
        }
    }
}

