/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphql.parser.argument;

import com.ontotext.graphql.parser.argument.ArgumentConverter;
import com.ontotext.graphql.parser.argument.ArgumentParser;
import com.ontotext.graphql.parser.argument.ArgumentParserContext;
import com.ontotext.models.SomlSchema;
import com.ontotext.models.query.Order;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class OrderByArgumentParser
implements ArgumentParser {
    public static final String NAME = "orderBy";

    @Override
    public Object parseArgument(Object orderKey, ArgumentParserContext parserContext) {
        if (orderKey instanceof Map) {
            LinkedList<Order> orderings = new LinkedList<Order>();
            Iterator it = ((Map)orderKey).entrySet().iterator();
            SomlSchema schema = parserContext.getContainingType().getContainedIn().getContainedIn();
            while (it.hasNext()) {
                Map.Entry next = it.next();
                Object value = next.getValue();
                if (value instanceof Map) {
                    LinkedList<String> referenceChain = new LinkedList<String>();
                    referenceChain.add(OrderByArgumentParser.getOrderProperty(next, schema));
                    OrderByArgumentParser.generateOrderingChain(orderings, referenceChain, (Map)value, schema);
                    continue;
                }
                if (!(value instanceof String)) continue;
                orderings.add(new Order(Collections.emptyList(), OrderByArgumentParser.getOrderProperty(next, schema), (String)value));
            }
            return orderings;
        }
        if (orderKey instanceof String) {
            LinkedList<Order> orderings = new LinkedList<Order>();
            orderings.add(new Order(Collections.emptyList(), null, (String)orderKey));
            return orderings;
        }
        return null;
    }

    private static String getOrderProperty(Map.Entry next, SomlSchema somlSchema) {
        return somlSchema.getPrefixes().toName((String)next.getKey());
    }

    private static void generateOrderingChain(List<Order> orderings, List<String> parentReference, Map<String, Object> orderingMap, SomlSchema schema) {
        if (orderingMap.isEmpty()) {
            orderings.add(new Order(parentReference, null));
            return;
        }
        for (Map.Entry<String, Object> next : orderingMap.entrySet()) {
            Object value = next.getValue();
            if (value instanceof String) {
                orderings.add(new Order(parentReference, OrderByArgumentParser.getOrderProperty(next, schema), (String)value));
                continue;
            }
            if (!(value instanceof Map)) continue;
            ArrayList<String> childReference = new ArrayList<String>(parentReference);
            childReference.add(OrderByArgumentParser.getOrderProperty(next, schema));
            OrderByArgumentParser.generateOrderingChain(orderings, childReference, (Map)value, schema);
        }
    }

    @Override
    public void register(ArgumentConverter argumentConverter) {
        argumentConverter.registerArgumentParser(NAME, this);
    }
}

