/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphql.parser.argument;

import com.ontotext.graphql.parser.argument.ArgumentParserContext;
import com.ontotext.graphql.parser.argument.ErrorReporting;
import com.ontotext.models.LangConfig;
import com.ontotext.models.PropertyShape;
import com.ontotext.models.Shape;
import com.ontotext.models.SomlSchema;
import com.ontotext.models.query.LangValidator;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.eclipse.rdf4j.model.util.Literals;

public class LiteralValueHandler {
    private final ArgumentParserContext parserContext;
    private final Shape literalShape;

    LiteralValueHandler(SomlSchema schema, ArgumentParserContext parserContext) {
        this.parserContext = parserContext;
        this.literalShape = (Shape)schema.getObjects().get((Object)"Literal");
    }

    List<Map<String, Object>> addLangValueSupportDuringCreate(List<Map<String, Object>> values, PropertyShape propertyShape, ErrorReporting errorReporting) {
        if (!propertyShape.isLiteral()) {
            return values;
        }
        this.validateLanguages(propertyShape, errorReporting, values);
        this.validateUniqueness(propertyShape, errorReporting, values);
        if (!errorReporting.hasErrors()) {
            this.normalizeTags(values);
        }
        return values;
    }

    Map<String, Object> addLangValueSupportDuringUpdate(Map<String, Object> value, PropertyShape propertyShape, ErrorReporting errorReporting) {
        if (!propertyShape.isLiteral()) {
            return value;
        }
        Object values = value.get("value");
        if (values == null) {
            return value;
        }
        if (!propertyShape.isMultivalued()) {
            value.putIfAbsent("replace", Boolean.TRUE);
        }
        Stream<Object> objectStream = values instanceof Collection ? ((Collection)values).stream() : Stream.of(values);
        List<Map<String, Object>> langValues = objectStream.filter(Map.class::isInstance).map(item -> (Map)item).collect(Collectors.toList());
        if (langValues.isEmpty()) {
            return value;
        }
        this.validateLanguages(propertyShape, errorReporting, langValues);
        if (!errorReporting.hasErrors()) {
            this.normalizeTags(langValues);
        }
        value.computeIfPresent("where", (key, where) -> this.parseSubFilter(where));
        return value;
    }

    private Object parseSubFilter(Object where) {
        return this.parserContext.parseNestedArgument(this.literalShape, "where", where);
    }

    private void validateLanguages(PropertyShape propertyShape, ErrorReporting reporting, List<Map<String, Object>> langValues) {
        LangConfig langConfig = propertyShape.getLangConfig();
        if (langConfig != null && StringUtils.isNotBlank((CharSequence)langConfig.getImplicit())) {
            String implicitValue = langConfig.getEffectiveImplicit();
            for (Map<String, Object> langValue : langValues) {
                langValue.putIfAbsent("lang", implicitValue);
            }
        }
        List<Pair<String, String>> valueLangPairs = this.valuesToPairs(langValues);
        String property = reporting.getProperty();
        if (propertyShape.getScalarType().isLangStringExclusive()) {
            valueLangPairs.stream().filter(pair -> ((String)pair.getRight()).isEmpty()).forEach(pair -> reporting.addErrorMessage("mutation.langs.missingRequiredLang", property));
        }
        valueLangPairs.stream().filter(pair -> StringUtils.isNotBlank((CharSequence)((CharSequence)pair.getRight()))).filter(pair -> !LangValidator.isValidLanguageTag((String)((String)pair.getRight()))).forEach(pair -> reporting.addErrorMessage("mutation.langs.invalidLang", property, pair.getRight()));
        if (langConfig != null) {
            Consumer<Pair<String, String>> notAllowedConsumer = LiteralValueHandler.createValidationResultConsumer("mutation.langs.notAllowed", reporting, langConfig);
            Consumer<Pair<String, String>> excludedConsumer = LiteralValueHandler.createValidationResultConsumer("mutation.langs.excluded", reporting, langConfig);
            langConfig.getValidator().validate(valueLangPairs, notAllowedConsumer, excludedConsumer);
        }
    }

    private static Consumer<Pair<String, String>> createValidationResultConsumer(String message, ErrorReporting reporting, LangConfig langConfig) {
        return invalidValueLangPair -> reporting.addErrorMessage(message, reporting.getProperty(), invalidValueLangPair.getRight(), langConfig.getValidate());
    }

    private List<Pair<String, String>> valuesToPairs(List<Map<String, Object>> langValues) {
        return langValues.stream().map(LiteralValueHandler.literalToPairFunction()).collect(Collectors.toList());
    }

    private static Function<Map<String, Object>, Pair<String, String>> literalToPairFunction() {
        return map -> Pair.of((Object)Objects.toString(map.get("value")), (Object)Objects.toString(map.get("lang"), ""));
    }

    private void validateUniqueness(PropertyShape property, ErrorReporting reporting, List<Map<String, Object>> values) {
        LangConfig langConfig = property.getLangConfig();
        if (langConfig == null || langConfig.getValidator() == null) {
            return;
        }
        List<Pair<String, String>> valueLangPairs = this.valuesToPairs(values);
        List duplicateLangs = langConfig.getValidator().validateUniqueness(valueLangPairs);
        Map<String, Long> duplicates = duplicateLangs.stream().collect(Collectors.groupingBy(Pair::getRight, Collectors.counting()));
        duplicates.forEach((lang, count) -> reporting.addErrorMessage("mutation.langs.notUnique", reporting.getProperty(), count, lang, langConfig.getValidate()));
    }

    private void normalizeTags(List<Map<String, Object>> langValues) {
        langValues.stream().filter(map -> StringUtils.isNotBlank((CharSequence)((CharSequence)map.get("lang")))).forEach(map -> map.computeIfPresent("lang", (key, lang) -> Literals.normalizeLanguageTag((String)((String)map.get("lang")))));
    }
}

