/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphql.parser.argument;

import com.ontotext.graphql.parser.argument.ExpressionPreProcessor;
import com.ontotext.models.Shape;
import com.ontotext.models.query.ExpressionsFactory;
import com.ontotext.models.query.LangFilter;
import java.util.Collection;
import java.util.Map;

public class LiteralFilterPreProcessor
implements ExpressionPreProcessor {
    @Override
    public void preProcess(Map<String, Object> expression, Shape parent) {
        if (!"Literal".equals(parent.getId())) {
            return;
        }
        Object lang = expression.get("lang");
        if (lang instanceof String) {
            LangFilter.parseForFilter((String)lang.toString()).applyFilterTo(expression);
            return;
        }
        if (lang instanceof LangFilter) {
            ((LangFilter)lang).applyFilterTo(expression);
            return;
        }
        if (expression.keySet().stream().allMatch(s -> ExpressionsFactory.isTerm((String)s) || ExpressionsFactory.isExpression((String)s))) {
            if (LiteralFilterPreProcessor.hasNodesInExpression(expression)) {
                return;
            }
            expression.put("%typeOverride%", parent.getProperty("value").orElseThrow(IllegalStateException::new));
        }
    }

    private static boolean hasNodesInExpression(Map<String, Object> expression) {
        for (Map.Entry<String, Object> entry : expression.entrySet()) {
            String key = entry.getKey();
            Object exp = entry.getValue();
            if (!ExpressionsFactory.isExpression((String)key)) continue;
            boolean hasSubNodes = false;
            if (exp instanceof Map) {
                hasSubNodes = LiteralFilterPreProcessor.hasSubNodes((Map)exp);
            } else if (exp instanceof Collection) {
                hasSubNodes = ((Collection)exp).stream().anyMatch(LiteralFilterPreProcessor::hasSubNodes);
            }
            if (!hasSubNodes) continue;
            return true;
        }
        return false;
    }

    private static boolean hasSubNodes(Map<String, Object> exp) {
        return exp.keySet().stream().anyMatch(ExpressionsFactory::isNode);
    }
}

