/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphql.parser.argument;

import com.ontotext.graphql.parser.argument.ArgumentConverter;
import com.ontotext.graphql.parser.argument.ArgumentParser;
import com.ontotext.graphql.parser.argument.ArgumentParserContext;

public abstract class IntegerArgumentParser
implements ArgumentParser {
    @Override
    public Long parseArgument(Object value, ArgumentParserContext parserContext) {
        long result;
        if (value instanceof Number) {
            result = ((Number)value).longValue();
        } else if (value instanceof String) {
            try {
                result = Long.parseLong(value.toString());
            }
            catch (NumberFormatException nfe) {
                throw new IllegalArgumentException(String.format("Value '%s' for argument '%s' is not valid in respect of type `%s`", value, this.argumentName(), this.argumentName()));
            }
        } else {
            throw new IllegalArgumentException(String.format("Value '%s' for argument '%s' is not valid in respect of type `%s`. Expected number or String.", value, this.argumentName(), this.argumentName()));
        }
        return result;
    }

    @Override
    public void register(ArgumentConverter argumentConverter) {
        argumentConverter.registerArgumentParser(this.argumentName(), this);
    }

    protected abstract String argumentName();

    protected abstract String typeName();
}

