/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphql.parser.argument;

import com.ontotext.graphql.parser.argument.ArgumentConverter;
import com.ontotext.models.OperationType;
import com.ontotext.models.Prefixes;
import com.ontotext.models.PropertyShape;
import com.ontotext.models.Shape;
import com.ontotext.models.SomlSchema;
import com.ontotext.models.query.Arguments;
import com.ontotext.models.query.Variables;
import com.ontotext.soaas.common.connection.Endpoint;
import graphql.schema.GraphQLSchema;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.jetbrains.annotations.Nullable;

public class ArgumentParserContext {
    private final String fieldName;
    private final OperationType operationType;
    private final Shape containingType;
    private final Arguments arguments;
    private final ArgumentConverter argumentConverter;
    private final Map<String, Object> metadata;
    private final GraphQLSchema schema;
    private final Variables variables;
    private final SomlSchema somlSchema;
    private Endpoint endpoint;

    public ArgumentParserContext(String fieldName, OperationType operationType, Shape containingType, Arguments arguments, ArgumentConverter argumentConverter, Variables variables) {
        this(fieldName, operationType, containingType, arguments, argumentConverter, Collections.emptyMap(), variables);
    }

    public ArgumentParserContext(String fieldName, OperationType operationType, Shape containingType, Arguments arguments, ArgumentConverter argumentConverter, Map<String, Object> metadata, Variables variables) {
        this(fieldName, operationType, containingType, arguments, argumentConverter, metadata, null, variables);
    }

    public ArgumentParserContext(String fieldName, OperationType operationType, Shape containingType, Arguments arguments, ArgumentConverter argumentConverter, Map<String, Object> metadata, GraphQLSchema schema, Variables variables) {
        this.fieldName = fieldName;
        this.operationType = operationType;
        this.containingType = containingType;
        this.arguments = arguments;
        this.argumentConverter = argumentConverter;
        this.metadata = metadata;
        this.schema = schema;
        this.variables = variables;
        this.somlSchema = containingType.getContainedIn().getContainedIn();
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public Shape getContainingType() {
        return this.containingType;
    }

    public Arguments getArguments() {
        return this.arguments;
    }

    public OperationType getOperationType() {
        return this.operationType;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public GraphQLSchema getSchema() {
        return this.schema;
    }

    public SomlSchema getSomlSchema() {
        return this.somlSchema;
    }

    public ArgumentConverter getArgumentConverter() {
        return this.argumentConverter;
    }

    public Optional<PropertyShape> getPropertyShape() {
        if (this.containingType == null) {
            return Optional.empty();
        }
        if ("name".equals(this.fieldName) && this.containingType.getName() != null) {
            return this.containingType.getProperty(this.containingType.getName());
        }
        String fieldIri = this.containingType.getContainedIn().getContainedIn().getPrefixes().toModelShortIri(this.fieldName);
        return this.containingType.getProperty(fieldIri);
    }

    @Nullable
    public Shape getType(String name) {
        return (Shape)this.getContainingType().getContainedIn().get((Object)name);
    }

    public Optional<Shape> getPropertyType() {
        Prefixes prefixes = this.getSomlSchema().getPrefixes();
        Optional<PropertyShape> propertyShape = this.getPropertyShape();
        if (propertyShape.filter(PropertyShape::isCountProperty).isPresent()) {
            return propertyShape.flatMap(PropertyShape::resolveCountedProperty).map(property -> this.getType(prefixes.toModelShortIri(property.getRange())));
        }
        return propertyShape.map(property -> this.getType(prefixes.toModelShortIri(property.getRange())));
    }

    public ArgumentParserContext changeTypeTo(Shape shape) {
        return new ArgumentParserContext(this.getFieldName(), this.getOperationType(), shape, this.getArguments(), this.argumentConverter, this.getMetadata(), this.getSchema(), this.variables).setEndpoint(this.endpoint);
    }

    public <E> E parseNestedArgument(Shape shape, String argumentName, Object value) {
        if (value == null) {
            return null;
        }
        ArgumentParserContext nestedPc = this.changeTypeTo(shape);
        return (E)this.argumentConverter.convert(argumentName, value, nestedPc);
    }

    public Variables getVariables() {
        return this.variables;
    }

    public ArgumentParserContext setEndpoint(Endpoint endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }
}

