/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphql.parser;

import com.ontotext.graphql.parser.ArgumentReader;
import com.ontotext.graphql.parser.OperationPostProcessor;
import com.ontotext.graphql.parser.argument.ArgumentConverter;
import com.ontotext.models.Operation;
import com.ontotext.models.Shape;
import com.ontotext.models.SomlSchema;
import com.ontotext.models.query.InputValueConverter;
import com.ontotext.models.query.Variables;
import com.ontotext.rbac.SecurityContext;
import com.ontotext.soaas.common.ObjectsUtil;
import com.ontotext.soaas.plugin.Order;
import com.ontotext.soaas.plugin.PluginsManager;
import graphql.schema.GraphQLSchema;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiPredicate;

class QueryTraversalControl {
    private static final BiPredicate<OperationPostProcessor, Operation> ALL_PROCESSORS = (processor, operation) -> true;
    private final SomlSchema somlSchema;
    private final GraphQLSchema graphQlSchema;
    private final ArgumentConverter argumentConverter;
    private boolean loadedPostProcessors;
    private final List<OperationPostProcessor> postProcessors = new ArrayList<OperationPostProcessor>();
    private BiPredicate<OperationPostProcessor, Operation> postProcessorFilter = ALL_PROCESSORS;

    QueryTraversalControl(SomlSchema somlSchema, GraphQLSchema graphQlSchema, ArgumentConverter argumentConverter) {
        this.somlSchema = somlSchema;
        this.graphQlSchema = graphQlSchema;
        this.argumentConverter = argumentConverter;
        this.loadedPostProcessors = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadPostProcessors() {
        if (!this.loadedPostProcessors) {
            QueryTraversalControl queryTraversalControl = this;
            synchronized (queryTraversalControl) {
                if (this.loadedPostProcessors) {
                    return;
                }
                this.postProcessors.addAll(PluginsManager.loader(OperationPostProcessor.class).withConfig((Object)this.somlSchema).withConfig((Object)this.argumentConverter).load());
                this.loadedPostProcessors = true;
            }
        }
    }

    synchronized void addPostProcessor(OperationPostProcessor postProcessor) {
        this.postProcessors.add(postProcessor);
        this.sortPostProcessors();
    }

    void setOperationPostProcessor(BiPredicate<OperationPostProcessor, Operation> postProcessorFilter) {
        this.postProcessorFilter = (BiPredicate)ObjectsUtil.getOrDefault(postProcessorFilter, ALL_PROCESSORS);
    }

    void sortPostProcessors() {
        this.postProcessors.sort(Order.Comparator.sortByOrder());
    }

    Shape getObject(String name) {
        Shape shape = (Shape)this.somlSchema.getObjects().get((Object)this.somlSchema.getPrefixes().nameToShortIri(name));
        if (shape == null && (shape = (Shape)this.somlSchema.getObjects().get((Object)name)) == null) {
            shape = (Shape)this.somlSchema.getObjects().get((Object)"Object");
        }
        return shape;
    }

    SomlSchema getSomlSchema() {
        return this.somlSchema;
    }

    GraphQLSchema getGraphQlSchema() {
        return this.graphQlSchema;
    }

    ArgumentReader createArgumentParser(Variables variables) {
        return new ArgumentReader(variables, this.argumentConverter);
    }

    void postProcess(Operation operation, SecurityContext securityContext) {
        this.loadPostProcessors();
        for (OperationPostProcessor postProcessor : this.postProcessors) {
            if (!this.postProcessorFilter.test(postProcessor, operation)) continue;
            postProcessor.postProcess(operation, securityContext);
        }
    }

    ArgumentConverter getArgumentConverter() {
        return this.argumentConverter;
    }

    InputValueConverter getInputValueConverter() {
        return this.argumentConverter.getValueConverter();
    }
}

