/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphql.parser;

import com.ontotext.graphql.parser.OperationPostProcessor;
import com.ontotext.graphql.parser.SelectionBuilder;
import com.ontotext.graphql.parser.argument.ArgumentConverter;
import com.ontotext.graphql.parser.argument.ArgumentConverterAware;
import com.ontotext.graphql.parser.argument.ArgumentParserContext;
import com.ontotext.graphql.parser.exceptions.InvalidOperationException;
import com.ontotext.graphql.validator.SimpleGraphQlError;
import com.ontotext.models.Operation;
import com.ontotext.models.OperationType;
import com.ontotext.models.Selectable;
import com.ontotext.models.Selection;
import com.ontotext.models.Shape;
import com.ontotext.models.SomlSchema;
import com.ontotext.models.extensions.Order;
import com.ontotext.models.query.ExpressionValue;
import com.ontotext.models.query.LangFilter;
import com.ontotext.rbac.SecurityContext;
import graphql.ErrorClassification;
import graphql.ErrorType;
import graphql.GraphQLError;
import graphql.language.SourceLocation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Order(value=400)
public class LangStringFetchPostProcessor
implements OperationPostProcessor,
ArgumentConverterAware {
    private ArgumentConverter argumentConverter;

    @Override
    public void postProcess(Operation operation, SecurityContext securityContext) {
        ArrayList<GraphQLError> errors = new ArrayList<GraphQLError>();
        SelectionBuilder selectionBuilder = new SelectionBuilder(operation.getSchema());
        this.createSelections((Selectable)operation, errors, selectionBuilder);
        if (!errors.isEmpty()) {
            throw new InvalidOperationException("Failed to parse language filter used for literal selections", errors);
        }
    }

    private void createSelections(Selectable selectable, List<GraphQLError> errors, SelectionBuilder selectionBuilder) {
        if (selectable.getArguments().getLangFilter().isPresent()) {
            try {
                this.processSelection(selectable, selectionBuilder);
            }
            catch (InvalidOperationException ioe) {
                errors.addAll(ioe.getErrors());
            }
        }
        new ArrayList<Selectable>(selectable.getSelections()).forEach(subSelection -> this.createSelections((Selectable)subSelection, errors, selectionBuilder));
    }

    private void processSelection(Selectable selectable, SelectionBuilder selectionBuilder) {
        LangFilter filter = selectable.getArguments().getLangFilter().orElse(null);
        if (!(selectable instanceof Selection) || filter == null || filter.isInFilterMode() || filter.isFetchAll()) {
            return;
        }
        List<Selection> selections = this.addLiteralSpecificOrderSelections(filter, selectable, selectable.getName(), selectionBuilder);
        if (this.shouldLoadWithMultiSelection(selections)) {
            ((Selection)selectable).setTreeAsNoneQueryable();
            Object templateArgs = selectable.getArguments().get((Object)"args");
            Selectable parent = selectable.getParent();
            int index = parent.getSelections().indexOf(selectable);
            parent.getSelections().addAll(index + 1, selections);
            for (Selection selection : selections) {
                selection.getArguments().put((Object)"args", templateArgs);
                selection.setParent(selectable.getParent());
                selection.setType(selectable.getType());
                selection.setAlias(selectable.getAlias());
            }
        }
    }

    private boolean shouldLoadWithMultiSelection(List<Selection> selections) {
        return selections.stream().anyMatch(selection -> selection.getArguments().getLimit().isPresent());
    }

    private List<Selection> addLiteralSpecificOrderSelections(LangFilter filter, Selectable currentParentSelection, String node, SelectionBuilder selectionBuilder) {
        LinkedList<Selection> selections = new LinkedList<Selection>();
        Selectable parent = currentParentSelection.getParent();
        String parentType = parent.getType();
        if (currentParentSelection.isInFragment()) {
            parentType = currentParentSelection.getDefinedIn();
        }
        Selection selection = selectionBuilder.pathToSelectable(node, parentType, parent, selections::add);
        selection.setService(currentParentSelection.getService());
        List<LangFilter> filterLanguages = this.splitPerLang(filter, (Selectable)selection, selectionBuilder.getSchema());
        Iterator<LangFilter> it = filterLanguages.iterator();
        while (it.hasNext()) {
            LangFilter langFilter = it.next();
            selection.getArguments().setLangFilter(langFilter);
            selection.getArguments().setWhere(langFilter.getExpression());
            selection.getArguments().setLimit(1L);
            selection.setCollection(true);
            it.remove();
            if (!it.hasNext()) continue;
            selection = selectionBuilder.pathToSelectable(node, parentType, parent, selections::add);
        }
        return selections;
    }

    private List<LangFilter> splitPerLang(LangFilter filter, Selectable parent, SomlSchema somlSchema) {
        Map<String, List<LangFilter.Token>> negativeMappings = filter.getTokens().stream().filter(LangFilter.Token::isExclusion).collect(Collectors.groupingBy(LangFilter.Token::getIdentifier));
        List results = filter.getTokens().stream().filter(LangFilter.Token::isInclusion).flatMap(LangStringFetchPostProcessor.expandTokenGroups()).map(this.appendExclusionsToPositiveToken(negativeMappings)).collect(Collectors.toList());
        return results.stream().map(tokens -> this.parseLangFilter(LangFilter.Token.toString((List)tokens), parent, somlSchema)).collect(Collectors.toList());
    }

    private static Function<LangFilter.Token, Stream<LangFilter.Token>> expandTokenGroups() {
        return token -> {
            if (token instanceof LangFilter.TokenGroup) {
                return ((LangFilter.TokenGroup)token).getTokens().stream();
            }
            return Stream.of(token);
        };
    }

    private Function<LangFilter.Token, LinkedList<LangFilter.Token>> appendExclusionsToPositiveToken(Map<String, List<LangFilter.Token>> negativeMappings) {
        return token -> {
            LinkedList<LangFilter.Token> tokens = new LinkedList<LangFilter.Token>();
            tokens.add((LangFilter.Token)token);
            String identifier = token.getIdentifier();
            if (!LangFilter.TokenType.ANY.toString().equals(identifier) && !LangFilter.TokenType.ANY_LANG.toString().equals(identifier)) {
                tokens.addAll(negativeMappings.getOrDefault(identifier, Collections.emptyList()));
                return tokens;
            }
            negativeMappings.values().forEach(tokens::addAll);
            return tokens;
        };
    }

    private LangFilter parseLangFilter(String filterValue, Selectable selectable, SomlSchema somlSchema) {
        ArgumentParserContext parserContext = new ArgumentParserContext(selectable.getName(), OperationType.UPDATE, (Shape)somlSchema.getObjects().get((Object)"Literal"), selectable.getArguments(), this.argumentConverter, selectable.getVariables());
        String updatedFilter = LangFilter.applyUserLanguages((String)filterValue, (String)selectable.getVariables().getAcceptLanguage());
        LangFilter langFilter = this.parserLangFilter(updatedFilter, LangFilter::parseForFetching, selectable.getLocation());
        HashMap<String, LangFilter> map = new HashMap<String, LangFilter>();
        map.put("lang", langFilter);
        ExpressionValue expression = (ExpressionValue)this.argumentConverter.convert("where", map, parserContext);
        langFilter.setExpression(expression);
        return langFilter;
    }

    private LangFilter parserLangFilter(String rawValue, Function<String, LangFilter> langParser, com.ontotext.models.query.SourceLocation location) {
        try {
            return langParser.apply(rawValue);
        }
        catch (IllegalArgumentException iae) {
            SourceLocation sourceLocation = null;
            if (location != null) {
                sourceLocation = new SourceLocation(location.getLine(), location.getColumn());
            }
            throw new InvalidOperationException("", Collections.singletonList(new SimpleGraphQlError(iae.getMessage(), sourceLocation == null ? null : Collections.singletonList(sourceLocation), (ErrorClassification)ErrorType.ValidationError)));
        }
    }

    @Override
    public void setArgumentConverter(ArgumentConverter argumentConverter) {
        this.argumentConverter = argumentConverter;
    }
}

