/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphql.parser;

import com.ontotext.graphql.parser.OperationPostProcessor;
import com.ontotext.graphql.parser.argument.ArgumentConverter;
import com.ontotext.graphql.parser.argument.ArgumentConverterAware;
import com.ontotext.graphql.parser.argument.ArgumentParserContext;
import com.ontotext.models.Operation;
import com.ontotext.models.OperationType;
import com.ontotext.models.OperationVisitor;
import com.ontotext.models.OperationVisitorContext;
import com.ontotext.models.PropertyShape;
import com.ontotext.models.SchemaLangConfig;
import com.ontotext.models.Selectable;
import com.ontotext.models.Selection;
import com.ontotext.models.extensions.Order;
import com.ontotext.models.mutation.CreateMutation;
import com.ontotext.models.mutation.DeleteMutation;
import com.ontotext.models.mutation.UpdateMutation;
import com.ontotext.models.query.LangFilter;
import com.ontotext.models.query.Query;
import com.ontotext.models.subscriptions.Subscription;
import com.ontotext.rbac.SecurityContext;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;

@Order(value=300)
public class LangFilterPreferencePostProcessor
implements OperationPostProcessor,
OperationVisitor<Void, OperationVisitorContext>,
ArgumentConverterAware {
    private ArgumentConverter argumentConverter;

    @Override
    public void postProcess(Operation operation, SecurityContext securityContext) {
        operation.accept((OperationVisitor)this, null);
    }

    public Void visit(Query query, OperationVisitorContext context) {
        this.traverse((Selectable)query);
        return null;
    }

    public Void visit(Selection selection, OperationVisitorContext context) {
        Object convertedValue;
        if (selection.isComplexType() && LangFilterPreferencePostProcessor.isNotLiteralSelection(selection)) {
            this.traverse((Selectable)selection);
            return null;
        }
        if (LangFilterPreferencePostProcessor.isNotLiteralSelection(selection) && !LangFilterPreferencePostProcessor.isNameSelection(selection) || selection.getArguments().getLangFilter().isPresent()) {
            return null;
        }
        String fetchLang = this.resolveLanguagePreference(selection);
        if (fetchLang != null && (convertedValue = this.convertLangPreferenceToFilter(selection, fetchLang)) instanceof LangFilter) {
            selection.getArguments().setLangFilter((LangFilter)convertedValue);
        }
        return null;
    }

    public Void visit(CreateMutation mutation, OperationVisitorContext context) {
        this.traverse((Selectable)mutation);
        return null;
    }

    public Void visit(UpdateMutation mutation, OperationVisitorContext context) {
        this.traverse((Selectable)mutation);
        return null;
    }

    public Void visit(DeleteMutation deleteMutation, OperationVisitorContext context) {
        this.traverse((Selectable)deleteMutation);
        return null;
    }

    public Void visit(Subscription subscription, OperationVisitorContext context) {
        this.traverse((Selectable)subscription);
        return null;
    }

    private String resolveLanguagePreference(Selection selection) {
        Optional<String> langPreference = LangFilterPreferencePostProcessor.resolveQueryLangPreference(selection);
        return langPreference.orElseGet(() -> LangFilterPreferencePostProcessor.resolveSchemaPropertyLangPreference(selection).orElseGet(this.literalNameDefault(selection)));
    }

    private static boolean isNotLiteralSelection(Selection selection) {
        return !"Literal".equals(selection.getType());
    }

    private static boolean isNameSelection(Selection selection) {
        return "name".equals(selection.getName());
    }

    private static Optional<String> resolveQueryLangPreference(Selection selection) {
        Optional preference = selection.getArguments().getLangFilterPreference();
        Selection parent = selection;
        while (!preference.isPresent() && parent.getParent() != null) {
            parent = parent.getParent();
            preference = parent.getArguments().getLangFilterPreference();
        }
        return preference;
    }

    private static Optional<String> resolveSchemaPropertyLangPreference(Selection selection) {
        return selection.getProperty().filter(PropertyShape::isScalarType).filter(property -> property.getScalarType().isLangStringSupported()).filter(property -> property.getLangConfig() != null).map(property -> StringUtils.trimToNull((String)property.getLangConfig().getFetch()));
    }

    private Supplier<? extends String> literalNameDefault(Selection selection) {
        return () -> {
            if (LangFilterPreferencePostProcessor.isNameSelection(selection) && LangFilterPreferencePostProcessor.isLiteralName(selection)) {
                return selection.getDefinedInType().getContainedIn().getContainedIn().getConfig().getLang().filter(SchemaLangConfig::hasDefaultNameFetch).map(SchemaLangConfig::getDefaultNameFetch).orElse("ANY");
            }
            return null;
        };
    }

    private static boolean isLiteralName(Selection selection) {
        return selection.getProperty().filter(PropertyShape::isLiteral).isPresent();
    }

    private Object convertLangPreferenceToFilter(Selection selection, String fetchLang) {
        return this.argumentConverter.convert("lang", fetchLang, new ArgumentParserContext(selection.getName(), OperationType.QUERY, selection.getDefinedInType(), selection.getArguments(), this.argumentConverter, selection.getVariables()));
    }

    private void traverse(Selectable selectable) {
        List selections = selectable.getSelections();
        for (Selection selection : selections) {
            selection.accept((OperationVisitor)this, null);
        }
    }

    @Override
    public void setArgumentConverter(ArgumentConverter argumentConverter) {
        this.argumentConverter = argumentConverter;
    }
}

