/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphql.parser;

import com.ontotext.graphql.parser.OperationPostProcessor;
import com.ontotext.graphql.parser.QueryTraversal;
import com.ontotext.graphql.parser.QueryTraversalControl;
import com.ontotext.graphql.parser.argument.ArgumentConverter;
import com.ontotext.graphql.parser.argument.DefaultArgumentConverter;
import com.ontotext.graphql.parser.exceptions.InvalidOperationException;
import com.ontotext.graphql.validator.GraphQlValidator;
import com.ontotext.graphql.validator.SimpleGraphQlError;
import com.ontotext.graphql.validator.ValidatedQuery;
import com.ontotext.models.BaseOperation;
import com.ontotext.models.Operation;
import com.ontotext.models.SomlSchema;
import com.ontotext.models.mutation.Mutation;
import com.ontotext.models.query.QueryParser;
import com.ontotext.models.query.Variables;
import com.ontotext.rbac.SecurityContext;
import com.ontotext.soaas.common.connection.EndpointBuilder;
import graphql.ErrorClassification;
import graphql.ErrorType;
import graphql.GraphQLError;
import graphql.execution.UnknownOperationException;
import graphql.language.Document;
import graphql.language.Field;
import graphql.language.FragmentDefinition;
import graphql.language.OperationDefinition;
import graphql.schema.GraphQLSchema;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphQlQueryParser
implements QueryParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final QueryTraversalControl control;
    private final GraphQlValidator queryValidator;
    private Function<String, Mutation> mutationBuilder;

    public GraphQlQueryParser(GraphQLSchema graphQlSchema, SomlSchema somlSchema) {
        this(graphQlSchema, somlSchema, new DefaultArgumentConverter());
    }

    public GraphQlQueryParser(GraphQLSchema graphQlSchema, SomlSchema somlSchema, ArgumentConverter argumentConverter) {
        this.queryValidator = new GraphQlValidator(graphQlSchema);
        this.control = new QueryTraversalControl(somlSchema, graphQlSchema, argumentConverter);
    }

    public ArgumentConverter getArgumentConverter() {
        return this.control.getArgumentConverter();
    }

    public GraphQlQueryParser addOperationPostProcessor(OperationPostProcessor postProcessor) {
        this.control.addPostProcessor(postProcessor);
        return this;
    }

    public GraphQlQueryParser addOperationPostProcessor(List<OperationPostProcessor> postProcessors) {
        postProcessors.forEach(this::addOperationPostProcessor);
        return this;
    }

    public GraphQlQueryParser setOperationPostProcessorFilter(BiPredicate<OperationPostProcessor, Operation> postProcessorFilter) {
        this.control.setOperationPostProcessor(postProcessorFilter);
        return this;
    }

    public List<Operation> parse(Object queryInput, String operationName, Variables variables, EndpointBuilder endpointBuilder, SecurityContext securityContext) {
        Document parsedQuery = this.parseGraphQlQuery(queryInput);
        Optional<OperationDefinition> opDef = GraphQlQueryParser.getOperation(parsedQuery, operationName);
        List queryDefinitions = opDef.map(GraphQlQueryParser::getQueries).filter(list -> !list.isEmpty()).orElseThrow(this.notSupportedOperation());
        Map<String, FragmentDefinition> fragments = GraphQlQueryParser.getFragments(parsedQuery);
        ArrayList<Operation> operations = new ArrayList<Operation>(queryDefinitions.size());
        OperationDefinition operationDefinition = opDef.get();
        QueryTraversal traversal = new QueryTraversal(this.control, variables, fragments, operationDefinition.getVariableDefinitions(), endpointBuilder, this.getMutationBuilder(), securityContext);
        OperationDefinition.Operation operation = operationDefinition.getOperation();
        LinkedList<GraphQLError> graphQlErrors = new LinkedList<GraphQLError>();
        for (Field queryDefinition : queryDefinitions) {
            try {
                operations.add(traversal.traverse(operation, queryDefinition));
            }
            catch (InvalidOperationException ioe) {
                graphQlErrors.addAll(ioe.getErrors());
            }
            catch (RuntimeException re) {
                graphQlErrors.add(new SimpleGraphQlError(re.getMessage(), null, (ErrorClassification)ErrorType.ValidationError));
                LOGGER.warn("Failure during query parsing: ", (Throwable)re);
            }
        }
        if (graphQlErrors.isEmpty()) {
            String opName = StringUtils.trimToNull((String)opDef.get().getName());
            operations.stream().filter(BaseOperation.class::isInstance).forEach(op -> ((BaseOperation)op).setRequestOperationName(opName));
            return operations;
        }
        throw new InvalidOperationException("Query parsing error: " + String.valueOf(graphQlErrors), graphQlErrors);
    }

    private Supplier<UnsupportedOperationException> notSupportedOperation() {
        return () -> new UnsupportedOperationException("This service supports only MUTATION and QUERY operations with at least one operation.");
    }

    private Document parseGraphQlQuery(Object queryInput) {
        Objects.requireNonNull(queryInput, "Query data is required argument!");
        if (queryInput instanceof Document) {
            Document document = (Document)queryInput;
            return document;
        }
        if (!(queryInput instanceof String)) {
            throw new IllegalArgumentException("Unsupported query type: " + String.valueOf(queryInput.getClass()));
        }
        ValidatedQuery validatedQuery = this.queryValidator.validateQuery(queryInput.toString());
        if (!validatedQuery.isValid()) {
            throw new InvalidOperationException("Invalid query: " + String.valueOf(validatedQuery.getErrors()), validatedQuery.getErrors());
        }
        return validatedQuery.getParsedQuery();
    }

    private static Optional<OperationDefinition> getOperation(Document parsedQuery, String operationName) {
        GraphQlQueryParser.checkIsOperationNameRequired(operationName, parsedQuery);
        LinkedList<String> operationNames = new LinkedList<String>();
        for (OperationDefinition def : parsedQuery.getDefinitionsOfType(OperationDefinition.class)) {
            operationNames.add(def.getName());
            if (operationName != null && !operationName.isEmpty()) {
                if (!Objects.equals(def.getName(), operationName)) continue;
                return Optional.of(def);
            }
            return Optional.of(def);
        }
        throw new UnknownOperationException(String.format("\"operationName\" : \"%s\" does not match any of the defined operations: %s", operationName, operationNames));
    }

    private static void checkIsOperationNameRequired(String operationName, Document document) {
        if (StringUtils.isBlank((CharSequence)operationName) && document.getDefinitionsOfType(OperationDefinition.class).size() > 1) {
            throw new UnknownOperationException("\"operationName\" is required when multiple operations are passed");
        }
    }

    private static List<Field> getQueries(OperationDefinition operationDefinition) {
        return operationDefinition.getSelectionSet().getSelectionsOfType(Field.class);
    }

    private static Map<String, FragmentDefinition> getFragments(Document parsedQuery) {
        LinkedHashMap<String, FragmentDefinition> fragmentDefinitions = new LinkedHashMap<String, FragmentDefinition>();
        for (FragmentDefinition def : parsedQuery.getDefinitionsOfType(FragmentDefinition.class)) {
            fragmentDefinitions.put(def.getName(), def);
        }
        return fragmentDefinitions;
    }

    @Nullable
    public Function<String, Mutation> getMutationBuilder() {
        return this.mutationBuilder;
    }

    public void setMutationBuilder(@Nullable Function<String, Mutation> mutationBuilder) {
        this.mutationBuilder = mutationBuilder;
    }
}

