/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphql.parser;

import com.ontotext.graphql.parser.OperationPostProcessor;
import com.ontotext.models.Operation;
import com.ontotext.models.PropertyShape;
import com.ontotext.models.Selectable;
import com.ontotext.models.Selection;
import com.ontotext.models.Shape;
import com.ontotext.models.SomlSchema;
import com.ontotext.rbac.SecurityContext;
import com.ontotext.soaas.plugin.Order;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.RandomStringUtils;

@Order(value=200)
public class FragmentOptimization
implements OperationPostProcessor {
    private static final String TYPENAME = "__typename";

    @Override
    public void postProcess(Operation operation, SecurityContext securityContext) {
        SomlSchema somlSchema = operation.getSchema();
        if (!somlSchema.getObjects().containsKey((Object)operation.getType())) {
            return;
        }
        this.processSelectionsTree((Selectable)operation, somlSchema);
    }

    private void processSelectionsTree(Selectable selectable, SomlSchema somlSchema) {
        if (!selectable.isComplexType()) {
            return;
        }
        if (selectable.getShapeType().filter(Shape::isUnion).isEmpty()) {
            this.processDuplicateSelections(selectable);
            this.processSelectionAndFragment(selectable, selectable, somlSchema);
            this.mergeCommonFragmentSelections(selectable);
        }
        for (Selectable selection : selectable.getSelections()) {
            this.processSelectionsTree(selection, somlSchema);
        }
    }

    private void processDuplicateSelections(Selectable selection) {
        Map selectionsMap = selection.getSelections().stream().collect(Collectors.groupingBy(this.selectableClassifier(), LinkedHashMap::new, Collectors.mapping(Function.identity(), Collectors.toList())));
        selection.getSelections().clear();
        ArrayList updatedList = new ArrayList();
        selectionsMap.forEach((key, list) -> {
            if (key.endsWith("inFrag") || list.size() < 2) {
                updatedList.addAll(list);
            } else {
                this.mergeIfApplicable((List<Selectable>)list, updatedList::add);
            }
        });
        selection.getSelections().addAll(updatedList);
        updatedList.stream().map(Selection.class::cast).forEach(selectable -> selectable.setParent(selection));
    }

    private Function<Selectable, String> selectableClassifier() {
        return selectable -> !selectable.isInFragment() ? selectable.getResponseName() : String.join((CharSequence)"_", selectable.getResponseName(), RandomStringUtils.secure().nextAlphanumeric(5), "inFrag");
    }

    private void mergeIfApplicable(List<Selectable> inputGroup, Consumer<Selectable> consumer) {
        List requestedByUser = inputGroup.stream().filter(Selectable::isRequestedByUser).collect(Collectors.toList());
        if (requestedByUser.size() == 1) {
            inputGroup.forEach(consumer);
            return;
        }
        Map<String, List<Selectable>> groupByArguments = requestedByUser.stream().collect(Collectors.groupingBy(selectable -> selectable.getArguments().toString()));
        for (List<Selectable> listValue : groupByArguments.values()) {
            if (listValue.size() == 1) {
                listValue.forEach(consumer);
                continue;
            }
            Map<String, List<Selectable>> byRdfProp = listValue.stream().collect(Collectors.groupingBy(selectable -> selectable.getProperty().map(PropertyShape::getRdfProp).orElse("none")));
            byRdfProp.forEach((rdfProp, selectables) -> {
                if (selectables.size() == 1 || rdfProp.equals("none")) {
                    consumer.accept((Selectable)selectables.get(0));
                } else {
                    Iterator iterator = listValue.iterator();
                    Selectable selectable = (Selectable)iterator.next();
                    while (iterator.hasNext()) {
                        selectable = this.merge(selectable, (Selectable)iterator.next());
                    }
                    consumer.accept(selectable);
                }
            });
        }
    }

    private Selectable merge(Selectable first, Selectable second) {
        if (first.isComplexType() && first instanceof Selection) {
            Selection newSelection = ((Selection)first).deepCopy();
            this.processDuplicateSelections((Selectable)newSelection);
            newSelection.getSelections().clear();
            LinkedHashSet mergedSelections = new LinkedHashSet();
            mergedSelections.addAll(first.getSelections());
            mergedSelections.addAll(second.getSelections());
            newSelection.getSelections().addAll(mergedSelections);
            return newSelection;
        }
        return first;
    }

    private void processSelectionAndFragment(Selectable selection, Selectable fragment, SomlSchema somlSchema) {
        List fragmentSelections = fragment.getSelections().stream().filter(Selectable::isInFragment).collect(Collectors.toList());
        if (fragmentSelections.isEmpty()) {
            return;
        }
        Map nonFragmentSelections = selection.getSelections().stream().filter(selectable -> !selectable.isInFragment()).collect(Collectors.toMap(Selectable::getResponseName, Function.identity()));
        boolean addTypenameSelection = false;
        for (Selectable fragmentSelection : fragmentSelections) {
            Selectable match = (Selectable)nonFragmentSelections.get(fragmentSelection.getResponseName());
            if (!this.processEqualSubSelections(match, fragmentSelection, somlSchema)) continue;
            fragment.getSelections().remove(fragmentSelection);
            if (match.isComplexType() && match instanceof Selection && this.isTypenameNotPresent(match)) {
                this.appendTypenameSelection(match, somlSchema);
            }
            addTypenameSelection = true;
        }
        if (selection instanceof Selection && (!selection.isRangeCheck() || addTypenameSelection) && this.isTypenameNotPresent(selection)) {
            this.appendTypenameSelection(selection, somlSchema);
        }
    }

    private void mergeCommonFragmentSelections(Selectable selection) {
        Map<String, List<Selectable>> fragmentSelectionsMap = selection.getSelections().stream().filter(Selectable::isInFragment).collect(Collectors.groupingBy(Selectable::getResponseName));
        fragmentSelectionsMap.values().removeIf(list -> list.size() == 1);
        fragmentSelectionsMap.values().removeIf(list -> list.stream().map(Selectable::getName).anyMatch(Predicate.isEqual(TYPENAME)));
        if (fragmentSelectionsMap.isEmpty()) {
            return;
        }
        for (List<Selectable> fragmentSelections : fragmentSelectionsMap.values()) {
            Selection first = (Selection)fragmentSelections.get(0);
            for (int i = 1; i < fragmentSelections.size(); ++i) {
                Selectable next = fragmentSelections.get(i);
                if (!Objects.equals(first.getService(), next.getService()) || Objects.equals(first.getDefinedInType().getId(), next.getDefinedInType().getId()) || !next.isRequestedByUser() || !FragmentOptimization.processEqualSimpleSubSelections((Selectable)first, next)) continue;
                ((Selection)next).setAsNoneQueryable();
                first.setDomainConstraints((Collection)Stream.concat(Stream.of(first.getDefinedInType(), next.getDefinedInType()), first.getDomainConstraints().stream()).distinct().collect(Collectors.toList()));
            }
        }
    }

    private boolean isInFragment(Selectable selection, String parentType, SomlSchema somlSchema) {
        String definedIn = selection.getDefinedInType().getId();
        return !parentType.equals(definedIn) && !this.isSubClassOf(parentType, definedIn, somlSchema);
    }

    private boolean isSubClassOf(String child, String parent, SomlSchema somlSchema) {
        String childType = somlSchema.getPrefixes().nameToShortIri(child);
        Shape shape = (Shape)somlSchema.getObjects().get((Object)childType);
        if (shape == null) {
            shape = (Shape)somlSchema.getObjects().get((Object)child);
        }
        return shape.isSubClassOf(parent);
    }

    private boolean isTypenameNotPresent(Selectable match) {
        return match.getSelections().stream().noneMatch(this.isTypename());
    }

    private Predicate<Selectable> isTypename() {
        return selectable -> selectable.getName().equals(TYPENAME);
    }

    private void appendTypenameSelection(Selectable parent, SomlSchema somlSchema) {
        Selection selection = new Selection();
        selection.setName(TYPENAME);
        selection.setType("String");
        selection.setRequestedByUser(false);
        String parentTypeIri = somlSchema.getPrefixes().nameToShortIri(parent.getType());
        selection.setDefinedInType((Shape)somlSchema.getObjects().get((Object)parentTypeIri));
        selection.setDefinedIn(parent.getType());
        selection.setCollection(false);
        selection.setSelections(new ArrayList(0));
        selection.setParent(parent);
        parent.getSelections().add(selection);
    }

    private boolean processEqualSubSelections(Selectable baseSelectable, Selectable fragmentSelection, SomlSchema somlSchema) {
        if (baseSelectable == null || fragmentSelection == null) {
            return false;
        }
        if (!baseSelectable.getArguments().equals((Object)fragmentSelection.getArguments())) {
            return false;
        }
        if (FragmentOptimization.notEqualSelectionPredicates(baseSelectable, fragmentSelection)) {
            return false;
        }
        if (!baseSelectable.isComplexType()) {
            return true;
        }
        this.processSelectionAndFragment(baseSelectable, fragmentSelection, somlSchema);
        if (fragmentSelection.getSelections().isEmpty()) {
            return true;
        }
        Map selectableMap = baseSelectable.getSelections().stream().filter(selectable -> !this.isInFragment((Selectable)selectable, fragmentSelection.getType(), somlSchema)).collect(Collectors.toMap(Selectable::getResponseName, Function.identity()));
        for (Selectable fromFragment : new ArrayList(fragmentSelection.getSelections())) {
            Selectable match = (Selectable)selectableMap.get(fromFragment.getResponseName());
            if (!this.processEqualSubSelections(match, fromFragment, somlSchema)) continue;
            fragmentSelection.getSelections().remove(fromFragment);
        }
        return fragmentSelection.getSelections().isEmpty();
    }

    private static boolean processEqualSimpleSubSelections(Selectable baseSelectable, Selectable fragmentSelection) {
        if (baseSelectable == null || fragmentSelection == null) {
            return false;
        }
        if (!Objects.equals(baseSelectable.getArguments(), fragmentSelection.getArguments())) {
            return false;
        }
        if (FragmentOptimization.notEqualSelectionPredicates(baseSelectable, fragmentSelection)) {
            return false;
        }
        return !baseSelectable.isComplexType();
    }

    private static boolean notEqualSelectionPredicates(Selectable baseSelectable, Selectable fragmentSelection) {
        String fragmentRdfProp;
        String baseRdfProp = baseSelectable.getProperty().map(PropertyShape::getRdfProp).orElse(null);
        return !Objects.equals(baseRdfProp, fragmentRdfProp = (String)fragmentSelection.getProperty().map(PropertyShape::getRdfProp).orElse(null));
    }
}

