/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphql.parser;

import com.ontotext.graphql.parser.OperationPostProcessor;
import com.ontotext.models.Operation;
import com.ontotext.models.PropertyShape;
import com.ontotext.models.Selectable;
import com.ontotext.models.Selection;
import com.ontotext.models.templates.PropertyRef;
import com.ontotext.models.templates.Template;
import com.ontotext.rbac.SecurityContext;
import com.ontotext.soaas.plugin.Order;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

@Order(value=1000)
public class ExternalVariableSparqlTemplatesHandler
implements OperationPostProcessor {
    @Override
    public void postProcess(Operation operation, SecurityContext securityContext) {
        List selections = operation.getSelections();
        selections.forEach(ExternalVariableSparqlTemplatesHandler::processSelection);
    }

    private static void processSelection(Selectable selectable) {
        if (!selectable.isQueryable()) {
            return;
        }
        Selection selection = (Selection)selectable;
        Optional<Template> template = selection.getProperty().filter(PropertyShape::isSparqlTemplate).filter(prop -> !prop.getSparqlTemplate().getExternalPropertyBindings().isEmpty()).map(PropertyShape::getSparqlTemplate);
        if (template.isPresent()) {
            for (PropertyRef propertyRef : template.get().getExternalPropertyBindings()) {
                if (!propertyRef.isInternal() || propertyRef.isNested() && propertyRef.isSubjectBased()) {
                    ExternalVariableSparqlTemplatesHandler.disableParentPropertyQueryability((Selectable)selection, propertyRef.segments().collect(Collectors.toList()));
                    continue;
                }
                if (!propertyRef.isNested() || !propertyRef.isValueBased()) continue;
                ExternalVariableSparqlTemplatesHandler.disablePropertyQueryability((Selectable)selection, propertyRef.segments().collect(Collectors.toList()));
            }
        }
        for (Selectable selectable1 : selectable.getSelections()) {
            ExternalVariableSparqlTemplatesHandler.processSelection(selectable1);
        }
    }

    private static void disableParentPropertyQueryability(Selectable current, List<String> path) {
        if (path.isEmpty()) {
            return;
        }
        String property = path.removeFirst();
        Optional selection = current.getParent().getSelections().stream().filter(Selectable.byName((String)property)).findFirst();
        if (selection.isPresent()) {
            if (selection.filter(item -> item != current).isPresent() && path.isEmpty()) {
                ((Selection)selection.get()).setAsNoneQueryable();
                return;
            }
            ExternalVariableSparqlTemplatesHandler.disablePropertyQueryability((Selectable)selection.get(), path);
        }
    }

    private static void disablePropertyQueryability(Selectable parent, List<String> path) {
        if (path.isEmpty()) {
            return;
        }
        String property = path.removeFirst();
        Optional selection = parent.getSelections().stream().filter(Selectable.byName((String)property)).findFirst();
        if (selection.isPresent()) {
            if (path.isEmpty()) {
                ((Selection)selection.get()).setAsNoneQueryable();
                return;
            }
            ExternalVariableSparqlTemplatesHandler.disablePropertyQueryability((Selectable)selection.get(), path);
        }
    }
}

