/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphql.parser;

import com.ontotext.graphql.parser.OperationPostProcessor;
import com.ontotext.models.Operation;
import com.ontotext.models.PropertyShape;
import com.ontotext.models.Selectable;
import com.ontotext.models.Selection;
import com.ontotext.models.Shape;
import com.ontotext.models.query.Arguments;
import com.ontotext.models.query.Query;
import com.ontotext.rbac.SecurityContext;
import com.ontotext.soaas.plugin.Order;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;

@Order(value=750)
public class CountPostProcessor
implements OperationPostProcessor {
    @Override
    public void postProcess(Operation operation, SecurityContext securityContext) {
        if (!(operation instanceof Query) || operation.isCountSelection()) {
            return;
        }
        this.processSelection((Selectable)operation);
    }

    private void processSelection(Selectable selectable) {
        for (Selectable subSelection : new ArrayList(selectable.getSelections())) {
            Optional countedSelection;
            if (subSelection.isCountSelection() && ((countedSelection = subSelection.getCountedSelection()).isEmpty() || !subSelection.getArguments().isEmpty())) {
                this.createMissingSelection(selectable, subSelection);
            }
            if (!subSelection.isComplexType()) continue;
            this.processSelection(subSelection);
        }
    }

    private void createMissingSelection(Selectable parent, Selectable countSelection) {
        Optional countedProperty = countSelection.getProperty().flatMap(PropertyShape::resolveCountedProperty);
        if (countedProperty.isEmpty()) {
            return;
        }
        Selection counted = new Selection();
        PropertyShape propertyShape = (PropertyShape)countedProperty.get();
        counted.setName(propertyShape.asGraphQl());
        Shape rangeShape = propertyShape.getRangeShape();
        if (propertyShape.isScalarType()) {
            counted.setType(propertyShape.getRange());
        } else {
            counted.setType(rangeShape.asGraphQl());
        }
        counted.setSelections(new ArrayList());
        counted.setArguments(new Arguments((Map)countSelection.getArguments()));
        counted.getWhereSelections().addAll(countSelection.getWhereSelections());
        counted.setDefinedInType(countSelection.getDefinedInType());
        counted.setDefinedIn(countSelection.getDefinedInType().getId());
        counted.setRequestedByUser(false);
        counted.setAsNoneQueryable();
        counted.setParent(parent);
        parent.getSelections().add(counted);
        if (rangeShape != null && rangeShape.isUnion()) {
            for (Shape type : rangeShape.getUnionOfShapes()) {
                CountPostProcessor.generateIdSelection(counted, type.getId(), type);
            }
        } else if (counted.getShapeType().isPresent() && counted.getShapeType().filter(shape -> shape.getId().equals("Literal")).isEmpty()) {
            CountPostProcessor.generateIdSelection(counted, propertyShape.getRange(), rangeShape);
        }
    }

    private static void generateIdSelection(Selection counted, String range, Shape rangeShape) {
        Selection id = new Selection();
        id.setSelections(new ArrayList());
        id.setArguments(new Arguments());
        id.setName("id");
        id.setType("iri");
        id.setDefinedInType(rangeShape);
        id.setDefinedIn(range);
        id.setRequestedByUser(false);
        id.setParent((Selectable)counted);
        counted.getSelections().add(id);
    }
}

