/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphql.parser;

import com.ontotext.graphql.PropertyChangeUtil;
import com.ontotext.graphql.parser.OperationPostProcessor;
import com.ontotext.models.Operation;
import com.ontotext.models.Shape;
import com.ontotext.models.extensions.Order;
import com.ontotext.models.mutation.Change;
import com.ontotext.models.mutation.CreateMutation;
import com.ontotext.models.mutation.Mutation;
import com.ontotext.models.mutation.PropertyChange;
import com.ontotext.models.mutation.UpdateMutation;
import com.ontotext.rbac.SecurityContext;
import com.ontotext.soaas.common.CollectionsUtil;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Order(value=900)
public class CollapseChangesPostProcessor
implements OperationPostProcessor {
    @Override
    public void postProcess(Operation operation, SecurityContext securityContext) {
        if (operation.getArguments().getChanges().isPresent() && (operation instanceof UpdateMutation || operation instanceof CreateMutation)) {
            for (Change change : ((Mutation)operation).getChanges()) {
                Shape shape = change.getShape();
                for (List<PropertyChange> changeList : PropertyChangeUtil.getSanitizedGroupedChanges(change, PropertyChange::getName, Stream.of(PropertyChangeUtil.hasScalarProperty(shape), PropertyChangeUtil.hasMultiValuedProperty(shape)).collect(Collectors.toList()))) {
                    this.collapseChanges(changeList, change);
                }
            }
        }
    }

    private void collapseChanges(List<PropertyChange> changeList, Change change) {
        LinkedHashSet valuesToAdd = new LinkedHashSet();
        LinkedHashSet valuesToRemove = new LinkedHashSet();
        boolean hasConditions = PropertyChange.sortValuesForChanges(valuesToAdd, valuesToRemove, changeList);
        if (valuesToAdd.size() == 1 && valuesToRemove.size() == 1) {
            return;
        }
        CollectionsUtil.cleanDuplicates(valuesToAdd, valuesToRemove);
        if (valuesToAdd.size() <= 1 && changeList.size() > 1 && !hasConditions) {
            change.transformChanges(propertyChange -> {
                if (changeList.contains(propertyChange)) {
                    return null;
                }
                return propertyChange;
            });
            String name = changeList.get(0).getName();
            Object value = valuesToAdd.stream().findFirst().orElse(null);
            Object patch = valuesToRemove.stream().findFirst().orElse(null);
            List sourceLocations = changeList.stream().map(PropertyChange::getSourceLocations).flatMap(Collection::stream).collect(Collectors.toList());
            change.updatePropertyValue(name, value, patch, sourceLocations);
        }
    }
}

