/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphql.parser;

import com.ontotext.graphql.parser.ArgumentCollector;
import com.ontotext.graphql.parser.ArgumentPostProcessor;
import com.ontotext.graphql.parser.argument.ArgumentConverter;
import com.ontotext.graphql.parser.argument.ArgumentParserContext;
import com.ontotext.graphql.parser.exceptions.InvalidOperationException;
import com.ontotext.graphql.validator.SimpleGraphQlError;
import com.ontotext.models.ErrorMessages;
import com.ontotext.models.OperationType;
import com.ontotext.models.Shape;
import com.ontotext.models.query.Arguments;
import com.ontotext.models.query.Variables;
import com.ontotext.soaas.common.connection.Endpoint;
import com.ontotext.soaas.common.connection.EndpointBuilder;
import com.ontotext.soaas.plugin.PluginsManager;
import graphql.ErrorClassification;
import graphql.ErrorType;
import graphql.GraphQLError;
import graphql.language.Argument;
import graphql.language.Field;
import graphql.language.NodeVisitor;
import graphql.language.SourceLocation;
import graphql.schema.GraphQLSchema;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;

class ArgumentReader {
    private final Variables variables;
    private final ArgumentConverter argumentConverter;
    private List<ArgumentPostProcessor> preProcessors;

    ArgumentReader(Variables variables, ArgumentConverter argumentConverter) {
        this.variables = variables;
        this.argumentConverter = argumentConverter;
    }

    Arguments read(GraphQLSchema schema, OperationType operationType, Field field, Shape containingType, Deque<String> path, EndpointBuilder endpointBuilder) {
        LazyArguments parsedArguments = new LazyArguments();
        ArgumentParserContext parserContext = new ArgumentParserContext(field.getName(), operationType, containingType, parsedArguments, this.argumentConverter, this.variables);
        LinkedList<GraphQLError> errors = new LinkedList<GraphQLError>();
        parsedArguments.setOnDemandValueConversion(this.onDemandValueConverter(field, parserContext, path, errors));
        String repository = parsedArguments.getRepository().orElse(null);
        Endpoint endpoint = endpointBuilder.buildEndpoint(repository);
        parserContext.setEndpoint(endpoint);
        ArgumentCollector argumentCollector = new ArgumentCollector((Map<String, Object>)this.variables);
        for (Argument argument : field.getArguments()) {
            argument.getValue().accept(null, (NodeVisitor)argumentCollector);
            String argumentName = argument.getName();
            if (parsedArguments.containsKey(argumentName)) continue;
            Object value = null;
            try {
                value = argumentCollector.getValue();
                ArgumentParserContext contextWithMetadata = this.getContextWithMetadataAndSchema(parserContext, argumentCollector.getMetadata(), schema);
                Object convertedValue = this.argumentConverter.convert(argumentName, value, contextWithMetadata);
                parsedArguments.put(argumentName, convertedValue);
            }
            catch (InvalidOperationException ioe) {
                errors.addAll(ioe.getErrors());
            }
            catch (RuntimeException re) {
                String message = this.specifyMessage(re.getMessage(), argument.getName(), value);
                errors.add(ArgumentReader.toValidationError(message, field.getSourceLocation(), path));
            }
        }
        if (!errors.isEmpty()) {
            throw new InvalidOperationException("Failed to parse some of the arguments", errors);
        }
        Arguments arguments = new Arguments((Map)((Object)parsedArguments));
        this.getPostProcessors().forEach(processor -> processor.process(arguments, field, containingType, this.argumentConverter));
        return arguments;
    }

    private ArgumentParserContext getContextWithMetadataAndSchema(ArgumentParserContext parserContext, Map<String, Object> metadata, GraphQLSchema schema) {
        if (metadata == null) {
            return parserContext;
        }
        return new ArgumentParserContext(parserContext.getFieldName(), parserContext.getOperationType(), parserContext.getContainingType(), parserContext.getArguments(), parserContext.getArgumentConverter(), metadata, schema, this.variables).setEndpoint(parserContext.getEndpoint());
    }

    private Function<String, Object> onDemandValueConverter(Field field, ArgumentParserContext parserContext, Deque<String> path, List<GraphQLError> errors) {
        return argumentName -> {
            Optional<Argument> argumentOptional = field.getArguments().stream().filter(arg -> arg.getName().equals(argumentName)).findFirst();
            if (!argumentOptional.isPresent()) {
                return null;
            }
            Argument argument = argumentOptional.get();
            ArgumentCollector argumentCollector = new ArgumentCollector((Map<String, Object>)this.variables);
            argument.getValue().accept(null, (NodeVisitor)argumentCollector);
            Object value = null;
            try {
                value = argumentCollector.getValue();
                return this.argumentConverter.convert((String)argumentName, value, parserContext);
            }
            catch (InvalidOperationException ioe) {
                errors.addAll(ioe.getErrors());
            }
            catch (RuntimeException re) {
                String message = this.specifyMessage(re.getMessage(), argument.getName(), value);
                errors.add(ArgumentReader.toValidationError(message, field.getSourceLocation(), path));
            }
            return null;
        };
    }

    private String specifyMessage(String message, String argumentName, Object value) {
        if (message != null && message.contains("IRI must be absolute")) {
            return ErrorMessages.get((String)"invalid.absolute.iri", (Object[])new Object[]{argumentName, value});
        }
        return message;
    }

    private static GraphQLError toValidationError(String message, SourceLocation sourceLocation, Collection<String> path) {
        return new SimpleGraphQlError(Objects.toString(message), Collections.singletonList(sourceLocation), (ErrorClassification)ErrorType.ValidationError, new ArrayList<String>(path));
    }

    private List<ArgumentPostProcessor> getPostProcessors() {
        if (this.preProcessors == null) {
            this.preProcessors = PluginsManager.loadPlugins(ArgumentPostProcessor.class);
        }
        return this.preProcessors;
    }

    private static class LazyArguments
    extends Arguments {
        private transient Function<String, Object> onDemandValueConversion;

        private LazyArguments() {
        }

        public Object get(Object key) {
            Object alreadyConvertedValue = super.get(key);
            if (alreadyConvertedValue != null) {
                return alreadyConvertedValue;
            }
            Object convertedValue = this.onDemandValueConversion.apply(Objects.toString(key, null));
            if (convertedValue != null) {
                this.put(Objects.toString(key, null), convertedValue);
            }
            return convertedValue;
        }

        void setOnDemandValueConversion(Function<String, Object> onDemandValueConversion) {
            this.onDemandValueConversion = onDemandValueConversion;
        }
    }
}

