/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphql;

import com.ontotext.models.Prefixes;
import com.ontotext.models.PropertyShape;
import com.ontotext.models.Shape;
import com.ontotext.models.mutation.Change;
import com.ontotext.models.mutation.PropertyChange;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class PropertyChangeUtil {
    private PropertyChangeUtil() {
        throw new IllegalStateException(this.getClass().getSimpleName() + " is an utility class!");
    }

    public static Predicate<List<PropertyChange>> hasScalarProperty(Shape shape) {
        return propertyChanges -> {
            PropertyChange change = (PropertyChange)propertyChanges.get(0);
            Prefixes prefixes = shape.getContainedIn().getContainedIn().getPrefixes();
            return shape.getProperty(prefixes.nameToShortIri(change.getName())).filter(propertyShape -> propertyShape.isScalarType() || propertyShape.isLiteral()).isPresent();
        };
    }

    public static Predicate<List<PropertyChange>> hasMultiValuedProperty(Shape shape) {
        return propertyChanges -> {
            PropertyChange change = (PropertyChange)propertyChanges.get(0);
            Prefixes prefixes = shape.getContainedIn().getContainedIn().getPrefixes();
            return shape.getProperty(prefixes.nameToShortIri(change.getName())).filter(PropertyShape::isMultivalued).isPresent();
        };
    }

    public static Collection<List<PropertyChange>> getSanitizedGroupedChanges(Change change, Function<? super PropertyChange, ? extends String> grouping, List<Predicate<List<PropertyChange>>> sanitizers) {
        Map<? extends String, List<? super PropertyChange>> groupedChanges = change.getChanges().stream().collect(Collectors.groupingBy(grouping));
        for (Predicate<List<PropertyChange>> sanitizer : sanitizers) {
            groupedChanges.values().removeIf(sanitizer);
        }
        return groupedChanges.values();
    }
}

