/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.injection.impl;

import com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.answering.reformulation.QueryReformulator;
import it.unibz.inf.ontop.answering.reformulation.impl.ToFullNativeQueryReformulator;
import it.unibz.inf.ontop.injection.OntopOBDASettings;
import it.unibz.inf.ontop.injection.OntopReformulationSettings;
import it.unibz.inf.ontop.injection.impl.OntopKGQuerySettingsImpl;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nullable;

public class OntopReformulationSettingsImpl
extends OntopKGQuerySettingsImpl
implements OntopReformulationSettings {
    private static final String DEFAULT_FILE = "reformulation-default.properties";
    private @Nullable ImmutableSet<String> httpHeaderNamesToLog;

    OntopReformulationSettingsImpl(Properties userProperties) {
        super(OntopReformulationSettingsImpl.loadProperties(userProperties));
    }

    private static Properties loadProperties(Properties userProperties) {
        Properties properties = OntopReformulationSettingsImpl.loadDefaultRuntimeProperties();
        properties.putAll((Map<?, ?>)userProperties);
        if (Boolean.parseBoolean(userProperties.getProperty("ontop.reformulateToFullNativeQuery", "false")) && !userProperties.contains(QueryReformulator.class.getCanonicalName())) {
            properties.put(QueryReformulator.class.getCanonicalName(), ToFullNativeQueryReformulator.class.getCanonicalName());
        }
        return properties;
    }

    static Properties loadDefaultRuntimeProperties() {
        return OntopReformulationSettingsImpl.loadDefaultPropertiesFromFile(OntopOBDASettings.class, (String)DEFAULT_FILE);
    }

    @Override
    public boolean isExistentialReasoningEnabled() {
        return this.getRequiredBoolean("ontop.existentialReasoning");
    }

    @Override
    public boolean isPostProcessingAvoided() {
        return this.getRequiredBoolean("ontop.avoidPostProcessing");
    }

    @Override
    public boolean areInvalidTriplesExcludedFromResultSet() {
        return this.getRequiredBoolean("ontop.excludeInvalidTriplesFromResultSet");
    }

    @Override
    public boolean isQueryLoggingEnabled() {
        return this.getRequiredBoolean("ontop.queryLogging");
    }

    @Override
    public boolean isQueryTemplateExtractionEnabled() {
        return this.getRequiredBoolean("ontop.queryLogging.extractQueryTemplate");
    }

    @Override
    public boolean isSparqlQueryIncludedIntoQueryLog() {
        return this.getRequiredBoolean("ontop.queryLogging.includeSparqlQuery");
    }

    @Override
    public boolean isReformulatedQueryIncludedIntoQueryLog() {
        return this.getRequiredBoolean("ontop.queryLogging.includeReformulatedQuery");
    }

    @Override
    public boolean areClassesAndPropertiesIncludedIntoQueryLog() {
        return this.getRequiredBoolean("ontop.queryLogging.includeClassesAndProperties");
    }

    @Override
    public boolean areTablesIncludedIntoQueryLog() {
        return this.getRequiredBoolean("ontop.queryLogging.includeTables");
    }

    @Override
    public boolean isUserInfoIncludedIntoQueryLog() {
        return this.getRequiredBoolean("ontop.queryLogging.includeUserInfo");
    }

    @Override
    public boolean isQueryLoggingDecompositionEnabled() {
        return this.getRequiredBoolean("ontop.queryLogging.decomposition");
    }

    @Override
    public boolean areQueryLoggingDecompositionAndMergingMutuallyExclusive() {
        return this.getRequiredBoolean("ontop.queryLogging.decompositionAndMergingMutuallyExclusive");
    }

    @Override
    public long getQueryCacheMaxSize() {
        return this.getRequiredLong("ontop.cache.query.size");
    }

    @Override
    public String getApplicationName() {
        return this.getRequiredProperty("ontop.applicationName");
    }

    @Override
    public synchronized ImmutableSet<String> getHttpHeaderNamesToLog() {
        if (this.httpHeaderNamesToLog == null) {
            this.httpHeaderNamesToLog = (ImmutableSet)Collections.list(this.getPropertyKeys()).stream().filter(k -> k instanceof String).map(k -> (String)k).filter(k -> k.startsWith("ontop.queryLogging.includeHttpHeader.")).filter(k -> this.getBoolean((String)k).filter(b -> b).isPresent()).map(k -> k.substring("ontop.queryLogging.includeHttpHeader.".length())).map(String::toLowerCase).collect(ImmutableCollectors.toSet());
        }
        return this.httpHeaderNamesToLog;
    }
}

