/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.answering.reformulation.rewriting.impl;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Provider;
import it.unibz.inf.ontop.answering.reformulation.rewriting.ExistentialQueryRewriter;
import it.unibz.inf.ontop.answering.reformulation.rewriting.impl.BasicGraphPatternTransformer;
import it.unibz.inf.ontop.answering.reformulation.rewriting.impl.DummyRewriter;
import it.unibz.inf.ontop.answering.reformulation.rewriting.impl.QueryConnectedComponent;
import it.unibz.inf.ontop.answering.reformulation.rewriting.impl.TreeWitness;
import it.unibz.inf.ontop.answering.reformulation.rewriting.impl.TreeWitnessGenerator;
import it.unibz.inf.ontop.answering.reformulation.rewriting.impl.TreeWitnessRewriterReasoner;
import it.unibz.inf.ontop.answering.reformulation.rewriting.impl.TreeWitnessSet;
import it.unibz.inf.ontop.constraints.HomomorphismFactory;
import it.unibz.inf.ontop.constraints.ImmutableCQ;
import it.unibz.inf.ontop.constraints.ImmutableCQContainmentCheck;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.iq.IQ;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.exception.EmptyQueryException;
import it.unibz.inf.ontop.iq.impl.IQTreeTools;
import it.unibz.inf.ontop.iq.node.ConstructionNode;
import it.unibz.inf.ontop.iq.node.IntensionalDataNode;
import it.unibz.inf.ontop.iq.node.NaryOperatorNode;
import it.unibz.inf.ontop.iq.node.UnaryOperatorNode;
import it.unibz.inf.ontop.iq.transform.IQTreeVisitingTransformer;
import it.unibz.inf.ontop.iq.transform.impl.DefaultRecursiveIQTreeVisitingTransformer;
import it.unibz.inf.ontop.model.atom.AtomFactory;
import it.unibz.inf.ontop.model.atom.AtomPredicate;
import it.unibz.inf.ontop.model.atom.DataAtom;
import it.unibz.inf.ontop.model.atom.RDFAtomPredicate;
import it.unibz.inf.ontop.model.atom.TriplePredicate;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.VariableOrGroundTerm;
import it.unibz.inf.ontop.spec.ontology.ClassExpression;
import it.unibz.inf.ontop.spec.ontology.ClassifiedTBox;
import it.unibz.inf.ontop.spec.ontology.DataPropertyExpression;
import it.unibz.inf.ontop.spec.ontology.OClass;
import it.unibz.inf.ontop.spec.ontology.ObjectPropertyExpression;
import it.unibz.inf.ontop.substitution.Substitution;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.rdf.api.IRI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TreeWitnessRewriter
extends DummyRewriter
implements ExistentialQueryRewriter {
    private static final Logger log = LoggerFactory.getLogger(TreeWitnessRewriter.class);
    private TreeWitnessRewriterReasoner reasoner;
    private ImmutableCQContainmentCheck<RDFAtomPredicate> containmentCheckUnderLIDs;
    private final SubstitutionFactory substitutionFactory;
    private final IQTreeTools iqTreeTools;
    private int freshVarIndex = 0;
    private double time = 0.0;

    @Inject
    private TreeWitnessRewriter(AtomFactory atomFactory, TermFactory termFactory, IntermediateQueryFactory iqFactory, SubstitutionFactory substitutionFactory, HomomorphismFactory homomorphismFactory, IQTreeTools iqTreeTools) {
        super(iqFactory, atomFactory, termFactory, homomorphismFactory);
        this.substitutionFactory = substitutionFactory;
        this.iqTreeTools = iqTreeTools;
    }

    @Override
    public void setTBox(ClassifiedTBox classifiedTBox) {
        double startime = System.currentTimeMillis();
        this.reasoner = new TreeWitnessRewriterReasoner(classifiedTBox);
        super.setTBox(classifiedTBox);
        this.containmentCheckUnderLIDs = this.homomorphismFactory.getCQContainmentCheck(this.getSigma());
        double endtime = System.currentTimeMillis();
        double tm = (endtime - startime) / 1000.0;
        this.time += tm;
        log.debug(String.format("setTBox time: %.3f s (total %.3f s)", tm, this.time));
    }

    private Variable getFreshVariable() {
        ++this.freshVarIndex;
        return this.termFactory.getVariable("twr" + this.freshVarIndex);
    }

    private ImmutableSet<DataAtom<RDFAtomPredicate>> getAtomsForGenerators(Stream<TreeWitnessGenerator> gens, VariableOrGroundTerm r0) {
        return (ImmutableSet)gens.flatMap(g -> g.getMaximalGeneratorRepresentatives().stream()).map(ce -> this.getAtom((ClassExpression)ce, r0, (Provider<VariableOrGroundTerm>)((Provider)this::getFreshVariable))).collect(ImmutableCollectors.toSet());
    }

    private static ImmutableCQ<RDFAtomPredicate> createCQ(ImmutableSet<Variable> answerVariables, Substitution<VariableOrGroundTerm> substitution, ImmutableList<DataAtom<RDFAtomPredicate>> atoms) {
        return new ImmutableCQ(answerVariables, substitution, atoms);
    }

    private ImmutableCQ<RDFAtomPredicate> createCQ(ImmutableList<DataAtom<RDFAtomPredicate>> atoms) {
        return new ImmutableCQ((ImmutableSet)atoms.stream().flatMap(a -> a.getVariables().stream()).collect(ImmutableCollectors.toSet()), this.substitutionFactory.getSubstitution(), atoms);
    }

    public Collector<Stream<ImmutableCQ<RDFAtomPredicate>>, UCQBuilder, ImmutableList<ImmutableCQ<RDFAtomPredicate>>> toUCQ(ImmutableCQ<RDFAtomPredicate> cq) {
        return Collector.of(() -> new UCQBuilder(cq), UCQBuilder::join, (b1, b2) -> b1.join(b2.build().stream()), UCQBuilder::build, Collector.Characteristics.UNORDERED);
    }

    public Collector<Stream<ImmutableCQ<RDFAtomPredicate>>, UCQBuilder, ImmutableList<ImmutableCQ<RDFAtomPredicate>>> toUCQ() {
        return this.toUCQ(this.createCQ((ImmutableList<DataAtom<RDFAtomPredicate>>)ImmutableList.of()));
    }

    private VariableOrGroundTerm getEquivalenceClassRepresentative(Set<VariableOrGroundTerm> equivalenceClass) {
        ImmutableSet equivalenceClassVariables = (ImmutableSet)equivalenceClass.stream().filter(t -> t instanceof Variable).map(t -> (Variable)t).collect(ImmutableCollectors.toSet());
        switch (equivalenceClass.size() - equivalenceClassVariables.size()) {
            case 0: {
                return (VariableOrGroundTerm)equivalenceClassVariables.stream().min(Comparator.comparing(Object::toString)).get();
            }
            case 1: {
                return (VariableOrGroundTerm)Sets.difference(equivalenceClass, (Set)equivalenceClassVariables).stream().findFirst().get();
            }
        }
        return null;
    }

    private Substitution<VariableOrGroundTerm> getSubstitution(ImmutableMap<Set<VariableOrGroundTerm>, VariableOrGroundTerm> map) {
        return (Substitution)map.entrySet().stream().flatMap(e -> ((Set)e.getKey()).stream().filter(v -> v != e.getValue()).map(v -> Maps.immutableEntry((Object)((Variable)v), (Object)((VariableOrGroundTerm)e.getValue())))).collect(this.substitutionFactory.toSubstitution());
    }

    ImmutableList<ImmutableCQ<RDFAtomPredicate>> getTreeWitnessFormula(TreeWitness tw) {
        ImmutableSet<VariableOrGroundTerm> roots = tw.getRoots();
        VariableOrGroundTerm representative = this.getEquivalenceClassRepresentative((Set<VariableOrGroundTerm>)roots);
        if (representative == null) {
            return ImmutableList.of();
        }
        Substitution<VariableOrGroundTerm> substitution = this.getSubstitution((ImmutableMap<Set<VariableOrGroundTerm>, VariableOrGroundTerm>)ImmutableMap.of(roots, (Object)representative));
        ImmutableSet rootVariables = (ImmutableSet)roots.stream().filter(t -> t instanceof Variable).map(t -> (Variable)t).collect(ImmutableCollectors.toSet());
        UCQBuilder ucq = new UCQBuilder(TreeWitnessRewriter.createCQ((ImmutableSet<Variable>)rootVariables, substitution, (ImmutableList<DataAtom<RDFAtomPredicate>>)ImmutableList.copyOf(tw.getRootAtoms())));
        return ucq.join(this.getAtomsForGenerators(tw.getGenerators().stream(), representative).stream().map(a -> this.createCQ((ImmutableList<DataAtom<RDFAtomPredicate>>)ImmutableList.of((Object)a)))).build();
    }

    private ImmutableList<ImmutableCQ<RDFAtomPredicate>> rewriteCC(QueryConnectedComponent cc) {
        TreeWitnessSet tws = TreeWitnessSet.getTreeWitnesses(cc, this.reasoner);
        ImmutableList.Builder builder = ImmutableList.builder();
        if (cc.hasNoFreeTerms() && (!cc.isDegenerate() || cc.getLoop().isPresent())) {
            builder.addAll((Iterable)this.getAtomsForGenerators(tws.getGeneratorsOfDetachedCC().stream(), (VariableOrGroundTerm)this.getFreshVariable()).stream().map(a -> this.createCQ((ImmutableList<DataAtom<RDFAtomPredicate>>)ImmutableList.of((Object)a))).collect(ImmutableCollectors.toList()));
        }
        if (!cc.isDegenerate()) {
            if (!TreeWitness.isCompatible(tws.getTWs())) {
                for (ImmutableCollection<TreeWitness> compatibleTWs : tws) {
                    log.debug("COMPATIBLE: {}", compatibleTWs);
                    ImmutableCQ<RDFAtomPredicate> edges = this.createCQ((ImmutableList<DataAtom<RDFAtomPredicate>>)((ImmutableList)cc.getEdges().stream().filter(edge -> compatibleTWs.stream().noneMatch(edge::isCoveredBy)).flatMap(edge -> edge.getAtoms().stream()).collect(ImmutableCollectors.toList())));
                    builder.addAll((Iterable)compatibleTWs.stream().map(tw -> this.getTreeWitnessFormula((TreeWitness)tw).stream()).collect(this.toUCQ(edges)));
                }
            } else {
                builder.addAll((Iterable)cc.getEdges().stream().map(edge -> Stream.concat(Stream.of(this.createCQ(edge.getAtoms())), tws.getTWs().stream().filter(edge::isCoveredBy).map(this::getTreeWitnessFormula).flatMap(Collection::stream))).collect(this.toUCQ()));
            }
        } else {
            log.debug("LOOP {}", cc.getLoop());
            builder.add(this.createCQ((ImmutableList<DataAtom<RDFAtomPredicate>>)cc.getLoop().map(l -> l.getAtoms()).orElse(ImmutableList.of())));
        }
        return builder.build();
    }

    private IQTree getCanonicalForm(IQTree tree) {
        final ClassifiedTBox tbox = this.reasoner.getClassifiedTBox();
        return tree.acceptTransformer((IQTreeVisitingTransformer)new DefaultRecursiveIQTreeVisitingTransformer(this.iqFactory){

            public IQTree transformIntensionalData(IntensionalDataNode dataNode) {
                ImmutableList arguments;
                DataAtom atom = dataNode.getProjectionAtom();
                TriplePredicate triplePredicate = (TriplePredicate)atom.getPredicate();
                Optional classIRI = triplePredicate.getClassIRI(arguments = atom.getArguments());
                if (classIRI.isPresent()) {
                    IRI iri = (IRI)classIRI.get();
                    if (tbox.classes().contains(iri)) {
                        OClass c = (OClass)tbox.classes().get(iri);
                        OClass equivalent = (OClass)tbox.classesDAG().getCanonicalForm((Object)c);
                        return dataNode.newAtom(TreeWitnessRewriter.this.getAtom((VariableOrGroundTerm)arguments.get(0), equivalent));
                    }
                } else {
                    Optional propertyIRI = triplePredicate.getPropertyIRI(arguments);
                    if (propertyIRI.isPresent()) {
                        IRI iri = (IRI)propertyIRI.get();
                        if (tbox.objectProperties().contains(iri)) {
                            ObjectPropertyExpression ope = (ObjectPropertyExpression)tbox.objectProperties().get(iri);
                            ObjectPropertyExpression equivalent = (ObjectPropertyExpression)tbox.objectPropertiesDAG().getCanonicalForm((Object)ope);
                            return dataNode.newAtom(TreeWitnessRewriter.this.getAtom((VariableOrGroundTerm)arguments.get(0), equivalent, (VariableOrGroundTerm)arguments.get(2)));
                        }
                        if (tbox.dataProperties().contains(iri)) {
                            DataPropertyExpression dpe = (DataPropertyExpression)tbox.dataProperties().get(iri);
                            DataPropertyExpression equivalent = (DataPropertyExpression)tbox.dataPropertiesDAG().getCanonicalForm((Object)dpe);
                            return dataNode.newAtom(TreeWitnessRewriter.this.getAtom((VariableOrGroundTerm)arguments.get(0), equivalent, (VariableOrGroundTerm)arguments.get(2)));
                        }
                    }
                }
                return dataNode;
            }
        });
    }

    private ImmutableList<IQTree> convertCQ(ImmutableCQ<RDFAtomPredicate> cq) {
        ImmutableList body = (ImmutableList)cq.getAtoms().stream().map(a -> this.iqFactory.createIntensionalDataNode(a)).collect(ImmutableCollectors.toList());
        Substitution substitution = cq.getSubstitution();
        if (substitution.isEmpty()) {
            return body;
        }
        IQTree result = this.join((ImmutableList<IQTree>)body);
        return ImmutableList.of((Object)this.iqFactory.createUnaryIQTree((UnaryOperatorNode)this.iqFactory.createConstructionNode(Sets.union((Set)result.getVariables(), (Set)substitution.getDomain()).immutableCopy(), substitution), result));
    }

    private IQTree join(ImmutableList<IQTree> atoms) {
        return atoms.size() == 1 ? (IQTree)atoms.get(0) : this.iqFactory.createNaryIQTree((NaryOperatorNode)this.iqFactory.createInnerJoinNode(), atoms);
    }

    @Override
    public IQ rewrite(IQ query) throws EmptyQueryException {
        double startime = System.currentTimeMillis();
        IQTree canonicalTree = this.getCanonicalForm(query.getTree());
        IQTree rewritingTree = canonicalTree.acceptTransformer((IQTreeVisitingTransformer)new DefaultRecursiveIQTreeVisitingTransformer(this.iqFactory){

            public IQTree transformConstruction(IQTree tree, ConstructionNode rootNode, IQTree child) {
                final ImmutableSet avs = rootNode.getVariables();
                return this.iqFactory.createUnaryIQTree((UnaryOperatorNode)rootNode, child.acceptTransformer((IQTreeVisitingTransformer)new BasicGraphPatternTransformer(this.iqFactory){

                    @Override
                    protected ImmutableList<IQTree> transformBGP(ImmutableList<IntensionalDataNode> triplePatterns) {
                        ImmutableList bgp = (ImmutableList)triplePatterns.stream().map(IntensionalDataNode::getProjectionAtom).map(a -> a).collect(ImmutableCollectors.toList());
                        ImmutableList<QueryConnectedComponent> ccs = QueryConnectedComponent.getConnectedComponents((ImmutableCQ<RDFAtomPredicate>)new ImmutableCQ(avs, TreeWitnessRewriter.this.substitutionFactory.getSubstitution(), bgp));
                        ImmutableList<ImmutableCQ<RDFAtomPredicate>> ucq = ccs.stream().map(cc -> TreeWitnessRewriter.this.rewriteCC((QueryConnectedComponent)cc).stream()).collect(TreeWitnessRewriter.this.toUCQ());
                        ArrayList<ImmutableCQ<RDFAtomPredicate>> ucq2 = new ArrayList<ImmutableCQ<RDFAtomPredicate>>((Collection<ImmutableCQ<RDFAtomPredicate>>)ucq);
                        TreeWitnessRewriter.this.containmentCheckUnderLIDs.removeContainedQueries(ucq2);
                        return TreeWitnessRewriter.this.convertUCQ((ImmutableList<ImmutableList<IQTree>>)((ImmutableList)ucq2.stream().map(cq -> TreeWitnessRewriter.this.convertCQ((ImmutableCQ<RDFAtomPredicate>)cq)).collect(ImmutableCollectors.toList())));
                    }
                }));
            }
        });
        double endtime = System.currentTimeMillis();
        double tm = (endtime - startime) / 1000.0;
        this.time += tm;
        log.debug(String.format("Rewriting time: %.3f s (total %.3f s)", tm, this.time));
        log.debug("Final rewriting:\n{}", (Object)rewritingTree);
        IQ result = this.iqFactory.createIQ(query.getProjectionAtom(), rewritingTree);
        return super.rewrite(result);
    }

    private ImmutableList<IQTree> convertUCQ(ImmutableList<ImmutableList<IQTree>> ucq) {
        if (ucq.size() == 1) {
            return (ImmutableList)ucq.get(0);
        }
        ImmutableList joined = (ImmutableList)ucq.stream().map(this::join).collect(ImmutableCollectors.toList());
        ImmutableSet vars = (ImmutableSet)((IQTree)joined.get(0)).getVariables().stream().filter(v -> joined.stream().allMatch(j -> j.getVariables().contains(v))).collect(ImmutableCollectors.toSet());
        ImmutableList unionChildren = (ImmutableList)joined.stream().map(c -> this.iqTreeTools.createConstructionNodeTreeIfNontrivial(c, vars)).collect(ImmutableCollectors.toList());
        return ImmutableList.of((Object)this.iqFactory.createNaryIQTree((NaryOperatorNode)this.iqFactory.createUnionNode(vars), unionChildren));
    }

    class UCQBuilder {
        private List<ImmutableCQ<RDFAtomPredicate>> list;

        UCQBuilder(ImmutableCQ<RDFAtomPredicate> cq) {
            this.list = ImmutableList.of(cq);
        }

        UCQBuilder join(Stream<ImmutableCQ<RDFAtomPredicate>> cqs) {
            this.list = cqs.flatMap(cq2 -> this.list.stream().flatMap(cq1 -> this.joinCQs((ImmutableCQ<RDFAtomPredicate>)cq1, (ImmutableCQ<RDFAtomPredicate>)cq2).stream())).collect(Collectors.toList());
            block0: for (int i = 0; i < this.list.size(); ++i) {
                ImmutableCQ<RDFAtomPredicate> cq = this.list.get(i);
                for (int j = i + 1; j < this.list.size(); ++j) {
                    ImmutableCQ<RDFAtomPredicate> cqp = this.list.get(j);
                    if (cqp.getAtoms().containsAll((Collection)cq.getAtoms())) {
                        this.list.remove(j);
                        --j;
                        continue;
                    }
                    if (!cq.getAtoms().containsAll((Collection)cqp.getAtoms())) continue;
                    this.list.remove(i);
                    --i;
                    continue block0;
                }
            }
            return this;
        }

        private ImmutableSet<Set<VariableOrGroundTerm>> mergeOnePairOfClasses(ImmutableSet<Set<VariableOrGroundTerm>> equivalenceClasses) {
            for (Set s1 : equivalenceClasses) {
                for (Set s2 : equivalenceClasses) {
                    if (s1 == s2 || Sets.intersection((Set)s1, (Set)s2).isEmpty()) continue;
                    return Sets.union((Set)Sets.difference(equivalenceClasses, (Set)ImmutableSet.of((Object)s1, (Object)s2)), (Set)ImmutableSet.of((Object)Sets.union((Set)s1, (Set)s2))).immutableCopy();
                }
            }
            return null;
        }

        private Optional<ImmutableCQ<RDFAtomPredicate>> joinCQs(ImmutableCQ<RDFAtomPredicate> cq1, ImmutableCQ<RDFAtomPredicate> cq2) {
            ImmutableSet<Set<VariableOrGroundTerm>> newEquivalenceClasses;
            ImmutableSet<Set<VariableOrGroundTerm>> equivalenceClasses = (ImmutableSet<Set<VariableOrGroundTerm>>)Stream.of(cq1, cq2).map(ImmutableCQ::getSubstitution).map(Substitution::inverseMap).map(ImmutableMap::entrySet).flatMap(Collection::stream).map(e -> Sets.union((Set)ImmutableSet.of((Object)((VariableOrGroundTerm)e.getKey())), (Set)ImmutableSet.copyOf((Collection)((Collection)e.getValue())))).collect(ImmutableCollectors.toSet());
            while ((newEquivalenceClasses = this.mergeOnePairOfClasses(equivalenceClasses)) != null) {
                equivalenceClasses = newEquivalenceClasses;
            }
            ImmutableMap map = (ImmutableMap)equivalenceClasses.stream().map(c -> Maps.immutableEntry((Object)c, (Object)TreeWitnessRewriter.this.getEquivalenceClassRepresentative((Set<VariableOrGroundTerm>)c))).collect(ImmutableCollectors.toMap());
            if (map.containsValue(null)) {
                return Optional.empty();
            }
            Substitution<VariableOrGroundTerm> substitution = TreeWitnessRewriter.this.getSubstitution((ImmutableMap<Set<VariableOrGroundTerm>, VariableOrGroundTerm>)map);
            return Optional.of(TreeWitnessRewriter.createCQ((ImmutableSet<Variable>)Sets.union((Set)cq1.getAnswerVariables(), (Set)cq2.getAnswerVariables()).immutableCopy(), substitution, (ImmutableList<DataAtom<RDFAtomPredicate>>)((ImmutableList)Stream.concat(cq1.getAtoms().stream(), cq2.getAtoms().stream()).distinct().map(a -> TreeWitnessRewriter.this.atomFactory.getDataAtom((AtomPredicate)((RDFAtomPredicate)a.getPredicate()), TreeWitnessRewriter.this.substitutionFactory.onVariableOrGroundTerms().applyToTerms(substitution, a.getArguments()))).collect(ImmutableCollectors.toList()))));
        }

        ImmutableList<ImmutableCQ<RDFAtomPredicate>> build() {
            return ImmutableList.copyOf(this.list);
        }
    }
}

