/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.answering.reformulation.rewriting.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import com.google.inject.Provider;
import it.unibz.inf.ontop.answering.reformulation.rewriting.QueryRewriter;
import it.unibz.inf.ontop.answering.reformulation.rewriting.impl.BasicGraphPatternTransformer;
import it.unibz.inf.ontop.constraints.HomomorphismFactory;
import it.unibz.inf.ontop.constraints.LinearInclusionDependencies;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.iq.IQ;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.exception.EmptyQueryException;
import it.unibz.inf.ontop.iq.node.IntensionalDataNode;
import it.unibz.inf.ontop.iq.transform.IQTreeVisitingTransformer;
import it.unibz.inf.ontop.model.atom.AtomFactory;
import it.unibz.inf.ontop.model.atom.AtomPredicate;
import it.unibz.inf.ontop.model.atom.DataAtom;
import it.unibz.inf.ontop.model.atom.RDFAtomPredicate;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.VariableOrGroundTerm;
import it.unibz.inf.ontop.spec.ontology.ClassExpression;
import it.unibz.inf.ontop.spec.ontology.ClassifiedTBox;
import it.unibz.inf.ontop.spec.ontology.DataPropertyExpression;
import it.unibz.inf.ontop.spec.ontology.DataSomeValuesFrom;
import it.unibz.inf.ontop.spec.ontology.Equivalences;
import it.unibz.inf.ontop.spec.ontology.EquivalencesDAG;
import it.unibz.inf.ontop.spec.ontology.OClass;
import it.unibz.inf.ontop.spec.ontology.ObjectPropertyExpression;
import it.unibz.inf.ontop.spec.ontology.ObjectSomeValuesFrom;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Function;
import java.util.function.Predicate;

public class DummyRewriter
implements QueryRewriter {
    private LinearInclusionDependencies<RDFAtomPredicate> sigma;
    protected final IntermediateQueryFactory iqFactory;
    protected final AtomFactory atomFactory;
    protected final TermFactory termFactory;
    protected final HomomorphismFactory homomorphismFactory;

    @Inject
    protected DummyRewriter(IntermediateQueryFactory iqFactory, AtomFactory atomFactory, TermFactory termFactory, HomomorphismFactory homomorphismFactory) {
        this.iqFactory = iqFactory;
        this.atomFactory = atomFactory;
        this.termFactory = termFactory;
        this.homomorphismFactory = homomorphismFactory;
    }

    @Override
    public void setTBox(ClassifiedTBox reasoner) {
        LinearInclusionDependencies.Builder builder = this.homomorphismFactory.getFullLinearInclusionDependenciesBuilder();
        Variable x = this.termFactory.getVariable("x");
        Variable y = this.termFactory.getVariable("y");
        DummyRewriter.traverseDAG(reasoner.objectPropertiesDAG(), p -> !p.isInverse(), ope -> this.getAtom((VariableOrGroundTerm)x, (ObjectPropertyExpression)ope, (VariableOrGroundTerm)y), (LinearInclusionDependencies.Builder<RDFAtomPredicate>)builder);
        DummyRewriter.traverseDAG(reasoner.dataPropertiesDAG(), p -> true, dpe -> this.getAtom((VariableOrGroundTerm)x, (DataPropertyExpression)dpe, (VariableOrGroundTerm)y), (LinearInclusionDependencies.Builder<RDFAtomPredicate>)builder);
        DummyRewriter.traverseDAG(reasoner.classesDAG(), c -> c instanceof OClass, c -> this.getAtom((ClassExpression)c, (VariableOrGroundTerm)x, (Provider<VariableOrGroundTerm>)((Provider)() -> y)), (LinearInclusionDependencies.Builder<RDFAtomPredicate>)builder);
        this.sigma = builder.build();
    }

    protected LinearInclusionDependencies<RDFAtomPredicate> getSigma() {
        return this.sigma;
    }

    @Override
    public IQ rewrite(IQ query) throws EmptyQueryException {
        return this.iqFactory.createIQ(query.getProjectionAtom(), query.getTree().acceptTransformer((IQTreeVisitingTransformer)new BasicGraphPatternTransformer(this.iqFactory){

            @Override
            protected ImmutableList<IQTree> transformBGP(ImmutableList<IntensionalDataNode> bgp) {
                return DummyRewriter.this.removeRedundantAtoms(bgp);
            }
        }));
    }

    private ImmutableList<IQTree> removeRedundantAtoms(ImmutableList<IntensionalDataNode> bgp) {
        ArrayList<IntensionalDataNode> list = new ArrayList<IntensionalDataNode>((Collection<IntensionalDataNode>)bgp);
        for (int i = 0; i < list.size(); ++i) {
            DataAtom atom = list.get(i).getProjectionAtom();
            ImmutableSet derived = this.sigma.chaseAtom(atom);
            for (int j = 0; j < list.size(); ++j) {
                ImmutableSet variables;
                DataAtom curr = list.get(j).getProjectionAtom();
                if (j == i || !derived.contains((Object)curr) || !(variables = (ImmutableSet)list.stream().map(IntensionalDataNode::getProjectionAtom).filter(a -> a != curr).flatMap(a -> a.getVariables().stream()).collect(ImmutableCollectors.toSet())).containsAll((Collection)curr.getVariables())) continue;
                list.remove(j);
                if (--j >= i) continue;
                --i;
            }
        }
        return ImmutableList.copyOf(list);
    }

    private static <T> void traverseDAG(EquivalencesDAG<T> dag, Predicate<T> filter, Function<T, DataAtom<RDFAtomPredicate>> translate, LinearInclusionDependencies.Builder<RDFAtomPredicate> builder) {
        for (Equivalences node : dag) {
            for (Equivalences subNode : dag.getSub(node)) {
                for (Object sub : subNode) {
                    for (Object e : node) {
                        if (e == sub || !filter.test(e)) continue;
                        DataAtom<RDFAtomPredicate> head = translate.apply(e);
                        DataAtom<RDFAtomPredicate> body = translate.apply(sub);
                        builder.add(head, body);
                    }
                }
            }
        }
    }

    protected DataAtom<RDFAtomPredicate> getAtom(ClassExpression ce, VariableOrGroundTerm x, Provider<VariableOrGroundTerm> y) {
        if (ce instanceof OClass) {
            return this.getAtom(x, (OClass)ce);
        }
        if (ce instanceof ObjectSomeValuesFrom) {
            return this.getAtom(x, ((ObjectSomeValuesFrom)ce).getProperty(), (VariableOrGroundTerm)y.get());
        }
        return this.getAtom(x, ((DataSomeValuesFrom)ce).getProperty(), (VariableOrGroundTerm)y.get());
    }

    protected <T extends AtomPredicate> DataAtom<T> getAtom(VariableOrGroundTerm t1, ObjectPropertyExpression property, VariableOrGroundTerm t2) {
        return property.isInverse() ? this.atomFactory.getIntensionalTripleAtom(t2, property.getIRI(), t1) : this.atomFactory.getIntensionalTripleAtom(t1, property.getIRI(), t2);
    }

    protected <T extends AtomPredicate> DataAtom<T> getAtom(VariableOrGroundTerm t1, DataPropertyExpression property, VariableOrGroundTerm t2) {
        return this.atomFactory.getIntensionalTripleAtom(t1, property.getIRI(), t2);
    }

    protected <T extends AtomPredicate> DataAtom<T> getAtom(VariableOrGroundTerm t, OClass oc) {
        return this.atomFactory.getIntensionalTripleAtom(t, oc.getIRI());
    }
}

