/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.answering.reformulation.rewriting.impl;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Objects;
import java.util.stream.Collector;

public class DownwardSaturatedImmutableSet<T> {
    private final ImmutableSet<T> elements;
    private static final DownwardSaturatedImmutableSet BOTTOM = new DownwardSaturatedImmutableSet(ImmutableSet.of());
    private static final DownwardSaturatedImmutableSet TOP = new DownwardSaturatedImmutableSet(null);

    private DownwardSaturatedImmutableSet(ImmutableSet<T> elements) {
        this.elements = elements;
    }

    public boolean isTop() {
        return this.elements == null;
    }

    public boolean isBottom() {
        return this.elements != null && this.elements.isEmpty();
    }

    public boolean subsumes(T e) {
        return this.isTop() || this.elements.contains(e);
    }

    public static <T> DownwardSaturatedImmutableSet<T> intersectionOf(DownwardSaturatedImmutableSet<T> i1, DownwardSaturatedImmutableSet<T> i2) {
        if (i1.isTop()) {
            return i2;
        }
        if (i2.isTop()) {
            return i1;
        }
        Sets.SetView result = Sets.intersection(i1.elements, i2.elements);
        if (result.isEmpty()) {
            return DownwardSaturatedImmutableSet.bottom();
        }
        return new DownwardSaturatedImmutableSet<T>(result.immutableCopy());
    }

    public static <T> DownwardSaturatedImmutableSet<T> create(ImmutableSet<T> e) {
        return new DownwardSaturatedImmutableSet<T>(e);
    }

    public static <T> DownwardSaturatedImmutableSet<T> top() {
        return TOP;
    }

    public static <T> DownwardSaturatedImmutableSet<T> bottom() {
        return BOTTOM;
    }

    public static <T> Collector<DownwardSaturatedImmutableSet<T>, Accumulator<T>, DownwardSaturatedImmutableSet<T>> toIntersection() {
        return Collector.of(() -> new Accumulator(), Accumulator::intersectWith, Accumulator::intersectWith, Accumulator::result, Collector.Characteristics.UNORDERED);
    }

    public String toString() {
        return this.isTop() ? "TOP" : this.elements.toString();
    }

    public boolean equals(Object o) {
        if (o instanceof DownwardSaturatedImmutableSet) {
            DownwardSaturatedImmutableSet other = (DownwardSaturatedImmutableSet)o;
            return Objects.equals(this.elements, other.elements);
        }
        return false;
    }

    private static final class Accumulator<T> {
        private DownwardSaturatedImmutableSet<T> r = DownwardSaturatedImmutableSet.top();

        private Accumulator() {
        }

        Accumulator<T> intersectWith(DownwardSaturatedImmutableSet<T> i) {
            this.r = DownwardSaturatedImmutableSet.intersectionOf(this.r, i);
            return this;
        }

        Accumulator<T> intersectWith(Accumulator<T> a) {
            this.r = DownwardSaturatedImmutableSet.intersectionOf(this.r, a.r);
            return this;
        }

        DownwardSaturatedImmutableSet<T> result() {
            return this.r;
        }
    }
}

