/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.answering.reformulation.impl;

import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import it.unibz.inf.ontop.answering.logging.QueryLogger;
import it.unibz.inf.ontop.answering.reformulation.QueryCache;
import it.unibz.inf.ontop.answering.reformulation.QueryReformulator;
import it.unibz.inf.ontop.answering.reformulation.generation.NativeQueryGenerator;
import it.unibz.inf.ontop.answering.reformulation.rewriting.QueryRewriter;
import it.unibz.inf.ontop.evaluator.QueryContext;
import it.unibz.inf.ontop.exception.OntopInvalidInputQueryException;
import it.unibz.inf.ontop.exception.OntopInvalidKGQueryException;
import it.unibz.inf.ontop.exception.OntopReformulationException;
import it.unibz.inf.ontop.exception.OntopUnsupportedInputQueryException;
import it.unibz.inf.ontop.exception.OntopUnsupportedKGQueryException;
import it.unibz.inf.ontop.injection.TranslationFactory;
import it.unibz.inf.ontop.iq.IQ;
import it.unibz.inf.ontop.iq.exception.EmptyQueryException;
import it.unibz.inf.ontop.iq.optimizer.GeneralStructuralAndSemanticIQOptimizer;
import it.unibz.inf.ontop.iq.planner.QueryPlanner;
import it.unibz.inf.ontop.query.KGQuery;
import it.unibz.inf.ontop.query.KGQueryFactory;
import it.unibz.inf.ontop.query.translation.KGQueryTranslator;
import it.unibz.inf.ontop.query.unfolding.QueryUnfolder;
import it.unibz.inf.ontop.spec.OBDASpecification;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuestQueryProcessor
implements QueryReformulator {
    private static final Logger LOGGER = LoggerFactory.getLogger(QuestQueryProcessor.class);
    private final QueryRewriter rewriter;
    protected final NativeQueryGenerator datasourceQueryGenerator;
    private final QueryCache queryCache;
    private final QueryUnfolder queryUnfolder;
    private final KGQueryTranslator inputQueryTranslator;
    private final KGQueryFactory kgQueryFactory;
    private final GeneralStructuralAndSemanticIQOptimizer generalOptimizer;
    private final QueryPlanner queryPlanner;
    private final QueryLogger.Factory queryLoggerFactory;
    private final QueryContext.Factory queryContextFactory;

    @AssistedInject
    protected QuestQueryProcessor(@Assisted OBDASpecification obdaSpecification, QueryCache queryCache, QueryUnfolder.Factory queryUnfolderFactory, TranslationFactory translationFactory, QueryRewriter queryRewriter, KGQueryFactory kgQueryFactory, KGQueryTranslator inputQueryTranslator, GeneralStructuralAndSemanticIQOptimizer generalOptimizer, QueryPlanner queryPlanner, QueryLogger.Factory queryLoggerFactory, QueryContext.Factory queryContextFactory) {
        this.kgQueryFactory = kgQueryFactory;
        this.rewriter = queryRewriter;
        this.generalOptimizer = generalOptimizer;
        this.queryPlanner = queryPlanner;
        this.queryLoggerFactory = queryLoggerFactory;
        this.queryContextFactory = queryContextFactory;
        this.rewriter.setTBox(obdaSpecification.getSaturatedTBox());
        this.queryUnfolder = queryUnfolderFactory.create(obdaSpecification.getSaturatedMapping());
        this.datasourceQueryGenerator = translationFactory.create(obdaSpecification.getDBParameters());
        this.inputQueryTranslator = inputQueryTranslator;
        this.queryCache = queryCache;
        LOGGER.info("Ontop has completed the setup and it is ready for query answering!");
    }

    @Override
    public IQ reformulateIntoNativeQuery(KGQuery<?> inputQuery, QueryContext queryContext, QueryLogger queryLogger) throws OntopReformulationException {
        long beginning = System.currentTimeMillis();
        IQ cachedQuery = this.queryCache.get(inputQuery, queryContext);
        if (cachedQuery != null) {
            queryLogger.declareReformulationFinishedAndSerialize(cachedQuery, true);
            return cachedQuery;
        }
        try {
            LOGGER.debug("SPARQL query:\n{}\n", (Object)inputQuery.getOriginalString());
            IQ convertedIQ = inputQuery.translate(this.inputQueryTranslator);
            LOGGER.debug("Parsed query converted into IQ (after normalization):\n{}\n", (Object)convertedIQ);
            queryLogger.setSparqlIQ(convertedIQ);
            try {
                LOGGER.debug("Start the rewriting process...");
                IQ rewrittenIQ = this.rewriter.rewrite(convertedIQ);
                LOGGER.debug("Rewritten IQ:\n{}\n", (Object)rewrittenIQ);
                LOGGER.debug("Start the unfolding...");
                IQ unfoldedIQ = this.queryUnfolder.optimize(rewrittenIQ);
                if (unfoldedIQ.getTree().isDeclaredAsEmpty()) {
                    queryLogger.declareReformulationFinishedAndSerialize(unfoldedIQ, false);
                    LOGGER.debug("Reformulation time: {} ms\n", (Object)(System.currentTimeMillis() - beginning));
                    return unfoldedIQ;
                }
                LOGGER.debug("Unfolded query:\n{}\n", (Object)unfoldedIQ);
                IQ optimizedQuery = this.generalOptimizer.optimize(unfoldedIQ, queryContext);
                IQ plannedQuery = this.queryPlanner.optimize(optimizedQuery);
                LOGGER.debug("Planned query:\n{}\n", (Object)plannedQuery);
                queryLogger.setPlannedQuery(plannedQuery);
                IQ executableQuery = this.generateExecutableQuery(plannedQuery);
                this.queryCache.put(inputQuery, queryContext, executableQuery);
                queryLogger.declareReformulationFinishedAndSerialize(executableQuery, false);
                LOGGER.debug("Reformulation time: {} ms\n", (Object)(System.currentTimeMillis() - beginning));
                return executableQuery;
            }
            catch (OntopReformulationException e) {
                queryLogger.declareReformulationException(e);
                throw e;
            }
        }
        catch (OntopInvalidKGQueryException e) {
            OntopInvalidInputQueryException reformulationException = new OntopInvalidInputQueryException(e.getMessage());
            queryLogger.declareReformulationException(reformulationException);
            throw reformulationException;
        }
        catch (OntopUnsupportedKGQueryException e) {
            OntopUnsupportedInputQueryException reformulationException = new OntopUnsupportedInputQueryException(e.getMessage());
            queryLogger.declareReformulationException(reformulationException);
            throw reformulationException;
        }
        catch (Exception e) {
            LOGGER.warn("Unexpected exception: " + e.getMessage(), (Throwable)e);
            OntopReformulationException exception = new OntopReformulationException(e);
            queryLogger.declareReformulationException(exception);
            throw exception;
        }
    }

    protected IQ generateExecutableQuery(IQ iq) throws OntopReformulationException {
        LOGGER.debug("Producing the native query string...");
        IQ executableQuery = this.datasourceQueryGenerator.generateSourceQuery(iq);
        LOGGER.debug("Resulting native query:\n{}\n", (Object)executableQuery);
        return executableQuery;
    }

    @Override
    public String getRewritingRendering(KGQuery<?> query) throws OntopReformulationException {
        LOGGER.debug("SPARQL query:\n{}\n", (Object)query.getOriginalString());
        try {
            IQ convertedIQ = query.translate(this.inputQueryTranslator);
            LOGGER.debug("Parsed query converted into IQ:\n{}\n", (Object)convertedIQ);
            try {
                IQ rewrittenIQ = this.rewriter.rewrite(convertedIQ);
                return rewrittenIQ.toString();
            }
            catch (EmptyQueryException ignored) {
                return "EMPTY REWRITING";
            }
        }
        catch (OntopInvalidKGQueryException e) {
            throw new OntopInvalidInputQueryException(e.getMessage());
        }
        catch (OntopUnsupportedKGQueryException e) {
            throw new OntopUnsupportedInputQueryException(e.getMessage());
        }
    }

    @Override
    public KGQueryFactory getInputQueryFactory() {
        return this.kgQueryFactory;
    }

    @Override
    public QueryLogger.Factory getQueryLoggerFactory() {
        return this.queryLoggerFactory;
    }

    @Override
    public QueryContext.Factory getQueryContextFactory() {
        return this.queryContextFactory;
    }
}

