/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.answering.reformulation.impl;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import it.unibz.inf.ontop.answering.reformulation.QueryCache;
import it.unibz.inf.ontop.evaluator.QueryContext;
import it.unibz.inf.ontop.injection.OntopReformulationSettings;
import it.unibz.inf.ontop.iq.IQ;
import it.unibz.inf.ontop.query.KGQuery;
import java.util.Map;
import javax.annotation.Nullable;

public class GuiceBasedQueryCache
implements QueryCache {
    private final Cache<Map.Entry<KGQuery<?>, QueryContext>, IQ> cache;

    @Inject
    private GuiceBasedQueryCache(OntopReformulationSettings settings) {
        this.cache = CacheBuilder.newBuilder().maximumSize(settings.getQueryCacheMaxSize()).build();
    }

    @Override
    public @Nullable IQ get(KGQuery<?> inputQuery, QueryContext queryContext) {
        return (IQ)this.cache.getIfPresent((Object)Maps.immutableEntry(inputQuery, (Object)queryContext));
    }

    @Override
    public void put(KGQuery<?> inputQuery, QueryContext queryContext, IQ executableQuery) {
        this.cache.put((Object)Maps.immutableEntry(inputQuery, (Object)queryContext), (Object)executableQuery);
    }

    @Override
    public void clear() {
        this.cache.invalidateAll();
    }
}

