/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.security.utils;

import com.google.common.annotations.VisibleForTesting;
import com.ontotext.forest.core.Account;
import com.ontotext.forest.core.semantic.SemanticLocation;
import com.ontotext.forest.core.semantic.repository.SemanticRepository;
import com.ontotext.forest.security.AuthenticatedUser;
import com.ontotext.forest.security.PasswordEncoderFactory;
import com.ontotext.graphdb.security.Role;
import jakarta.inject.Named;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.util.CollectionUtils;

@Named(value="securityUtils")
public class SecurityUtils {
    public static final String AUTH_TOKEN_PARAM = "authToken";
    private static final Pattern REPOSITORY_WRITE = Pattern.compile("WRITE_REPO_(.*)");
    private static final Pattern REPOSITORY_READ = Pattern.compile("READ_REPO_(.*)");
    public static final List<String> STRING_ROLES = Arrays.stream(Role.values()).map(Enum::toString).collect(Collectors.toList());

    @VisibleForTesting
    public static void validateUser(Account user) {
        Matcher matcher;
        if (PasswordEncoderFactory.isPasswordEncoded(user.getPassword())) {
            throw new IllegalArgumentException("Cannot set encoded password");
        }
        Collection grantedAuthorities = user.getGrantedAuthorities();
        for (String writeRepositoryPermission : grantedAuthorities) {
            String repositoryID;
            matcher = REPOSITORY_WRITE.matcher(writeRepositoryPermission);
            if (!matcher.find() || grantedAuthorities.contains(Role.Repo.readForRepo((String)(repositoryID = matcher.group(1))))) continue;
            String message = repositoryID.endsWith(":GRAPHQL") ? "User cannot have GraphQL write only permissions for repository '" + repositoryID.substring(0, repositoryID.length() - ":GRAPHQL".length()) + "'!" : "User cannot have write only permissions for repository '" + repositoryID + "'!";
            throw new IllegalArgumentException(message);
        }
        for (String grantedAuthority : grantedAuthorities) {
            matcher = REPOSITORY_WRITE.matcher(grantedAuthority);
            Matcher read = REPOSITORY_READ.matcher(grantedAuthority);
            if (matcher.find() || read.find() || STRING_ROLES.contains(grantedAuthority) || grantedAuthority.startsWith("CUSTOM_")) continue;
            throw new IllegalArgumentException("Unknown authority. One of READ_REPO_xxx, WRITE_REPO_xxx, " + String.join((CharSequence)", ", STRING_ROLES) + " is required.");
        }
        if (!CollectionUtils.containsAny(STRING_ROLES, (Collection)grantedAuthorities)) {
            grantedAuthorities.add(Role.ROLE_USER.name());
            user.setGrantedAuthorities(grantedAuthorities);
        }
    }

    public static AuthenticatedUser buildUserFromAccount(Account account) {
        HashSet<SimpleGrantedAuthority> roles = new HashSet<SimpleGrantedAuthority>();
        if (account.getGrantedAuthorities() != null) {
            for (String authority : account.getGrantedAuthorities()) {
                roles.add(new SimpleGrantedAuthority(authority));
            }
        }
        return new AuthenticatedUser(account.getUsername(), account.getPassword(), roles, false, account.getAppSettings());
    }

    public static SemanticRepository getRepositoryWithSecurityCheck(String repoId, SemanticLocation location, boolean writeRequired) {
        SemanticRepository repository = location.getRepository(repoId);
        String compositeId = SecurityUtils.getRepoIdLocationCompositeKey(repository.getRepositoryID(), location.getLocation());
        SecurityUtils.checkRepositoryAccess(compositeId, writeRequired);
        return repository;
    }

    public static boolean hasRepositoryAccess(String repositoryId, boolean writeRequired) {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication != null) {
            UserDetails user = (UserDetails)authentication.getPrincipal();
            return Role.Repo.hasAccess((Collection)user.getAuthorities(), GrantedAuthority::getAuthority, (String)repositoryId, (boolean)writeRequired);
        }
        return true;
    }

    public static boolean hasGraphQLRepositoryAccess(String repositoryId, boolean writeRequired) {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication != null) {
            UserDetails user = (UserDetails)authentication.getPrincipal();
            return Role.Repo.hasGraphQLAccess((Collection)user.getAuthorities(), GrantedAuthority::getAuthority, (String)repositoryId, (boolean)writeRequired);
        }
        return true;
    }

    public static boolean hasGraphQLAdminAccess() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication != null) {
            UserDetails user = (UserDetails)authentication.getPrincipal();
            return user.getAuthorities().stream().map(GrantedAuthority::getAuthority).anyMatch(role -> Role.matches((String)role, (Role)Role.ROLE_REPO_MANAGER) || Role.matches((String)role, (Role)Role.ROLE_ADMIN));
        }
        return true;
    }

    public static void checkRepositoryAccess(String repositoryId, boolean writeRequired) {
        if (!SecurityUtils.hasRepositoryAccess(repositoryId, writeRequired)) {
            throw new AccessDeniedException("Access denied to repository: " + repositoryId);
        }
    }

    public static String getRepoIdLocationCompositeKey(String repositoryId, String locationHeader) {
        return StringUtils.isNotEmpty((CharSequence)locationHeader) ? repositoryId.concat("@").concat(locationHeader) : repositoryId;
    }
}

