/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.security.provider.openid;

import com.nimbusds.jose.JOSEObjectType;
import com.nimbusds.jose.proc.DefaultJOSEObjectTypeVerifier;
import com.nimbusds.jose.proc.JOSEObjectTypeVerifier;
import com.nimbusds.jwt.proc.ConfigurableJWTProcessor;
import com.ontotext.forest.core.AccountsService;
import com.ontotext.forest.security.UISecurityConfig;
import com.ontotext.forest.security.provider.openid.OAuthAccountsService;
import com.ontotext.forest.security.provider.openid.OAuthAuthenticationConverter;
import com.ontotext.forest.security.provider.openid.OpenIdAudienceValidator;
import com.ontotext.forest.security.provider.openid.OpenIdAuthenticationConverter;
import com.ontotext.forest.security.provider.openid.OpenIdConfig;
import com.ontotext.forest.security.provider.openid.OpenIdProviderConfigurationUtils;
import jakarta.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.convert.converter.Converter;
import org.springframework.http.HttpHeaders;
import org.springframework.http.RequestEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth2.core.DelegatingOAuth2TokenValidator;
import org.springframework.security.oauth2.core.OAuth2TokenValidator;
import org.springframework.security.oauth2.jose.jws.SignatureAlgorithm;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.security.oauth2.jwt.JwtIssuerValidator;
import org.springframework.security.oauth2.jwt.JwtTimestampValidator;
import org.springframework.security.oauth2.jwt.NimbusJwtDecoder;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationProvider;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestOperations;
import org.springframework.web.client.RestTemplate;

public class OpenIdAuthenticationProvider
implements AuthenticationProvider {
    private static final String ORACLE_IDENTITY_DOMAIN_HEADER = "X-OAuth-Identity-Domain-Name";
    @Autowired
    private UISecurityConfig uiSecurityConfig;
    @Autowired
    private AccountsService accountsService;
    private OpenIdConfig openIdConfig;
    private String usernameClaim;
    private JwtAuthenticationProvider jwtAuthenticationProvider;

    @PostConstruct
    public void init() {
        this.openIdConfig = OpenIdConfig.newInstance();
        this.usernameClaim = this.openIdConfig.getUsernameClaim();
        this.jwtAuthenticationProvider = new JwtAuthenticationProvider(this.createJwtDecoder(this.openIdConfig.getOpenIdProviderConfiguration()));
        boolean isOAuth = OAuthAccountsService.class.isAssignableFrom(this.accountsService.getImplementationClass());
        OpenIdAuthenticationConverter jwtAuthenticationConverter = isOAuth ? new OAuthAuthenticationConverter(this.accountsService, this.usernameClaim, OpenIdConfig.getPropertyOrThrow("graphdb.auth.oauth.roles_claim"), OpenIdConfig.getProperty("graphdb.auth.oauth.roles_prefix"), OpenIdConfig.getProperty("graphdb.auth.oauth.roles_suffix"), OpenIdConfig.getProperty("graphdb.auth.oauth.bare_custom_roles"), OpenIdConfig.getProperty("graphdb.auth.oauth.default_roles")) : new OpenIdAuthenticationConverter(this.usernameClaim, this.accountsService);
        this.jwtAuthenticationProvider.setJwtAuthenticationConverter((Converter)jwtAuthenticationConverter);
        this.uiSecurityConfig.setMethodSettings("openid", this.openIdConfig);
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        return this.jwtAuthenticationProvider.authenticate(authentication);
    }

    public boolean supports(Class<?> authentication) {
        return this.jwtAuthenticationProvider.supports(authentication);
    }

    public OpenIdConfig getOpenIdConfig() {
        return this.openIdConfig;
    }

    private JwtDecoder createJwtDecoder(Map<String, Object> configuration) {
        OpenIdProviderConfigurationUtils.validateIssuer(configuration, this.openIdConfig.getIssuer());
        Set allowedTypes = this.openIdConfig.getHeaderTokenTypes().stream().map(tt -> "null".equals(tt) ? null : new JOSEObjectType(tt)).collect(Collectors.toSet());
        DefaultJOSEObjectTypeVerifier customVerifier = new DefaultJOSEObjectTypeVerifier(allowedTypes);
        Consumer<ConfigurableJWTProcessor> jwtProcessorCustomizer = arg_0 -> OpenIdAuthenticationProvider.lambda$createJwtDecoder$1((JOSEObjectTypeVerifier)customVerifier, arg_0);
        NimbusJwtDecoder jwtDecoder = NimbusJwtDecoder.withJwkSetUri((String)configuration.get("jwks_uri").toString()).restOperations((RestOperations)new RestTemplate(){

            public <T> ResponseEntity<T> exchange(RequestEntity<?> requestEntity, Class<T> responseType) throws RestClientException {
                String oracleDomain = OpenIdAuthenticationProvider.this.openIdConfig.getOracleDomain();
                if (!oracleDomain.isEmpty()) {
                    HttpHeaders newHeaders = new HttpHeaders();
                    newHeaders.addAll((MultiValueMap)requestEntity.getHeaders());
                    newHeaders.set("Accept", "*/*");
                    newHeaders.add(OpenIdAuthenticationProvider.ORACLE_IDENTITY_DOMAIN_HEADER, oracleDomain);
                    requestEntity = new RequestEntity(requestEntity.getBody(), (MultiValueMap)newHeaders, requestEntity.getMethod(), requestEntity.getUrl(), requestEntity.getType());
                }
                return super.exchange(requestEntity, responseType);
            }
        }).jwsAlgorithm(SignatureAlgorithm.RS256).jwsAlgorithm(SignatureAlgorithm.RS384).jwsAlgorithm(SignatureAlgorithm.RS512).jwsAlgorithm(SignatureAlgorithm.ES256).jwsAlgorithm(SignatureAlgorithm.ES384).jwsAlgorithm(SignatureAlgorithm.ES512).jwsAlgorithm(SignatureAlgorithm.PS256).jwsAlgorithm(SignatureAlgorithm.PS384).jwsAlgorithm(SignatureAlgorithm.PS512).jwtProcessorCustomizer(jwtProcessorCustomizer).build();
        ArrayList<Object> validators = new ArrayList<Object>();
        validators.add(new JwtTimestampValidator());
        validators.add(new JwtIssuerValidator(this.openIdConfig.getTokenIssuer()));
        validators.add(new OpenIdAudienceValidator(this.openIdConfig.getTokenAudience(), this.openIdConfig.isAudienceRequired()));
        DelegatingOAuth2TokenValidator jwtValidator = new DelegatingOAuth2TokenValidator(validators);
        jwtDecoder.setJwtValidator((OAuth2TokenValidator)jwtValidator);
        return jwtDecoder;
    }

    private static /* synthetic */ void lambda$createJwtDecoder$1(JOSEObjectTypeVerifier customVerifier, ConfigurableJWTProcessor jwtProcessor) {
        jwtProcessor.setJWSTypeVerifier(customVerifier);
    }
}

