/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.security.provider.ldap;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.ontotext.forest.core.Account;
import com.ontotext.forest.core.AccountsService;
import com.ontotext.forest.core.util.RequestUtils;
import com.ontotext.forest.persistence.UsersConfig;
import com.ontotext.forest.security.AuthenticatedUser;
import com.ontotext.forest.security.AuthenticationMethod;
import com.ontotext.forest.security.SecurityConfig;
import com.ontotext.forest.security.provider.ldap.LdapAuthoritiesMapper;
import com.ontotext.forest.security.provider.ldap.LdapConfig;
import com.ontotext.forest.security.provider.ldap.RepositoryLdapAuthoritiesPopulator;
import com.ontotext.graphdb.Config;
import jakarta.annotation.Nullable;
import jakarta.annotation.PostConstruct;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.ldap.core.support.BaseLdapPathContextSource;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.mapping.GrantedAuthoritiesMapper;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.ldap.DefaultSpringSecurityContextSource;
import org.springframework.security.ldap.authentication.BindAuthenticator;
import org.springframework.security.ldap.authentication.LdapAuthenticationProvider;
import org.springframework.security.ldap.authentication.LdapAuthenticator;
import org.springframework.security.ldap.search.FilterBasedLdapUserSearch;
import org.springframework.security.ldap.search.LdapUserSearch;
import org.springframework.security.ldap.userdetails.LdapAuthoritiesPopulator;

public class LdapAccountsService
implements AccountsService,
AuthenticationProvider,
AuthenticationMethod.Basic,
AuthenticationMethod.GDB,
AuthenticationMethod.X509,
AuthenticationMethod.Kerberos,
AuthenticationMethod.OpenId {
    private static final String PERSISTENCE_PROPERTY = "ldap_users";
    static final Logger LOGGER = LoggerFactory.getLogger(LdapAccountsService.class);
    private static final String DEFAULT_ADMIN_USER = "";
    @Autowired
    private UsersConfig usersConfig;
    @Autowired
    private SecurityConfig securityConfig;
    private final Cache<String, AuthenticatedUser> userDetailsCache;
    private LdapAuthenticationProvider ldapAuthenticationProvider;
    private LdapUserSearch ldapUserSearch;
    private LdapAuthoritiesPopulator ldapAuthoritiesPopulator;
    private LdapAuthoritiesMapper ldapAuthoritiesMapper;
    private final boolean case_insensitive = Config.getPropertyAsBoolean((String)"graphdb.auth.database.case_insensitive", (boolean)false);

    public LdapAccountsService(UsersConfig usersConfig) {
        this.usersConfig = usersConfig;
        this.userDetailsCache = CacheBuilder.newBuilder().concurrencyLevel(4).maximumSize(100L).expireAfterWrite(10L, TimeUnit.MINUTES).build();
    }

    @PostConstruct
    public void initLdap() {
        DefaultSpringSecurityContextSource dsscs = new DefaultSpringSecurityContextSource(LdapConfig.getPropertyOrThrow("graphdb.auth.ldap.url"));
        dsscs.setUserDn(Config.getProperty((String)"graphdb.auth.ldap.bind.userDn", (String)DEFAULT_ADMIN_USER));
        dsscs.setPassword(Config.getProperty((String)"graphdb.auth.ldap.bind.userDn.password", (String)DEFAULT_ADMIN_USER));
        dsscs.afterPropertiesSet();
        RepositoryLdapAuthoritiesPopulator ldapAuthoritiesPopulator = new RepositoryLdapAuthoritiesPopulator((ContextSource)dsscs, Config.getProperty((String)"graphdb.auth.ldap.role.search.base", (String)DEFAULT_ADMIN_USER));
        this.ldapAuthoritiesPopulator = ldapAuthoritiesPopulator;
        FilterBasedLdapUserSearch filterLdapUserSearch = new FilterBasedLdapUserSearch(Config.getProperty((String)"graphdb.auth.ldap.user.search.base", (String)DEFAULT_ADMIN_USER), LdapConfig.getPropertyOrThrow("graphdb.auth.ldap.user.search.filter"), (BaseLdapPathContextSource)dsscs);
        filterLdapUserSearch.setSearchSubtree(Config.getPropertyAsBoolean((String)"graphdb.auth.ldap.user.search.subtree", (boolean)true));
        this.ldapUserSearch = filterLdapUserSearch;
        BindAuthenticator bindAuthenticator = new BindAuthenticator((BaseLdapPathContextSource)dsscs);
        bindAuthenticator.setUserSearch(this.ldapUserSearch);
        bindAuthenticator.afterPropertiesSet();
        this.ldapAuthoritiesMapper = new LdapAuthoritiesMapper(this.case_insensitive);
        if (this.securityConfig.isDirectPasswordAuthEnabled()) {
            this.ldapAuthenticationProvider = new LdapAuthenticationProvider((LdapAuthenticator)bindAuthenticator, (LdapAuthoritiesPopulator)ldapAuthoritiesPopulator);
            this.ldapAuthenticationProvider.setAuthoritiesMapper((GrantedAuthoritiesMapper)this.ldapAuthoritiesMapper);
        }
        if (this.getAccount(DEFAULT_ADMIN_USER) == null) {
            Account account = new Account();
            account.setUsername(DEFAULT_ADMIN_USER);
            account.setPassword(DEFAULT_ADMIN_USER);
            account.setAppSettings(this.getDefaultSettings());
            this.saveUser(account);
        }
    }

    private Map<String, Account> getUsers() {
        return this.usersConfig.getMap(PERSISTENCE_PROPERTY, Account.class);
    }

    private void saveUsers(Map<String, Account> users) {
        this.usersConfig.updateMapEntries(PERSISTENCE_PROPERTY, Account.class, users);
    }

    public void editUserAccount(Account user, boolean updatePassword) {
        Account userFromDB = this.getAccount(user.getUsername());
        if (userFromDB == null) {
            throw new UsernameNotFoundException("user not found");
        }
        userFromDB.setAppSettings(user.getAppSettings());
        this.saveUser(userFromDB);
    }

    @VisibleForTesting
    public synchronized void saveUser(Account userFromDB) {
        String username = this.case_insensitive ? userFromDB.getUsername().toLowerCase(Locale.ROOT) : userFromDB.getUsername();
        Map<String, Account> users = this.getUsers();
        users.put(username, userFromDB);
        this.saveUsers(users);
    }

    public void addNewUser(Account user) {
        throw new IllegalStateException("LDAP does not support adding users directly.");
    }

    public void delete(String username) {
        throw new IllegalStateException("LDAP does not support removing users directly.");
    }

    public Collection<Account> getAll() {
        return this.getUsers().values().stream().filter(a -> !a.getUsername().equals(DEFAULT_ADMIN_USER)).collect(Collectors.toList());
    }

    @Nullable
    public Account getAccount(String username) {
        return this.getUsers().get(this.case_insensitive ? username.toLowerCase(Locale.ROOT) : username);
    }

    public Account getDefaultAdminAccount() {
        return this.getAccount(DEFAULT_ADMIN_USER);
    }

    public boolean isLocal() {
        return false;
    }

    public AuthenticatedUser loadUserByUsername(String username, Collection<GrantedAuthority> authorities) {
        AuthenticatedUser userDetails;
        if (authorities != null) {
            throw new IllegalArgumentException("Overriding authorities not supported");
        }
        Account account = this.getAccount(username);
        if (account == null) {
            account = new Account();
            account.setUsername(username);
            account.setAppSettings(this.getDefaultSettings());
            this.saveUser(account);
        }
        if (RequestUtils.getAttribute((String)"graphdb-reauthorize") != null) {
            this.userDetailsCache.invalidate((Object)username);
        }
        if ((userDetails = (AuthenticatedUser)this.userDetailsCache.getIfPresent((Object)username)) == null) {
            DirContextOperations userData = this.ldapUserSearch.searchForUser(username);
            Collection<? extends GrantedAuthority> ldapAuthorities = this.ldapAuthoritiesMapper.mapAuthorities(this.ldapAuthoritiesPopulator.getGrantedAuthorities(userData, username));
            userDetails = new AuthenticatedUser(username, DEFAULT_ADMIN_USER, ldapAuthorities, true, account.getAppSettings());
            this.userDetailsCache.put((Object)username, (Object)userDetails);
        } else {
            userDetails.setAppSettings(account.getAppSettings());
        }
        return userDetails;
    }

    public String getImplementationName() {
        return "LDAP";
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        try {
            Authentication validatedAuthentication = this.ldapAuthenticationProvider.authenticate(authentication);
            return this.loadUserByUsername(validatedAuthentication.getName()).toAuthentication();
        }
        catch (AuthenticationException e) {
            LOGGER.warn("Unable to authenticate over LDAP: {}", (Object)e.getMessage());
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("LDAP authentication stack trace:", (Throwable)e);
            }
            throw e;
        }
    }

    public boolean supports(Class<?> authentication) {
        return this.ldapAuthenticationProvider.supports(authentication);
    }

    public AuthenticationProvider getAuthenticationProvider() {
        if (this.securityConfig.isDirectPasswordAuthEnabled()) {
            return this;
        }
        return null;
    }
}

