/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.security;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.ontotext.forest.core.AccountsService;
import com.ontotext.forest.security.SecurityConfig;
import com.ontotext.forest.security.rest.AccessBean;
import com.ontotext.forest.security.role.RoleToSpring;
import com.ontotext.graphdb.security.Role;
import jakarta.annotation.PostConstruct;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.stereotype.Service;

@Service
public class UISecurityConfig {
    @Autowired
    @JsonIgnore
    private SecurityConfig securityConfig;
    @Autowired
    @JsonIgnore
    private AccountsService accountsService;
    private AccessBean freeAccess;
    private AccessBean overrideAuth;
    private final Map<String, Object> methodSettings = new HashMap<String, Object>();

    @PostConstruct
    public void init() {
        this.freeAccess = new AccessBean(){

            @Override
            public boolean isEnabled() {
                return UISecurityConfig.this.securityConfig.isEnabledFreeAccess();
            }

            @Override
            public List<String> getAuthorities() {
                return UISecurityConfig.this.securityConfig.getFreeAccessAuthorities();
            }

            @Override
            public Map<String, Object> getAppSettings() {
                return UISecurityConfig.this.securityConfig.getFreeAccessSettings();
            }
        };
        this.overrideAuth = new AccessBean(){

            @Override
            public boolean isEnabled() {
                return UISecurityConfig.this.securityConfig.hasOverrideAuthority();
            }

            @Override
            public List<String> getAuthorities() {
                return RoleToSpring.expandGrantedAuthorities((Role)Role.valueOf((String)UISecurityConfig.this.securityConfig.getOverrideAuthority())).stream().map(GrantedAuthority::getAuthority).collect(Collectors.toList());
            }

            @Override
            public Map<String, Object> getAppSettings() {
                return UISecurityConfig.this.securityConfig.getOverrideAuthSettings();
            }
        };
    }

    @JsonProperty
    public boolean isEnabled() {
        return this.securityConfig.isEnabledSecurity();
    }

    @JsonProperty
    public boolean isPasswordLoginEnabled() {
        return this.securityConfig.isGDBAuthEnabled();
    }

    @JsonProperty
    public boolean hasExternalAuth() {
        return !this.accountsService.isLocal();
    }

    @JsonProperty
    public String getAuthImplementation() {
        return this.accountsService.getImplementationName();
    }

    @JsonProperty
    public AccessBean getFreeAccess() {
        return this.freeAccess;
    }

    @JsonProperty
    public AccessBean getOverrideAuth() {
        return this.overrideAuth;
    }

    @JsonProperty
    public boolean isOpenIdEnabled() {
        return this.securityConfig.isOpenIdAuthEnabled();
    }

    @JsonProperty
    public Map<String, Object> getMethodSettings() {
        return this.methodSettings;
    }

    public void setMethodSettings(String method, Object settings) {
        this.methodSettings.put(method, settings);
    }
}

