/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.security;

import java.util.Collection;
import org.springframework.security.access.AccessDecisionVoter;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.access.SecurityConfig;
import org.springframework.security.access.vote.RoleVoter;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.FilterInvocation;

public class LocalRequestVoter
implements AccessDecisionVoter<Object> {
    public static final String PREFIX = "LOCAL_IP_";
    private RoleVoter roleVoter = new RoleVoter();

    public int vote(Authentication authentication, Object object, Collection<ConfigAttribute> attributes) {
        int result = 0;
        for (ConfigAttribute attribute : attributes) {
            if (!this.supports(attribute) || !this.supports(object.getClass())) continue;
            FilterInvocation fi = (FilterInvocation)object;
            if (fi.getHttpRequest().getLocalAddr().equals(fi.getHttpRequest().getRemoteAddr())) {
                result = 1;
                continue;
            }
            result = this.roleVoter.vote(authentication, object, (Collection)SecurityConfig.createList((String[])new String[]{attribute.getAttribute().substring(PREFIX.length())}));
        }
        return result;
    }

    public boolean supports(ConfigAttribute attribute) {
        return attribute.getAttribute() != null && attribute.getAttribute().startsWith(PREFIX);
    }

    public boolean supports(Class<?> clazz) {
        return FilterInvocation.class.isAssignableFrom(clazz);
    }
}

