/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.plugin.externalsync.impl.embedding;

import com.ontotext.trree.plugin.externalsync.api.ConnectorServerException;
import dev.langchain4j.data.embedding.Embedding;
import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.model.embedding.EmbeddingModel;
import dev.langchain4j.model.output.Response;
import java.util.List;
import java.util.stream.Collectors;

public class VectorBuilder {
    private final EmbeddingModel embeddingModel;

    public VectorBuilder(EmbeddingModel embeddingModel) {
        this.embeddingModel = embeddingModel;
    }

    public List<Embedding> embeddingsFromTexts(List<String> texts) {
        try {
            Response embeddingResponse = this.embeddingModel.embedAll(texts.stream().map(TextSegment::from).collect(Collectors.toList()));
            return (List)embeddingResponse.content();
        }
        catch (Exception e) {
            throw new ConnectorServerException("Error creating vector from text", e);
        }
    }

    public Embedding embeddingFromText(String text) {
        try {
            Response embeddingResponse = this.embeddingModel.embed(text);
            return (Embedding)embeddingResponse.content();
        }
        catch (Exception e) {
            throw new ConnectorServerException("Error creating vector from text", e);
        }
    }

    public int embeddingModelDimension() {
        return this.embeddingModel.dimension();
    }

    public EmbeddingModel getEmbeddingModel() {
        return this.embeddingModel;
    }
}

