/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.graphql;

import com.ontotext.graphdb.Config;
import com.ontotext.licensecheck.GraphQlExtendedFeatures;
import com.ontotext.licensecheck.LicenseCheckUtil;
import com.ontotext.metamodel.storage.MalformedSomlException;
import com.ontotext.metamodel.storage.SomlNotFoundException;
import com.ontotext.metamodel.storage.SomlSchemaStorage;
import com.ontotext.metamodel.storage.UnreachableStoreException;
import com.ontotext.models.SomlSchema;
import com.ontotext.soaas.common.ErrorCode;
import com.ontotext.soaas.common.connection.EndpointProvider;
import com.ontotext.soaas.common.exceptions.BadRequestException;
import com.ontotext.soaas.common.exceptions.InvalidConfigurationException;
import com.ontotext.soaas.common.exceptions.ResourceNotFoundException;
import com.ontotext.sparql.SparqlConnectionFactory;
import com.ontotext.tasks.DataEndpointProvider;
import com.ontotext.tasks.GraphDbTaskProcessorFactory;
import com.ontotext.tasks.MonitoredTaskProcessorFactory;
import com.ontotext.tasks.TaskProcessorFactory;
import com.ontotext.tasks.processing.JobContext;
import com.ontotext.validator.data.InMemoryValidationManager;
import com.ontotext.validator.data.ValidationManager;
import com.ontotext.validator.data.ValidationService;
import com.ontotext.validator.data.steps.ValidationStepUtil;
import java.lang.invoke.MethodHandles;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidationManagerBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final SomlSchemaStorage schemaStorage;
    private final EndpointProvider dataEndpointConfig;
    private final SparqlConnectionFactory connectionFactory;
    boolean disableViolatingDataReporting;
    private int jobsPerValidation = 2;
    private int maxActiveValidations = 4;

    public ValidationManagerBuilder(SomlSchemaStorage schemaStorage, EndpointProvider dataEndpointConfig, SparqlConnectionFactory connectionFactory) {
        this.schemaStorage = schemaStorage;
        this.dataEndpointConfig = dataEndpointConfig;
        this.connectionFactory = connectionFactory;
    }

    public ValidationManager build() {
        LicenseCheckUtil.requireGraphQlExtendedLicense((GraphQlExtendedFeatures[])new GraphQlExtendedFeatures[0]);
        DataEndpointProvider dataEndpointProvider = DataEndpointProvider.create((EndpointProvider)this.dataEndpointConfig, (SparqlConnectionFactory)this.connectionFactory);
        InMemoryValidationManager validationManager = new InMemoryValidationManager(dataEndpointProvider);
        if (this.disableViolatingDataReporting) {
            validationManager.disableDataLoading();
        }
        validationManager.setSchemaLoader(this.buildSchemaLoader());
        new ValidationService((ValidationManager)validationManager, this.processorFactory(), ValidationManagerBuilder.getSchemaLoader(this.schemaStorage).andThen(schema -> new JobContext(schema.getId(), schema)));
        return validationManager;
    }

    @NotNull
    private Function<String, SomlSchema> buildSchemaLoader() {
        return schemaId -> {
            try {
                return (SomlSchema)this.schemaStorage.getParsed(schemaId).orElseThrow(() -> SomlNotFoundException.notFound((String)schemaId));
            }
            catch (SomlNotFoundException snfe) {
                throw new BadRequestException(snfe.getMessage(), ErrorCode.MISSING_SOML);
            }
            catch (UnreachableStoreException use) {
                throw new BadRequestException(use.getMessage(), ErrorCode.SOML_STORE_UNREACHABLE);
            }
            catch (MalformedSomlException mse) {
                throw new BadRequestException(mse.getMessage(), ErrorCode.MALFORMED_SOML);
            }
        };
    }

    private TaskProcessorFactory processorFactory() {
        GraphDbTaskProcessorFactory processorFactory = new GraphDbTaskProcessorFactory(this, this.dataEndpointConfig, this.connectionFactory, this.jobsPerValidation, this.maxActiveValidations){

            protected synchronized GraphDbTaskProcessorFactory.Mode getEndpointMode() {
                return GraphDbTaskProcessorFactory.Mode.CONCURRENT;
            }
        };
        return new MonitoredTaskProcessorFactory((TaskProcessorFactory)processorFactory, "DATA_VALIDATION");
    }

    @NotNull
    private static Function<String, SomlSchema> getSchemaLoader(SomlSchemaStorage schemaStorage) {
        return schemaId -> {
            try {
                return (SomlSchema)schemaStorage.getParsed(schemaId).orElseThrow(() -> ResourceNotFoundException.somlNotFound((String)schemaId));
            }
            catch (UnreachableStoreException ex) {
                throw new InvalidConfigurationException(ex.getMessage(), ErrorCode.SOML_STORE_UNREACHABLE);
            }
            catch (MalformedSomlException mse) {
                throw new InvalidConfigurationException(mse.getMessage(), ErrorCode.MALFORMED_SOML);
            }
        };
    }

    public boolean isDisableViolatingDataReporting() {
        return this.disableViolatingDataReporting;
    }

    public ValidationManagerBuilder setDisableViolatingDataReporting(boolean disableViolatingDataReporting) {
        this.disableViolatingDataReporting = disableViolatingDataReporting;
        return this;
    }

    public int getJobsPerValidation() {
        return this.jobsPerValidation;
    }

    public ValidationManagerBuilder setJobsPerValidation(int jobsPerValidation) {
        this.jobsPerValidation = jobsPerValidation;
        return this;
    }

    public int getMaxActiveValidations() {
        return this.maxActiveValidations;
    }

    public ValidationManagerBuilder setMaxActiveValidations(int maxActiveValidations) {
        this.maxActiveValidations = maxActiveValidations;
        return this;
    }

    static {
        if (Config.getPropertyAsBoolean((String)"soml.validation.enableLogging", (boolean)false)) {
            ValidationStepUtil.enableValidationQueryLogging();
        } else {
            ValidationStepUtil.disableValidationQueryLogging();
        }
    }
}

