/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.graphql;

import com.ontotext.graphdb.graphql.GraphDB2SemanticObjectsConfigurationResolver;
import com.ontotext.graphdb.graphql.GraphQLConfigurations;
import com.ontotext.graphdb.graphql.GraphQLModelNotifiable;
import com.ontotext.graphdb.graphql.GraphQLModelNotificationManager;
import com.ontotext.graphdb.graphql.GraphQLSecurityConfigurer;
import com.ontotext.graphdb.graphql.ValidationManagerBuilder;
import com.ontotext.metamodel.SomlSchemaIdManager;
import com.ontotext.metamodel.storage.SchemaEntity;
import com.ontotext.metamodel.storage.ServiceIdentity;
import com.ontotext.metamodel.storage.SomlIdManager;
import com.ontotext.metamodel.storage.SomlSchemaIdStorage;
import com.ontotext.metamodel.storage.SomlSchemaStorage;
import com.ontotext.metamodel.storage.SomlStoreException;
import com.ontotext.metamodel.storage.UnreachableStoreException;
import com.ontotext.metamodel.storage.rdf4j.Constants;
import com.ontotext.metamodel.storage.rdf4j.Rdf4jSomlSchemaIdStorage;
import com.ontotext.models.ErrorMessages;
import com.ontotext.models.InvalidSchemaException;
import com.ontotext.models.SomlConversionException;
import com.ontotext.models.SomlSchema;
import com.ontotext.models.SomlSchemaParser;
import com.ontotext.rbac.SecurityContext;
import com.ontotext.soaas.common.Resettable;
import com.ontotext.soaas.common.connection.EndpointProvider;
import com.ontotext.soaas.common.logging.Loggers;
import com.ontotext.soaas.configuration.GraphqlOptions;
import com.ontotext.soaas.configuration.StorageConfiguration;
import com.ontotext.soaas.plugin.PluginsManager;
import com.ontotext.soaas.query.GraphQlSchemaConverterBuilder;
import com.ontotext.soaas.query.service.QueryService;
import com.ontotext.soaas.query.service.QueryServiceBuilder;
import com.ontotext.soaas.query.service.QueryServiceManager;
import com.ontotext.soaas.query.validators.QueryTotalObjectsCountValidator;
import com.ontotext.sparql.SparqlConnectionFactory;
import com.ontotext.sparql.SparqlEndpoint;
import com.ontotext.sparql.SparqlEndpointConfiguration;
import com.ontotext.validator.data.ValidationManager;
import java.io.File;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class GraphQLServiceManager {
    private final File baseDir;
    private final SparqlConnectionFactory readonlyConnectionFactory;
    private final SparqlConnectionFactory writeableConnectionFactory;
    private GraphQLSecurityConfigurer securityConfigurer = new GraphQLSecurityConfigurer();
    private final Map<String, NotifiableQueryServiceManager> managers = new ConcurrentHashMap<String, NotifiableQueryServiceManager>();
    private final Map<String, ValidationManager> validationManagers = new ConcurrentHashMap<String, ValidationManager>();
    private static final GraphQLConfigurations graphQLConfigurations = new GraphQLConfigurations();
    private final GraphqlOptions baseGraphqlConfig = this.newGraphqlOptions();
    private final Map<String, GraphqlOptions> graphqlOptions = new ConcurrentHashMap<String, GraphqlOptions>();
    private SecurityContext securityContext;
    private GraphQLModelNotificationManager notificationManager;

    public GraphQLServiceManager(File baseDir, SparqlConnectionFactory readonlyConnectionFactory, SparqlConnectionFactory writeableConnectionFactory) {
        this.baseDir = baseDir;
        this.readonlyConnectionFactory = readonlyConnectionFactory;
        this.writeableConnectionFactory = writeableConnectionFactory;
    }

    public QueryService getQueryService(String repository, String schema) {
        NotifiableQueryServiceManager serviceManager = this.getQueryServiceManager(repository);
        if (schema == null) {
            return serviceManager.getDefaultService();
        }
        return serviceManager.getService(schema);
    }

    public SomlSchemaStorage getStorage(String repository) {
        return this.getQueryServiceManager(repository).getSchemaStorage();
    }

    public SomlSchemaIdManager getDefaultSchemaStorage(String repository) {
        return this.getQueryServiceManager(repository).getSchemaIdManager();
    }

    public ValidationManager getValidationManager(String repository) {
        return this.validationManagers.computeIfAbsent(repository, this::createValidationManager);
    }

    private ValidationManager createValidationManager(String repository) {
        NotifiableQueryServiceManager serviceManager = this.getQueryServiceManager(repository);
        return new ValidationManagerBuilder(this.getStorage(repository), (EndpointProvider)serviceManager.getSparqlEndpointConfiguration(), this.getReadonlyConnectionFactory()).build();
    }

    public void setDefaultSchema(String repository, String schemaId) {
        try {
            this.getQueryServiceManager(repository).setDefaultSchema(schemaId);
        }
        catch (SomlStoreException use) {
            throw new RuntimeException(use);
        }
    }

    public boolean isEndpointActive(@NotNull String repository, @NotNull String schemaId) {
        return this.getQueryServiceManager(repository).isActive(schemaId);
    }

    public Optional<String> getDefaultSchemaId(String repository) {
        return this.getQueryServiceManager(repository).getDefaultSchemaId();
    }

    @NotNull
    private NotifiableQueryServiceManager getQueryServiceManager(String repository) {
        return this.managers.computeIfAbsent(repository, this::createQueryServiceManager);
    }

    private NotifiableQueryServiceManager createQueryServiceManager(String repository) {
        GraphqlOptions options = this.getGraphqlOptions(repository);
        NotifiableQueryServiceManager manager = new NotifiableQueryServiceManager(repository, options.getEndpointsCacheConfig());
        manager.setServiceBuilder(this.queryServiceBuilder(repository));
        manager.setGraphqlOptions(options);
        manager.setSparqlEndpointConfiguration(this.getEndpointConfiguration(repository));
        manager.setConnectionFactory(this.getWriteableConnectionFactory());
        manager.setSchemaIdManager(new SomlSchemaIdManager(this.createIdStorage(repository, manager)));
        if (this.notificationManager != null) {
            this.notificationManager.register(repository, manager);
        }
        manager.isActive("dummy");
        return manager;
    }

    private GraphqlOptions getGraphqlOptions(String repository) {
        return this.graphqlOptions.computeIfAbsent(repository, this.createGraphqlOptions());
    }

    private Function<String, GraphqlOptions> createGraphqlOptions() {
        return repo -> {
            GraphqlOptions options = this.newGraphqlOptions();
            Path graphqlPath = this.baseDir.toPath().resolve(Path.of("graphql", new String[0]));
            if (StringUtils.isNotEmpty((CharSequence)repo)) {
                graphqlPath = graphqlPath.resolve(Path.of(repo, new String[0]));
            }
            Path cacheLocation = graphqlPath.resolve(Path.of("introspection-cache", new String[0]));
            options.getIntrospectionQueryCache().setLocation(cacheLocation.toAbsolutePath().toString());
            if (this.baseGraphqlConfig.getValidation().getOptions() != null) {
                options.getValidation().setOptions(new HashMap());
                options.getValidation().getOptions().putAll(this.baseGraphqlConfig.getValidation().getOptions());
            }
            if (this.baseGraphqlConfig.getMutation().getGeneration().getOptions() != null) {
                options.getMutation().getGeneration().setOptions(new HashMap());
                options.getMutation().getGeneration().getOptions().putAll(this.baseGraphqlConfig.getMutation().getGeneration().getOptions());
            }
            return options;
        };
    }

    @NotNull
    private GraphqlOptions newGraphqlOptions() {
        GraphqlOptions options = graphQLConfigurations.getGraphqlOptions();
        options.getValidation().disable(QueryTotalObjectsCountValidator.class);
        return options;
    }

    public GraphQLServiceManager setModelNotifierManager(GraphQLModelNotificationManager notifierManager) {
        this.notificationManager = notifierManager;
        return this;
    }

    @NotNull
    private SomlSchemaIdStorage createIdStorage(String repository, QueryServiceManager manager) {
        return new Rdf4jSomlSchemaIdStorage((EndpointProvider)this.getEndpointConfiguration(repository), this.getWriteableConnectionFactory(), this.getServiceIdentity(), manager.getNotificationService());
    }

    private ServiceIdentity getServiceIdentity() {
        return new ServiceIdentity(this){

            public String getName() {
                return "defaultSchemaId";
            }

            public String getAddress() {
                return null;
            }

            public String getServiceAddress() {
                return null;
            }
        };
    }

    protected QueryServiceBuilder queryServiceBuilder(String repository) {
        StorageConfiguration storageConfiguration = new StorageConfiguration();
        Path graphqlPath = this.baseDir.toPath().resolve(Path.of("graphql", new String[0]));
        storageConfiguration.setLocation(graphqlPath.toAbsolutePath().toString());
        SparqlEndpointConfiguration sparqlEndpointConfiguration = this.getEndpointConfiguration(repository);
        return new QueryServiceBuilder().setReadOnlyConnectionFactory(this.getReadonlyConnectionFactory()).setWriteableConnectionFactory(this.getWriteableConnectionFactory()).setSparqlEndpointConfiguration(sparqlEndpointConfiguration).setStorageConfiguration(storageConfiguration).setGraphQlOptions(this.getGraphqlOptions(repository)).setSecurityContext(this.securityContext).setSparqlOptimizations(graphQLConfigurations.getSparqlOptimizations()).setOperationBuilderOptions(graphQLConfigurations.getOperationBuilderOptions());
    }

    @NotNull
    private SparqlEndpointConfiguration getEndpointConfiguration(String repository) {
        SparqlEndpointConfiguration endpointConfigurations = new SparqlEndpointConfiguration(this){

            public SparqlEndpoint getEndpoint() {
                return graphQLConfigurations.setEndpointConfigurations(super.getEndpoint());
            }
        };
        endpointConfigurations.setRepository(repository);
        endpointConfigurations.setAddress("not-used");
        return endpointConfigurations;
    }

    public SparqlConnectionFactory getReadonlyConnectionFactory() {
        return this.readonlyConnectionFactory;
    }

    public SparqlConnectionFactory getWriteableConnectionFactory() {
        return this.writeableConnectionFactory;
    }

    public void validateSchemaBinding(SomlSchema somlSchema) {
        GraphQlSchemaConverterBuilder graphqlSchemaConverter = new GraphQlSchemaConverterBuilder(this.baseGraphqlConfig);
        try {
            graphqlSchemaConverter.buildWithoutRbac().convert(somlSchema);
        }
        catch (SomlConversionException ex) {
            throw new InvalidSchemaException(ErrorMessages.get((String)"soml.validation.binding", (Object[])new Object[]{ex.getMessage()}), (Throwable)ex);
        }
    }

    public Set<String> getActiveServices(String repository) {
        return this.getQueryServiceManager(repository).activeServices();
    }

    public void setGraphQLSecurityConfigurer(GraphQLSecurityConfigurer securityConfigurer) {
        this.securityConfigurer = securityConfigurer;
    }

    public void configureSecurity(boolean securityEnabled) {
        GraphDB2SemanticObjectsConfigurationResolver.INSTANCE.setSecurityEnabled(securityEnabled);
        boolean allowPartialUpdates = graphQLConfigurations.allowPartialUpdates();
        this.securityConfigurer.configureSecurity(securityEnabled, allowPartialUpdates, this.baseGraphqlConfig);
        this.graphqlOptions.values().forEach(options -> this.securityConfigurer.configureSecurity(securityEnabled, allowPartialUpdates, (GraphqlOptions)options));
    }

    public void setSecurityContext(SecurityContext securityContext) {
        this.securityContext = securityContext;
    }

    public void unloadRepository(String repository) {
        QueryServiceManager manager = this.managers.remove(repository);
        if (manager != null) {
            try {
                manager.shutdown();
            }
            finally {
                if (this.notificationManager != null) {
                    this.notificationManager.unregister(repository, (GraphQLModelNotifiable)manager);
                }
            }
        }
        this.graphqlOptions.remove(repository);
    }

    public void clusterChanged(boolean created) {
        Loggers.graphqlLogger().info("Cluster {}, restarting all GraphQL services", (Object)(created ? "created" : "deleted"));
        this.shutdown();
    }

    public void shutdown() {
        this.validationManagers.values().forEach(ValidationManager::shutdown);
        this.validationManagers.clear();
        this.managers.values().forEach(NotifiableQueryServiceManager::shutdown);
        this.managers.clear();
        Resettable.resetIfApplicable((Object)this.readonlyConnectionFactory);
        Resettable.resetIfApplicable((Object)this.writeableConnectionFactory);
    }

    public boolean unregisterSchema(String repository, String schemaId) {
        return this.getQueryServiceManager(repository).unloadService(schemaId);
    }

    static {
        PluginsManager.addConfig((Object)graphQLConfigurations.getGraphQlQueryOptions());
    }

    private static class NotifiableQueryServiceManager
    extends QueryServiceManager
    implements GraphQLModelNotifiable {
        private final Set<String> inactiveEndpoints = ConcurrentHashMap.newKeySet();
        private boolean initialized = false;

        public NotifiableQueryServiceManager(String repository, String cacheConfig) {
            super(repository, cacheConfig);
        }

        public boolean isActive(String endpoint) {
            if (!this.initialized) {
                try {
                    this.getSchemaStorage().getAll().stream().filter(entry -> entry.getErrors() > 0 || Boolean.FALSE.equals(entry.getActive())).map(SchemaEntity::getSchemaId).forEach(this.inactiveEndpoints::add);
                    this.initialized = true;
                }
                catch (UnreachableStoreException e) {
                    throw new RuntimeException(e);
                }
            }
            return !this.inactiveEndpoints.contains(endpoint);
        }

        @Override
        public void clearAll() {
            Loggers.graphqlLogger().info("[{}] Cleared all data", (Object)this.getRepository());
            this.unloadAll();
            this.getSchemaIdManager().reset();
            this.inactiveEndpoints.clear();
        }

        @Override
        public void clear(String context) {
            if (Constants.STORE_CONTEXT.stringValue().equals(context)) {
                Loggers.graphqlLogger().info("[{}] Cleared graph: {}", (Object)this.getRepository(), (Object)context);
                this.clearAll();
            }
            if (Constants.ID_STORE_CONTEXT.stringValue().equals(context)) {
                this.defaultSchemaRemoved();
            }
        }

        @Override
        public void defaultSchemaRemoved() {
            Loggers.graphqlLogger().info("[{}] Default schema removed", (Object)this.getRepository());
            this.getSchemaIdManager().reset();
        }

        @Override
        public void schemaChanged(String schemaBody, boolean isAddition) {
            if (schemaBody != null) {
                String id = SomlSchemaParser.getId((String)schemaBody);
                Loggers.graphqlLogger().info("[{}] schema with ID {} {}", new Object[]{this.getRepository(), id, isAddition ? "added" : "removed"});
                if (id != null) {
                    this.unloadService(SomlIdManager.INSTANCE.somlIdToReference(id));
                }
            } else {
                Loggers.graphqlLogger().info("[{}] Removed schema without body", (Object)this.getRepository());
            }
        }

        @Override
        public void endpointActivated(String endpoint) {
            this.inactiveEndpoints.remove(endpoint);
        }

        @Override
        public void endpointDeactivated(String endpoint) {
            this.inactiveEndpoints.add(endpoint);
        }

        @Override
        public void shutdown() {
            try {
                super.shutdown();
            }
            finally {
                Resettable.resetIfApplicable((Object)this.getNotificationService());
            }
        }
    }
}

