/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.graphql;

import com.ontotext.graphdb.Config;
import com.ontotext.models.extensions.ConfigurationResolver;
import com.ontotext.soaas.common.logging.Loggers;
import java.lang.invoke.TypeDescriptor;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.IntFunction;
import javax.annotation.Nonnull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class GraphDB2SemanticObjectsConfigurationResolver
implements ConfigurationResolver {
    public static final GraphDB2SemanticObjectsConfigurationResolver INSTANCE = new GraphDB2SemanticObjectsConfigurationResolver();
    private static final Logger LOGGER = Loggers.systemLogger();
    public static final Map<String, String> PROPERTY_MAP;
    private volatile Boolean securityEnabled = Boolean.FALSE;

    public <T> T resolve(@Nonnull String propertyKey, @Nonnull Class<T> type, T defaultValue) {
        if (type.isPrimitive() || type.isArray() && type.getComponentType().isPrimitive()) {
            throw new IllegalArgumentException("Cannot convert property " + propertyKey + " of primitive type " + type.getName());
        }
        if ("security.enabled".equals(propertyKey)) {
            return type.cast(this.securityEnabled);
        }
        String value = GraphDB2SemanticObjectsConfigurationResolver.readConfigValue(propertyKey);
        if (value == null) {
            return defaultValue;
        }
        if (type.isArray()) {
            String[] values = value.split("\\s*[,;]\\s*");
            TypeDescriptor.OfField componentType = type.componentType();
            if (String.class.equals((Object)componentType)) {
                return type.cast(values);
            }
            return type.cast(Arrays.stream(values).map(arg_0 -> GraphDB2SemanticObjectsConfigurationResolver.lambda$resolve$0(propertyKey, (Class)componentType, arg_0)).filter(Objects::nonNull).toArray(GraphDB2SemanticObjectsConfigurationResolver.newArray(type.getComponentType())));
        }
        return GraphDB2SemanticObjectsConfigurationResolver.convertToType(propertyKey, value, type, defaultValue);
    }

    @Nullable
    private static String readConfigValue(String propertyKey) {
        String value = Config.getProperty((String)propertyKey);
        if (value == null) {
            String legacyPropertyKey = PROPERTY_MAP.get(propertyKey);
            if (legacyPropertyKey != null) {
                value = Config.getProperty((String)legacyPropertyKey);
                if (value != null) {
                    GraphDB2SemanticObjectsConfigurationResolver.logDeprecatedProperty(propertyKey, legacyPropertyKey);
                }
            } else if (GraphDB2SemanticObjectsConfigurationResolver.isFederatedServiceConfig(propertyKey)) {
                String newKey = propertyKey.replace("sparql.federated.services.", "graphdb.graphql.sparql.federated.services.");
                return Config.getProperty((String)newKey);
            }
        }
        return value;
    }

    private static void logDeprecatedProperty(String propertyKey, String legacyPropertyKey) {
        LOGGER.warn("Using deprecated property '{}' instead of new property '{}'. The legacy property may stop working in a future version.", (Object)legacyPropertyKey, (Object)propertyKey);
    }

    private static boolean isFederatedServiceConfig(String propertyKey) {
        return propertyKey.startsWith("sparql.federated.services.");
    }

    private static <A> IntFunction<A[]> newArray(Class<?> componentType) {
        return length -> (Object[])Array.newInstance(componentType, length);
    }

    private static <T> T convertToType(String property, String value, Class<T> type, T defaultValue) {
        if (type.isEnum()) {
            return type.cast(GraphDB2SemanticObjectsConfigurationResolver.parseEnumValue(value, type));
        }
        return switch (type.getSimpleName()) {
            case "String" -> type.cast(value);
            case "Integer" -> type.cast(GraphDB2SemanticObjectsConfigurationResolver.parseOrDefault(value, Integer::valueOf, defaultValue));
            case "Long" -> type.cast(GraphDB2SemanticObjectsConfigurationResolver.parseOrDefault(value, Long::valueOf, defaultValue));
            case "Float" -> type.cast(GraphDB2SemanticObjectsConfigurationResolver.parseOrDefault(value, Float::valueOf, defaultValue));
            case "Double" -> type.cast(GraphDB2SemanticObjectsConfigurationResolver.parseOrDefault(value, Double::valueOf, defaultValue));
            case "Short" -> type.cast(GraphDB2SemanticObjectsConfigurationResolver.parseOrDefault(value, Short::valueOf, defaultValue));
            case "Byte" -> type.cast(GraphDB2SemanticObjectsConfigurationResolver.parseOrDefault(value, Byte::valueOf, defaultValue));
            case "Boolean" -> type.cast(GraphDB2SemanticObjectsConfigurationResolver.parseOrDefault(value, Boolean::valueOf, defaultValue));
            default -> {
                LOGGER.warn("The configuration type {} for configuration {} is not supported", type, (Object)property);
                yield defaultValue;
            }
        };
    }

    private static <T> T parseOrDefault(String value, Function<String, T> parser, T defaultValue) {
        try {
            return parser.apply(value);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    private static <E extends Enum<E>> E parseEnumValue(String value, Class<E> enumClass) {
        return Enum.valueOf(enumClass, value);
    }

    public void setSecurityEnabled(Boolean securityEnabled) {
        this.securityEnabled = securityEnabled;
    }

    private static /* synthetic */ Object lambda$resolve$0(String propertyKey, Class componentType, String item) {
        return GraphDB2SemanticObjectsConfigurationResolver.convertToType(propertyKey, item, componentType, null);
    }

    static {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("graphdb.graphql.preload.forceUpdate", "soml.preload.forceUpdate");
        map.put("graphdb.soml.validation.jobsPerValidation", "soml.validation.jobsPerValidation");
        map.put("graphdb.soml.validation.disableViolatingDataReporting", "soml.validation.disableViolatingDataReporting");
        map.put("graphdb.soml.validation.maxActiveValidations", "soml.validation.maxActiveValidations");
        map.put("graphdb.soml.validation.cache.enabled", "soml.validation.cache.enabled");
        map.put("graphdb.soml.validation.cache.timeoutSeconds", "soml.validation.cache.timeoutInSeconds");
        map.put("graphdb.graphql.query.optimizations.optionalToUnion", "sparql.optimizations.optionalToUnion");
        map.put("graphdb.graphql.query.optimizations.filterExistsToSelectDistinct", "sparql.optimizations.filterExistsToSelectDistinct");
        map.put("graphdb.graphql.query.optimizations.disableUnionToLateralOptimization", "sparql.optimizations.disableUnionToLateralOptimization");
        map.put("graphdb.graphql.query.optimizations.mutation.mode", "sparql.optimizations.mutationMode");
        map.put("graphdb.graphql.query.optimizations.soTypeOptimizationThreshold", "sparql.optimizations.soTypeOptimizationThreshold");
        map.put("graphdb.graphql.query.optimizations.inThreshold", "sparql.optimizations.inThreshold");
        map.put("graphdb.graphql.query.optimizations.disableSinglePropertiesOptimization", "sparql.optimizations.disableSinglePropertiesOptimization");
        map.put("graphdb.graphql.query.optimizations.singleSoTypeOptimizationEnabled", "sparql.optimizations.singleSoTypeOptimizationEnabled");
        map.put("graphdb.graphql.query.maxTupleResults", "sparql.endpoint.maxTupleResults");
        map.put("graphdb.graphql.query.cartesianProductCheck", "sparql.endpoint.cartesianProductCheck");
        map.put("graphdb.graphql.query.enableStatistics", "sparql.endpoint.enableStatistics");
        map.put("graphdb.graphql.query.statisticsRefreshIntervalInHours", "sparql.endpoint.statisticsRefreshIntervalInHours");
        map.put("graphdb.graphql.enableOutputValidations", "graphql.enableOutputValidations");
        map.put("graphdb.graphql.enableReducedSchema", "graphql.enableReducedSchema");
        map.put("graphdb.graphql.introspectionQueryCache.enabled", "graphql.introspectionQueryCache.enabled");
        map.put("graphdb.graphql.introspectionQueryCache.config", "graphql.introspectionQueryCache.config");
        map.put("graphdb.graphql.mutation.generation.enabled", "graphql.mutation.generation.enabled");
        map.put("graphdb.graphql.mutation.nestedCreate", "graphql.mutation.nestedCreate");
        map.put("graphdb.graphql.mutation.validation.failureMode", "graphql.validation.validationFailureMode");
        map.put("graphdb.graphql.mutation.validation.asyncEnabled", "graphql.validation.asyncValidationEnabled");
        map.put("graphdb.graphql.mutation.validation.maxConcurrentPerRequest", "graphql.validation.maxConcurrentValidationsPerRequest");
        map.put("graphdb.graphql.mutation.validation.asyncTimeoutSeconds", "graphql.validation.asyncValidationTimeoutSeconds");
        map.put("graphdb.graphql.mutation.forceMultiRepositorySequentialRequests", "graphql.mutation.forceMultiRepositorySequentialRequests");
        map.put("graphdb.graphql.query.depthLimit", "graphql.query.depthLimit");
        map.put("graphdb.graphql.query.maxObjectsReturned", "graphql.query.maxObjectsReturned");
        map.put("graphdb.graphql.response.json.nullArrays", "graphql.response.json.nullArrays");
        map.put("graphdb.graphql.response.compactErrorMessages", "graphql.response.compactErrorMessages");
        map.put("graphdb.graphql.management.metrics.export.statsd.enabled", "management.metrics.export.statsd.enabled");
        map.put("graphdb.graphql.endpointsCacheConfig", "graphql.endpointsCacheConfig");
        map.put("graphdb.graphql.mutation.allowPartialUpdates", "security.allowPartialUpdates");
        map.put("graphdb.graphql.search.maxNestingLevel", "search.maxNestingLevel");
        map.put("graphdb.graphql.forceMultiRepositorySequentialRequests", "graphql.forceMultiRepositorySequentialRequests");
        PROPERTY_MAP = Collections.unmodifiableMap(map);
    }
}

