/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.graphql;

import com.ontotext.platform.owl2soml.Classes;
import com.ontotext.platform.owl2soml.Config;
import com.ontotext.platform.owl2soml.DataAccess;
import com.ontotext.platform.owl2soml.GraphQlSchema;
import com.ontotext.platform.owl2soml.GraphQlSchemaShape;
import com.ontotext.platform.owl2soml.Message;
import com.ontotext.platform.owl2soml.Namespaces;
import com.ontotext.platform.owl2soml.Ontology;
import com.ontotext.platform.owl2soml.OwlRestrictionsInfo;
import com.ontotext.platform.owl2soml.PrefixNamespaceResponse;
import com.ontotext.platform.owl2soml.Properties;
import com.ontotext.platform.owl2soml.PropertyInverseInfo;
import com.ontotext.platform.owl2soml.Role;
import com.ontotext.platform.owl2soml.persistent.OntologyReference;
import com.ontotext.platform.owl2soml.persistent.ResourceOntologyReference;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.Pair;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Namespace;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.jetbrains.annotations.Nullable;

public class GdbDataAccessProxy
implements DataAccess {
    private final DataAccess delegate;
    private final Set<String> loadedOntologies = new HashSet<String>();

    public GdbDataAccessProxy(DataAccess delegate) {
        this.delegate = delegate;
    }

    public DataAccess initialize(Namespaces namespaces, List<Message> list) {
        this.delegate.initialize(namespaces, list);
        return this;
    }

    public void configureWith(Ontology ontology) {
        String identifier = null;
        if (ontology instanceof OntologyReference) {
            OntologyReference ref = (OntologyReference)ontology;
            identifier = Objects.requireNonNull(ref.getOntologyId()).stringValue();
        }
        if (ontology instanceof ResourceOntologyReference) {
            ResourceOntologyReference reference = (ResourceOntologyReference)ontology;
            identifier = reference.getResourceName();
        }
        if (identifier != null) {
            if (this.loadedOntologies.contains(identifier)) {
                this.delegate.readOntologyMetadata(ontology);
                return;
            }
            this.loadedOntologies.add(identifier);
        }
        this.delegate.configureWith(ontology);
    }

    public void close() {
    }

    public void doClose() {
        this.delegate.close();
    }

    public void readOntologyMetadata(Ontology ontology) {
        this.delegate.readOntologyMetadata(ontology);
    }

    public Map<String, Object> readOntologyMetadata(IRI iri) {
        return this.delegate.readOntologyMetadata(iri);
    }

    public void loadConfigurations() {
        this.delegate.loadConfigurations();
    }

    public void loadModelConfigurations(Ontology ontology) {
        this.delegate.loadModelConfigurations(ontology);
    }

    public Optional<Pair<Value, Value>> extractIriAndPrefixFromVann(IRI iri, IRI iri1) {
        return this.delegate.extractIriAndPrefixFromVann(iri, iri1);
    }

    public Config getConfig() {
        return this.delegate.getConfig();
    }

    public Set<IRI> findAlternativeConfigurationsOf(@Nullable IRI iri, Set<IRI> set) {
        return this.delegate.findAlternativeConfigurationsOf(iri, set);
    }

    public boolean isConfigurationEnabled(@Nullable IRI iri, IRI iri1) {
        return this.delegate.isConfigurationEnabled(iri, iri1);
    }

    public Optional<Value> getConfiguration(@Nullable IRI iri, IRI iri1) {
        return this.delegate.getConfiguration(iri, iri1);
    }

    public Set<IRI> getCustomDataTypes() {
        return this.delegate.getCustomDataTypes();
    }

    public Optional<String> getGraphQlName(IRI iri) {
        return this.delegate.getGraphQlName(iri);
    }

    public List<IRI> getPublicReferencedOntologies(IRI iri) {
        return this.delegate.getPublicReferencedOntologies(iri);
    }

    public List<IRI> getImportedOntologies(Set<IRI> set) {
        return this.delegate.getImportedOntologies(set);
    }

    public Stream<Namespace> getNamespaces(Ontology ontology) {
        return this.delegate.getNamespaces(ontology);
    }

    public void loadGraphQlModel(IRI iri, Ontology ontology) {
        this.delegate.loadGraphQlModel(iri, ontology);
    }

    public Set<IRI> findAllExplicitClasses(GraphQlSchema graphQlSchema, Ontology ontology) {
        return this.delegate.findAllExplicitClasses(graphQlSchema, ontology);
    }

    public boolean isDeactivated(Resource resource) {
        return this.delegate.isDeactivated(resource);
    }

    public Set<IRI> getDeactivatedShapes() {
        return this.delegate.getDeactivatedShapes();
    }

    public Stream<IRI> findReferencedShaclNodes(Set<IRI> set) {
        return this.delegate.findReferencedShaclNodes(set);
    }

    public Stream<IRI> findReferencedShaclTypes(Set<IRI> set) {
        return this.delegate.findReferencedShaclTypes(set);
    }

    public void readClassMetadata(Classes.Class aClass, Ontology ontology) {
        this.delegate.readClassMetadata(aClass, ontology);
    }

    public void readAnonymousClassMetadata(Classes.AnonymousClass anonymousClass, Ontology ontology) {
        this.delegate.readAnonymousClassMetadata(anonymousClass, ontology);
    }

    public Optional<Boolean> isInterfaceType(Resource resource) {
        return this.delegate.isInterfaceType(resource);
    }

    public Optional<String> getLabel(Resource resource) {
        return this.delegate.getLabel(resource);
    }

    public Optional<String> getDescription(Resource resource) {
        return this.delegate.getDescription(resource);
    }

    public String gqlTypeName(Resource resource) {
        return this.delegate.gqlTypeName(resource);
    }

    public String gqlPropertyName(Resource resource) {
        return this.delegate.gqlPropertyName(resource);
    }

    public Optional<IRI> getInverseOf(Resource resource) {
        return this.delegate.getInverseOf(resource);
    }

    public List<PropertyInverseInfo> getPropertyInverseInfos(Resource resource) {
        return this.delegate.getPropertyInverseInfos(resource);
    }

    public Set<Resource> findAllExplicitProperties() {
        return this.delegate.findAllExplicitProperties();
    }

    public Map<String, Map<String, Role>> findRbacRoles(IRI iri) {
        return this.delegate.findRbacRoles(iri);
    }

    public void readPropertyName(Properties.Property property) {
        this.delegate.readPropertyName(property);
    }

    public void readPropertyMetadata(Properties.Property property, Ontology ontology) {
        this.delegate.readPropertyMetadata(property, ontology);
    }

    public void readShaclPropertyMetadata(Properties.Property property, Resource resource, Ontology ontology) {
        this.delegate.readShaclPropertyMetadata(property, resource, ontology);
    }

    public boolean isDataProperty(Resource resource) {
        return this.delegate.isDataProperty(resource);
    }

    public boolean isObjectProperty(Resource resource) {
        return this.delegate.isObjectProperty(resource);
    }

    public List<Value> findRangeClasses(Resource resource) {
        return this.delegate.findRangeClasses(resource);
    }

    public List<Value> findDomainClasses(Resource resource, Ontology ontology) {
        return this.delegate.findDomainClasses(resource, ontology);
    }

    public Stream<IRI> resolveShaclPropertyDomain(Resource resource, Ontology ontology) {
        return this.delegate.resolveShaclPropertyDomain(resource, ontology);
    }

    public List<OwlRestrictionsInfo> getOwlRestrictions(IRI iri) {
        return this.delegate.getOwlRestrictions(iri);
    }

    public Map<IRI, Set<IRI>> getTargetClassToShapes(Collection<IRI> collection) {
        return this.delegate.getTargetClassToShapes(collection);
    }

    public Optional<Value> extractIriAndPrefixFromSwc(IRI iri, IRI iri1) {
        return this.delegate.extractIriAndPrefixFromSwc(iri, iri1);
    }

    public Optional<String> extractBaseIri(IRI ontology, IRI graphqlModelId, IRI storeContext) {
        return this.delegate.extractBaseIri(ontology, graphqlModelId, storeContext);
    }

    public Optional<Pair<String, String>> getDefaultPrefix(IRI iri, IRI iri1, IRI iri2) {
        return this.delegate.getDefaultPrefix(iri, iri1, iri2);
    }

    public List<Pair<String, String>> getDeclaredPrefixes(List<IRI> list, IRI iri) {
        return this.delegate.getDeclaredPrefixes(list, iri);
    }

    public Optional<IRI> getDefinedBy(IRI iri, IRI iri1) {
        return this.delegate.getDefinedBy(iri, iri1);
    }

    public Collection<GraphQlSchemaShape> getGraphQlSchemaShapes() {
        return this.delegate.getGraphQlSchemaShapes();
    }

    public List<PrefixNamespaceResponse> getPossiblePrefixes(String repoId) {
        return this.delegate.getPossiblePrefixes(repoId);
    }

    public boolean isContext(IRI iri) {
        return this.delegate.isContext(iri);
    }

    public boolean isOntology(IRI iri) {
        return this.delegate.isOntology(iri);
    }

    public Optional<Value> readOntologyId(IRI graphqlModel) {
        return this.delegate.readOntologyId(graphqlModel);
    }
}

