/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.graphql;

import com.ontotext.models.Rbac;
import com.ontotext.models.SomlSchema;
import com.ontotext.models.extensions.Order;
import com.ontotext.rbac.models.extensions.SchemaRoleSupplier;
import java.util.Collections;
import java.util.List;

@Order(value=69)
public class AddAdminRbacRole
extends SchemaRoleSupplier {
    public static final String ADMIN_ROLE_NAME = "GraphQL_Admin";

    public boolean canHandle(SomlSchema somlSchema) {
        return !"/soml/soml-rbac".equals(somlSchema.getId());
    }

    protected String role(Rbac rbac) {
        return rbac.getContainedIn().getConfig().getAdminRole().orElse(ADMIN_ROLE_NAME);
    }

    protected String roleDescription() {
        return "Admin role, which grants read, write and delete access in a GraphQL endpoint.";
    }

    protected List<String> allowedActions() {
        return Collections.singletonList("*/*/*");
    }
}

