/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.cloud.google;

import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpResponse;
import com.ontotext.graphdb.cloud.ChunkDownload;
import com.ontotext.graphdb.cloud.PipedStreamsManager;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public class GoogleChunkDownload
extends ChunkDownload {
    private final long start;
    private final long end;
    private final String downloadURL;
    private final HttpRequestFactory requestFactory;

    public GoogleChunkDownload(PipedStreamsManager manager, String downloadURL, AtomicInteger lastChunk, int chunkNumber, long start, long end, AtomicReference<Throwable> downloadError, HttpRequestFactory requestFactory, AtomicBoolean closed, int chunksToDownload) {
        super(manager, lastChunk, chunkNumber, downloadError, closed, chunksToDownload);
        this.start = start;
        this.end = end;
        this.downloadURL = downloadURL;
        this.requestFactory = requestFactory;
    }

    @Override
    protected byte[] downloadChunk() throws IOException {
        HttpRequest request = this.requestFactory.buildGetRequest(new GenericUrl(this.downloadURL));
        HttpHeaders headers = request.getHeaders();
        String rangeHeader = "bytes=" + this.start + "-" + this.end;
        headers.set("Range", (Object)rangeHeader);
        request.setHeaders(headers);
        HttpResponse response = request.execute();
        if (!response.isSuccessStatusCode()) {
            throw new IOException(response.getStatusMessage());
        }
        try (InputStream content = response.getContent();){
            byte[] byArray = content.readAllBytes();
            return byArray;
        }
    }
}

