/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.cloud.google;

import com.google.api.client.json.GenericJson;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.JsonObjectParser;
import com.google.api.client.json.gson.GsonFactory;
import com.google.auth.oauth2.GoogleCredentials;
import com.ontotext.graphdb.cloud.google.GoogleUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import org.apache.commons.fileupload2.core.FileItemInput;
import org.jetbrains.annotations.NotNull;
import software.amazon.awssdk.utils.StringUtils;

public class GoogleBucketOptions {
    @NotNull
    private final String bucketName;
    private final String fileKey;
    private String authenticationFile;

    public GoogleBucketOptions(URI bucketUrl, FileItemInput authFile) {
        this.bucketName = bucketUrl.getHost();
        if (StringUtils.isEmpty((CharSequence)this.bucketName)) {
            throw new IllegalArgumentException("Bucket name cannot be empty");
        }
        String filePath = bucketUrl.getPath();
        if (StringUtils.isEmpty((CharSequence)filePath) || filePath.equals("/")) {
            throw new IllegalArgumentException("Backup name cannot be empty");
        }
        this.fileKey = bucketUrl.getPath().substring(1);
        this.authenticationFile = null;
        if (authFile != null && authFile.getName() != null) {
            try {
                GsonFactory jsonFactory = GsonFactory.getDefaultInstance();
                JsonObjectParser parser = new JsonObjectParser((JsonFactory)jsonFactory);
                this.authenticationFile = ((GenericJson)parser.parseAndClose(authFile.getInputStream(), StandardCharsets.UTF_8, GenericJson.class)).toString();
            }
            catch (IOException | IllegalArgumentException e) {
                throw new IllegalArgumentException("Failed to parse authentication file", e);
            }
        }
    }

    public GoogleBucketOptions(@NotNull String bucketName, String fileKey, String authenticationFile) {
        this.bucketName = bucketName;
        this.fileKey = fileKey;
        if (StringUtils.isNotBlank((CharSequence)authenticationFile)) {
            this.authenticationFile = authenticationFile;
        }
    }

    @NotNull
    public String getBucketName() {
        return this.bucketName;
    }

    public String getFileKey() {
        return this.fileKey;
    }

    public String getAuthenticationFile() {
        return this.authenticationFile;
    }

    public GoogleCredentials acquireGoogleCredentials() throws IOException {
        GoogleCredentials credentials;
        if (this.authenticationFile != null) {
            try (ByteArrayInputStream inputStream = new ByteArrayInputStream(this.authenticationFile.getBytes(StandardCharsets.UTF_8));){
                credentials = GoogleCredentials.fromStream((InputStream)inputStream);
            }
            catch (NullPointerException e) {
                credentials = GoogleCredentials.getApplicationDefault();
            }
        } else {
            credentials = GoogleCredentials.getApplicationDefault();
        }
        return this.credentialsFixScope(credentials);
    }

    private GoogleCredentials credentialsFixScope(GoogleCredentials credentials) {
        if (credentials.createScopedRequired()) {
            return credentials.createScoped(new String[]{GoogleUtils.getCredentialsScope()});
        }
        return credentials;
    }
}

