/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.cloud.azure;

import com.azure.core.credential.TokenCredential;
import com.azure.core.exception.AzureException;
import com.azure.identity.CredentialUnavailableException;
import com.azure.storage.blob.BlobAsyncClient;
import com.azure.storage.blob.BlobClient;
import com.azure.storage.blob.BlobContainerAsyncClient;
import com.azure.storage.blob.BlobContainerClient;
import com.azure.storage.blob.BlobContainerClientBuilder;
import com.azure.storage.blob.models.BlobErrorCode;
import com.azure.storage.blob.models.BlobStorageException;
import com.azure.storage.blob.models.ParallelTransferOptions;
import com.azure.storage.blob.specialized.BlobOutputStream;
import com.ontotext.graphdb.Config;
import com.ontotext.graphdb.cloud.azure.AzureBlobOptions;
import com.ontotext.license.LicenseRegistry;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AzureBlobUtils {
    private static final Logger logger = LoggerFactory.getLogger(AzureBlobUtils.class);
    private static final int AZURE_BLOB_PART_SIZE = 0x2000000;
    public static final String GRAPHDB_AZURE_MIN_PART_SIZE = "graphdb.azure.min.part.size";
    public static final int AZURE_BLOB_ESTIMATED_PART_COUNT = 50000;
    public static final long AZURE_BLOB_FILE_LIMIT = 209715200000000L;
    public static final String GRAPHDB_AZURE_BACKUP_MAX_CONCURRENT_UPLOADS = "graphdb.azure.blob.backup.max.concurrent.uploads";
    public static final String GRAPHDB_AZURE_CLOUD_CUSTOM_ENDPOINT = "graphdb.azure.cloud.custom.endpoint";
    public static final int DEFAULT_MAX_CONCURRENT_UPLOADS = 6;
    private static final int CONFIGURED_CONCURRENT_UPLOADS;

    private AzureBlobUtils() {
    }

    public static BlobContainerAsyncClient getAzureAsyncContainerClient(AzureBlobOptions azureBlobOptions) {
        BlobContainerClientBuilder clientBuilder = AzureBlobUtils.clientBuilder(azureBlobOptions);
        return clientBuilder.buildAsyncClient();
    }

    public static BlobContainerClient getAzureContainerClient(AzureBlobOptions azureBlobOptions) {
        BlobContainerClientBuilder clientBuilder = AzureBlobUtils.clientBuilder(azureBlobOptions);
        return clientBuilder.buildClient();
    }

    private static BlobContainerClientBuilder clientBuilder(AzureBlobOptions azureBlobOptions) {
        BlobContainerClientBuilder clientBuilder = new BlobContainerClientBuilder().containerName(azureBlobOptions.getContainerName()).endpoint(AzureBlobUtils.getEndpoint(azureBlobOptions));
        if (!StringUtils.isEmpty((CharSequence)azureBlobOptions.getAccessKey())) {
            clientBuilder.credential(azureBlobOptions.getSharedKeyCredentials());
        } else if (!StringUtils.isEmpty((CharSequence)azureBlobOptions.getSasSignature())) {
            clientBuilder.credential(azureBlobOptions.getAzureSasCredential());
        } else {
            clientBuilder.credential((TokenCredential)azureBlobOptions.getIdentityCredentials());
        }
        return clientBuilder;
    }

    public static BlobOutputStream getBlobOutputSteam(AzureBlobOptions azureBlobOptions, long partSize) {
        BlobContainerAsyncClient azureContainer = AzureBlobUtils.getAzureAsyncContainerClient(azureBlobOptions);
        BlobAsyncClient azureAsync = azureContainer.getBlobAsyncClient(azureBlobOptions.getFileKey());
        ParallelTransferOptions azureTransferOptions = new ParallelTransferOptions().setBlockSizeLong(Long.valueOf(partSize)).setMaxConcurrency(Integer.valueOf(AzureBlobUtils.getConfiguredConcurrentUploads()));
        return BlobOutputStream.blockBlobOutputStream((BlobAsyncClient)azureAsync, (ParallelTransferOptions)azureTransferOptions, null, null, null, null);
    }

    public static void transformAzureException(AzureException ex) throws IOException {
        if (ex instanceof BlobStorageException) {
            AzureBlobUtils.transformBlobStorageException((BlobStorageException)ex);
        }
        if (ex instanceof CredentialUnavailableException) {
            AzureBlobUtils.transformCredentialUnavailableException((CredentialUnavailableException)ex);
        }
        throw new IOException((Throwable)ex);
    }

    private static void transformBlobStorageException(BlobStorageException ex) throws IOException {
        BlobErrorCode errorCode;
        BlobErrorCode blobErrorCode = errorCode = ex.getErrorCode() == null ? BlobErrorCode.fromString((String)"Unknown") : ex.getErrorCode();
        if (errorCode.equals((Object)BlobErrorCode.AUTHENTICATION_FAILED)) {
            throw new IOException("Access Denied (Service: Azure, Status Code: " + ex.getStatusCode() + ")", (Throwable)ex);
        }
        throw new IOException(String.valueOf(errorCode) + " (Service: Azure, Status Code: " + ex.getStatusCode() + ")", (Throwable)ex);
    }

    private static void transformCredentialUnavailableException(CredentialUnavailableException ex) throws IOException {
        throw new IOException("Unable to load credentials from the Default Azure Credential chain", (Throwable)ex);
    }

    public static int getMinimumPartSize() {
        return Config.getPropertyAsInt((String)GRAPHDB_AZURE_MIN_PART_SIZE, (int)0x2000000);
    }

    public static int getConfiguredConcurrentUploads() {
        return LicenseRegistry.getInstance().getLicensedCores(CONFIGURED_CONCURRENT_UPLOADS);
    }

    private static String getEndpoint(AzureBlobOptions azureBlobOptions) {
        String customEndpoint = Config.getProperty((String)GRAPHDB_AZURE_CLOUD_CUSTOM_ENDPOINT);
        if (StringUtils.isBlank((CharSequence)customEndpoint)) {
            return "https://" + azureBlobOptions.getStorageAccount() + ".blob.core.windows.net/" + azureBlobOptions.getContainerName();
        }
        logger.debug("Custom azure endpoint in use:");
        return customEndpoint + "/" + azureBlobOptions.getStorageAccount() + "/" + azureBlobOptions.getContainerName();
    }

    public static long getAzureFileSize(BlobClient blobClient) throws IOException {
        long fileSize = blobClient.getProperties().getBlobSize();
        if (fileSize > 0L) {
            return fileSize;
        }
        throw new IOException("Invalid backup file size: " + fileSize);
    }

    static {
        int uploads = Config.getPropertyAsInt((String)GRAPHDB_AZURE_BACKUP_MAX_CONCURRENT_UPLOADS, (int)6);
        if (uploads > 16 || uploads < 1) {
            logger.warn("Invalid upload count for Azure upload \"{}\", switching to default value {}", (Object)uploads, (Object)6);
            uploads = 6;
        }
        logger.debug("Azure will use maximum {} concurrent uploads", (Object)uploads);
        CONFIGURED_CONCURRENT_UPLOADS = uploads;
    }
}

