/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.cloud.aws;

import com.ontotext.graphdb.Config;
import com.ontotext.graphdb.cloud.CloudMultipartUploader;
import com.ontotext.graphdb.cloud.aws.S3BucketOptions;
import com.ontotext.graphdb.cloud.aws.S3PartUpload;
import com.ontotext.graphdb.cloud.aws.S3Utils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.model.AbortMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.ChecksumAlgorithm;
import software.amazon.awssdk.services.s3.model.CompleteMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.CompletedMultipartUpload;
import software.amazon.awssdk.services.s3.model.CompletedPart;
import software.amazon.awssdk.services.s3.model.CreateMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.CreateMultipartUploadResponse;
import software.amazon.awssdk.services.s3.model.ListPartsRequest;
import software.amazon.awssdk.services.s3.model.ListPartsResponse;

public class S3MultipartUploader
implements CloudMultipartUploader {
    private static final Logger logger = LoggerFactory.getLogger(S3MultipartUploader.class);
    private final S3AsyncClient s3;
    private final String bucket;
    private final String fileKey;
    private String uploadId;
    private final List<CompletedPart> parts = Collections.synchronizedList(new ArrayList());
    private int partNumber;
    private final ExecutorService executorService;
    private final AtomicReference<IOException> uploadException = new AtomicReference();
    private final boolean enableChecksumCheck;

    public S3MultipartUploader(S3AsyncClient s3AsyncClient, S3BucketOptions bucketOptions) {
        this.s3 = s3AsyncClient;
        this.bucket = bucketOptions.getBucketName();
        this.fileKey = bucketOptions.getFileKey();
        this.partNumber = 0;
        this.enableChecksumCheck = !Config.getPropertyAsBoolean((String)"graphdb.s3.backup.disable.checksum", (boolean)false);
        int threadPoolSize = S3Utils.getMaxHttpClientConcurrency();
        this.executorService = new ThreadPoolExecutor(threadPoolSize, threadPoolSize, 0L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(threadPoolSize), new ThreadPoolExecutor.CallerRunsPolicy());
    }

    @Override
    public S3MultipartUploader start() throws IOException {
        this.validateCleanStart();
        try {
            CreateMultipartUploadRequest.Builder multipartUploadRequestBuilder = CreateMultipartUploadRequest.builder().bucket(this.bucket).key(this.fileKey);
            if (this.enableChecksumCheck) {
                multipartUploadRequestBuilder.checksumAlgorithm(ChecksumAlgorithm.SHA1);
            }
            CreateMultipartUploadResponse multipartUpload = (CreateMultipartUploadResponse)this.s3.createMultipartUpload((CreateMultipartUploadRequest)multipartUploadRequestBuilder.build()).get(30L, TimeUnit.SECONDS);
            this.uploadId = multipartUpload.uploadId();
            return this;
        }
        catch (InterruptedException | ExecutionException e) {
            throw new IOException("Could not start S3 multipart upload: " + e.getCause().getMessage(), e);
        }
        catch (TimeoutException e) {
            throw new IOException("Could not start S3 multipart upload, connection timeout", e);
        }
    }

    private void validateCleanStart() throws IOException {
        if (Objects.isNull(this.uploadId) && this.parts.isEmpty()) {
            return;
        }
        throw new IOException("Unable to start multipart backup upload, uploader has a previous upload id");
    }

    @Override
    public void partUpload(byte[] chunk) throws IOException {
        if (this.uploadException.get() != null) {
            throw this.uploadException.get();
        }
        this.executorService.execute(new S3PartUpload(this.s3, this.enableChecksumCheck, ++this.partNumber, this.parts, this.bucket, this.fileKey, this.uploadId, chunk, this.uploadException));
    }

    @Override
    public void complete(byte[] chunk) throws IOException {
        logger.info("Completing upload to s3");
        if (chunk.length > 0) {
            this.partUpload(chunk);
        }
        try {
            this.executorService.shutdown();
            if (!this.executorService.awaitTermination(S3Utils.getHttpClientWriteTimeout(), TimeUnit.SECONDS)) {
                throw new IOException("Part upload timeout");
            }
            if (this.uploadException.get() != null) {
                throw this.uploadException.get();
            }
            List sorted = this.parts.stream().sorted(Comparator.comparing(CompletedPart::partNumber)).collect(Collectors.toList());
            this.s3.completeMultipartUpload((CompleteMultipartUploadRequest)CompleteMultipartUploadRequest.builder().uploadId(this.uploadId).bucket(this.bucket).key(this.fileKey).multipartUpload((CompletedMultipartUpload)CompletedMultipartUpload.builder().parts(sorted).build()).build()).get();
            logger.info("Backup multipart upload completed successfully");
        }
        catch (Exception e) {
            throw new IOException("Failed to complete s3 multipart upload", e);
        }
    }

    @Override
    public void abort() {
        try {
            do {
                this.s3.abortMultipartUpload((AbortMultipartUploadRequest)AbortMultipartUploadRequest.builder().uploadId(this.uploadId).bucket(this.bucket).key(this.fileKey).build()).get(60L, TimeUnit.SECONDS);
            } while (((ListPartsResponse)this.s3.listParts((ListPartsRequest)ListPartsRequest.builder().uploadId(this.uploadId).bucket(this.bucket).key(this.fileKey).build()).get(60L, TimeUnit.SECONDS)).hasParts());
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            logger.error("Backup multipart upload failed to abort. uploaded parts might need a manual clean up: {}", (Object)e.getMessage());
        }
        finally {
            this.executorService.shutdownNow();
        }
        logger.error("Backup multipart upload aborted");
    }
}

