/*
 * Decompiled with CFR 0.152.
 */
package pitt.search.semanticvectors.viz;

import ch.akuhn.edu.mit.tedlab.DMat;
import ch.akuhn.edu.mit.tedlab.SVDRec;
import ch.akuhn.edu.mit.tedlab.Svdlib;
import pitt.search.semanticvectors.FlagConfig;
import pitt.search.semanticvectors.ObjectVector;
import pitt.search.semanticvectors.Search;
import pitt.search.semanticvectors.vectors.IncompatibleVectorsException;
import pitt.search.semanticvectors.vectors.RealVector;
import pitt.search.semanticvectors.vectors.ZeroVectorException;
import pitt.search.semanticvectors.viz.Plot2dVectors;

public class PrincipalComponents {
    ObjectVector[] vectorInput;
    DMat matrix;
    Svdlib svd;
    SVDRec svdR;
    int dimension;

    public PrincipalComponents(ObjectVector[] vectorInput) {
        this.vectorInput = vectorInput;
        this.dimension = vectorInput[0].getVector().getDimension();
        double[][] vectorArray = new double[vectorInput.length][this.dimension];
        for (int i = 0; i < vectorInput.length; ++i) {
            if (vectorInput[i].getVector().getClass() != RealVector.class) {
                throw new IncompatibleVectorsException("Principal components class only works with Real Vectors so far!");
            }
            if (vectorInput[i].getVector().getDimension() != this.dimension) {
                throw new IncompatibleVectorsException("Dimensions must all be equal!");
            }
            RealVector realVector = (RealVector)vectorInput[i].getVector();
            float[] tempVec = (float[])realVector.getCoordinates().clone();
            for (int j = 0; j < this.dimension; ++j) {
                vectorArray[i][j] = tempVec[j];
            }
        }
        this.matrix = new DMat(vectorArray.length, vectorArray[0].length);
        this.matrix.value = vectorArray;
        System.err.println("Created matrix ... performing svd ...");
        Svdlib svd = new Svdlib();
        System.err.println("Starting SVD using algorithm LAS2");
        this.svdR = svd.svdLAS2A(Svdlib.svdConvertDtoS(this.matrix), this.matrix.cols);
    }

    public void plotVectors() {
        DMat reducedVectors = this.svdR.Ut;
        ObjectVector[] vectorsToPlot = new ObjectVector[this.vectorInput.length];
        int truncate = 4;
        for (int i = 0; i < this.vectorInput.length; ++i) {
            float[] tempVec = new float[truncate];
            for (int j = 0; j < truncate; ++j) {
                tempVec[j] = (float)reducedVectors.value[j][i];
            }
            vectorsToPlot[i] = new ObjectVector(this.vectorInput[i].getObject().toString(), new RealVector(tempVec));
        }
        Plot2dVectors myPlot = new Plot2dVectors(vectorsToPlot);
        myPlot.createAndShowGUI();
    }

    public static void main(String[] args) throws ZeroVectorException {
        FlagConfig flagConfig = FlagConfig.getFlagConfig(args);
        args = flagConfig.remainingArgs;
        ObjectVector[] resultsVectors = Search.getSearchResultVectors(flagConfig);
        PrincipalComponents pcs = new PrincipalComponents(resultsVectors);
        pcs.plotVectors();
    }
}

